c
c     Program Poles_adjust.f
c     ----------------------
c
c     Program Poles_adjust.f uses the pole
c     perturbations defined by the program
c     poles_inv.f to produce a new
c     series of poles.
c
c     Program details
c     ---------------
c
c     Original program  P. R. Shaw
c     Modified program  R. W. Woollett
c     Final program A. P. Nankivell
c     Modifications G. Eagles
c
c
      implicit none

      integer lpl, lpr, npoles
      integer lgin, lgout, nx
      integer iter, i, ipol, j, indx

      double precision dec, stlat, stlon, stang, gap
      double precision pangsep

      character * 2  ch_iter
      character * 6  pairid
      character * 40 direc
      character * 60 openfile


c....... declare parameters

c....  max # poles
      parameter (  lpl = 40 ) 

c....  max # params to solve for. 
      parameter (  lpr = 3 * lpl )


c....... declare arrays

      character*4 IDPOL( lpl )

      double precision X( lpr ) 

      double precision FPOLES( lpl, 3)

      double precision R1(3,3), R2(3,3), ST(3,3)
c
c---- define path to data files
c
c      data direc /'/home/piglet_data2/adriann/recon/data/'/
      data direc /'data/'/
c
c---- define i/o units
 
      data lgin, lgout / 7, 8 /

c
      write(*,'(a)') '-- POLES_ADJUST --'
c
c---- input new pole perturbations
 
      call strcat( direc, 'x.dat', openfile)
      open( lgin, file = openfile, status = 'old' )

      read( lgin, * ) nx

      if( nx .gt. lpr ) then

        write( 6, 10 ) nx, lpr
10      format(/,5x,'Error : Number of input pole perturbations',/,
     .           5x,'exceeds initial size of array X.',/,
     .           5x,'nx = ',i3,' lpr = ',i3,/)

        stop

      end if

      do 20 i = 1, nx
        read( lgin, * ) X( i )
20    continue

      close( lgin )
c
c---- determine current iteration

      call strcat( direc, 'iter.dat', openfile)
      open( lgin, file = openfile, status = 'old' )

      read( lgin, 30 ) iter
30    format(20x,i2)

      close( lgin )
c
c---- convert iter to character form

      call int2char( iter, ch_iter)
c
c---- open current rotation pole file

      call strcat( direc, 'poles_'//ch_iter//'.dat', openfile)
      write(*,'(a)') ' opening file '//openfile

      open( lgin , file = openfile, status = 'old' )
c
c---- enter pole parameters

      call readpolesfile( lgin, lpl, npoles, FPOLES, IDPOL, pairid)

      close( lgin )

      if( 3 * npoles .ne. nx ) stop '3 * npoles .ne. nx'
c
c---- modify current pole parameters 

      do 100 ipol = 1, npoles

        indx = 3 * ( ipol - 1 )

        do 50 j = 1,3
          FPOLES( ipol, j ) = FPOLES( ipol, j) + X( indx + j )
50      continue


c
c....... - don't send lat above 90
c
        if ( dabs(FPOLES(ipol,1) ) .gt. 90.) then
          FPOLES(ipol,1) = FPOLES( ipol, 1) - X( indx + 1)
	endif
c
c  alternatives
c....... - limit lat to +-90 (apn 95) 
c          FPOLES(ipol,1) = dsign(90. ,FPOLES(ipol,1)) 
c.......  - flip to other side
c          FPOLES(ipol,1) = dsign(180.,FPOLES(ipol,1)) - FPOLES(ipol,1)
c          FPOLES(ipol,2) = FPOLES(ipol,2) + 180.0
c
c....... - limit lon to +-180 (apn 95)
c
        if ( FPOLES(ipol,2)  .gt. 180.)
     .    FPOLES(ipol,2) =  FPOLES(ipol,2) -360.0

        if ( FPOLES(ipol,2)  .lt. -180.)
     .    FPOLES(ipol,2) =  FPOLES(ipol,2) + 360.0


 	goto 123
c
c........ - also, make sure that we don't have convergence of plates
c         i.e rotation angle of eastern stage pole < 0 . If necessary 
c         may have to not change rot angle at all
c
        if ( ipol .eq. 1 .and. FPOLES(ipol,3) .lt. 1.0D-03) then

          FPOLES(ipol,3) = 1.0D-03

        else if ( ipol .gt. 1 ) then

          dec =  dabs( X( indx + 3 )/4. )
c	  if (dec .lt. 0.001 ) dec = 0.001

c........... first, calculate stage pole angle

666       call pol2mat( FPOLES(ipol-1,1), FPOLES(ipol-1,2),
     .                                    -FPOLES(ipol-1,3), R1)
          call pol2mat( FPOLES(ipol,1), FPOLES(ipol,2),
     .                                     FPOLES(ipol,3), R2)
          call sumrots(R1, R2, ST )
          call mat2pol(ST, stlat, stlon, stang)

c	  print *, 'ipol  st:',ipol, stlat, stlon, stang

c............. check stage pole is on same hemisphere as rotation
c		poles, otherwise it's ok to be neg.

          gap = pangsep( FPOLES(ipol,1), FPOLES(ipol,2),
     .                                          stlat, stlon)

          if ( stang .lt. 0 .and. gap .lt. 90. .or.
     .         stang .gt. 0 .and. gap .gt. 90. ) then

c		we have convergence

            write(6,99) ipol,stlat,stlon,stang,x(indx+3),gap
            write(6,98) ipol-1, FPOLES(ipol-1,1), FPOLES(ipol-1,2),
     .                                                FPOLES(ipol-1,3)
            write(6,98) ipol, FPOLES(ipol,1), FPOLES(ipol,2),
     .                                                FPOLES(ipol,3)

            FPOLES(ipol,3) = FPOLES(ipol,3) + dec
            goto 666

          endif
        endif

98     format('Pole ',i3,' lat:',f8.4,' lon:',f8.4,' ang:',f8.4)
99     format(/,5x,'WARNING : New poles give convergence for pole '
     .  ,i3,/,5x,'gives Stage pole (',f8.4,',',f8.4,',',f8.4,')',
     .        /,5x,'Original adipolustment was ',f8.4,' gap: ',f8.4)

123	continue
100   continue

c
c---- create new pole parameter file
c
      iter = iter + 1

      call int2char( iter, ch_iter )

      call strcat( direc, 'poles_'//ch_iter//'.dat', openfile)
      write(*,'(a)') ' opening file '//openfile

      open( lgout, file = openfile, status = 'unknown' )

      call writepolesfile( lgout, lpl, npoles, FPOLES, IDPOL, pairid)

      close( lgout )
c
c---- update iteration number
c
      call strcat( direc, 'iter.dat', openfile)
      open( lgout, file = openfile, status = 'old' )

      write( lgout, 200 ) iter
200   format(1x,'Iteration number = ',i2)

      close( lgout ) 

      stop ' ** poles_adjust finished **'
 9999 stop ' !! ERROR !!'
      end
