c
c NB note to myself: you had trouble for days with this because you
c didn't declare array variables separately after the other variables
c 
c    Graeme Eagles. January 2002.
c
c UPDATE April 2012: can now call double precision trigonometry
c functions with linking dbltrig.a library
c
      program pole_interpolator
      implicit none

      integer maxpoles,npoles,k,i
      real interv,frac,j
      parameter (maxpoles=999)

      character*20 polfile,outfile
      double precision fpoles(maxpoles,3)
      double precision intpol(maxpoles,3)
      double precision outpol(maxpoles,3)
      double precision mat1(3,3)
      double precision mat2(3,3)
      double precision out(3,3)
      
      real age(maxpoles)
      

      call getarg (1,polfile)
      call getarg (2,outfile)

        WRITE (6,*) '________________________________________________'
        WRITE (6,*) '|                                               |'
        WRITE (6,*) '|   pole_interpolator - interpolates poles      |'
        WRITE (6,*) '| at a given time interval between finite poles |'
        WRITE (6,*) '|                                               |'
        WRITE (6,*) '| Manufacturers advice: wear protective goggles |'
        WRITE (6,*) '|_______________________________________________|'
        WRITE (6,*) ' '
        WRITE (6,*) ' '

      write(6,*)'Give interval for interpolation, in million years'
      read(5,*)interv
      open (unit=10, file=polfile, status='old', err=999)

c determine size of array taking npoles
c      call npdec(polfile,npoles)

c read input poles
      call readpoles(polfile,maxpoles,fpoles,npoles,age)
      
c calculate interval poles
      call intervpol(fpoles,intpol,maxpoles,npoles,age)

c calculate 1million yr step poles and write to file
c do this for all fpoles (counter j)

      open (unit=11, file=outfile, status='unknown', err=999)
      write(11,*)'age lon lat ang: Interpolated poles from ',polfile
 2    format(f6.2,3f10.3)
      
      age(1)=0.0
      j=interv
      do 10 k=1,npoles
 3     if (j .lt. age(k)) then
          frac=(age(k)-j)/(age(k) - age(k-1))
c          write(6,*) frac
          call pol2mat(fpoles(k,1),fpoles(k,2),
     .                             dble(fpoles(k,3)),mat1)
          call pol2mat(intpol(k,1),intpol(k,2),
     .         dble(intpol(k,3)*frac),mat2)
          call sumrots(mat1,mat2,out)
          call mat2pol(out,outpol(j,1),outpol(j,2),outpol(j,3))
          write (11,2)j,outpol(j,2),outpol(j,1),outpol(j,3)
          j=j+interv
          go to 3
         end if
 10    continue

      close(10)
      close(11)
      write(6,*)'All done'
      stop

 999  stop'File error. Usage: pole_interpolator infile outfile'

      end







C                 Yea, here beginneth the subroutines
c-------------------------------------------------------------------
c subroutine to work out array dimension declarator for npoles
c
c       subroutine npdec(polfile,npoles)
c
c      implicit none
c      integer npoles,i
c      character*20 polfile
c      
C Part that counts number of lines in IP poles file to work out npoles
c
c      open (unit=10, file=polfile, status='old')
c       npoles=0
c 5      read(10,*,end=8) i
c        npoles=npoles+1
c        go to 5
c 8    continue
c      write(6,*)npoles
c
c      close(10)
c      return
c      end
c

c-------------------------------------------------------------------

c
       subroutine readpoles(polfile,maxpoles,fpoles,npoles,age)

      implicit none
   
      integer a,i,maxpoles,npoles
      character*20 polfile
      double precision fpoles(maxpoles,3)
      real age(maxpoles)


      open (unit=10, file=polfile, status='old')

      a=0
      i=0
      npoles=0 

c if there is no zero age rotation, then make one
         read(10,'(4f13.6)',end=10, err=999) 
     .      FPOLES(1,1), FPOLES(1,2), FPOLES(1,3), age(1)
          if (age(1) .ne. 0.0) then
           age(1)=0.0
           FPOLES(1,3)=0.00
           i=1
          end if
      continue

9     rewind(10)           
      write (6,*) 'Your rotations for interpolation:'
      write (6,*) i,'  '

10    continue     

c      npoles=npoles+1
      i=i+1
       

c read lat lon angle age of poles
         read(10,'(4f13.6)',end=15, err=999) 
     .      FPOLES(i,1), FPOLES(i,2), FPOLES(i,3), age(i)


cc         if (fpoles(i,3) .lt. 1.0 .and. fpoles(i,3) .gt. 0.0)
cc     .   then
c          npoles=npoles-1
cc          i=i-1 
cc         end if

      npoles=i
c      write(6,*)npoles

      go to 10

c     show user the poles just read

15    continue

      if (a .lt. i) then
       write (6,*) a,FPOLES(a,1),FPOLES(a,2),FPOLES(a,3), age(a)
       a=a+1
      go to 15
      end if
      

c20    continue
      close(10)

      return
999   stop'error opening poles file'
      end

C---------------------------------------------------------------------

c
       subroutine intervpol(fpoles,intpol,maxpoles,npoles,age)
c
c this calculates the pole T2rotT1, that describes total movement
c between two times, T2 and T1. Each of the interval poles is given
c by T2 - T1.

      implicit none
      integer i,maxpoles,npoles
      double precision fpoles(maxpoles,3)
      double precision intpol(maxpoles,3)
      double precision mat1(3,3)
      double precision mat2(3,3)
      double precision out(3,3)
      real age(maxpoles)
   
c For fpoles(1,) the interval pole is the same as the finite pole
c if we have active plate motion 

       write(6,*) npoles

       i=1
       do 10 i=1,npoles
        if (age(i) .eq. 0.0) then
         write(6,*) i,age(i)
         write(6,*) 'found a 0.00 ma pole'
         intpol(i,1)=fpoles(i,1)
         intpol(i,2)=fpoles(i,2)
         intpol(i,3)=-1*fpoles(i,3)
c         write(6,*)i,intpol(i,1),intpol(i,2),intpol(i,3)

c For fpoles(2&onwards) the interval pole is -1*fpoles(i) + fpoles(i-1)
c to do this need to call sumrots from Adrian
 
        else
         write(6,*) i,age(i)
         call pol2mat(fpoles(i,1),fpoles(i,2),
     .                             dble(-1*fpoles(i,3)),mat1)
         call pol2mat(fpoles(i-1,1),fpoles(i-1,2),
     .                             dble(fpoles(i-1,3)),mat2)
         call sumrots(mat1,mat2,out)
         call mat2pol(out,intpol(i,1),intpol(i,2),intpol(i,3))
c         write(6,*)i,intpol(i,1),intpol(i,2),intpol(i,3)
        end if
  10   continue
       return
       end




c-------------------------------------------------------------------------
c
      subroutine pol2mat(t,p,a, R)
c
c
c     subroutine pol2mat         Aug 95          A Nankivell
c
c
c     the subroutine creates the 3*3 rotation matrix R for a rotation
c     by angle a about pole with latitude theta=t, longitude phi=p.
c
c     the calculations are carried out in double precision.
c
c          all angles taken in degrees, worked in radians
c
      implicit none

      double precision t, p, a, R(3,3), raddeg
c
      double precision PVEC(3)
C
c       write(6,*) 'In pol2mat'
c       write(6,*) t,p,a
c
c want angle degrees in radians, then multiply by raddeg. 
c Radians in degrees? Divide by raddeg.

      raddeg=0.1745329251994329D-01

      call pnt2vec(t, p, PVEC)
                                                                    
      R(1,1) = PVEC(1)*PVEC(1)*(1 - dcos(a*raddeg)) + dcos(a*raddeg)
      R(1,2) = PVEC(1)*PVEC(2)*(1 - dcos(a*raddeg)) - 
     .                                       PVEC(3)*dsin(a*raddeg)
      R(1,3) = PVEC(1)*PVEC(3)*(1 - dcos(a*raddeg)) + 
     .                                       PVEC(2)*dsin(a*raddeg)

      R(2,1) = PVEC(2)*PVEC(1)*(1 - dcos(a*raddeg)) + 
     .                                       PVEC(3)*dsin(a*raddeg)
      R(2,2) = PVEC(2)*PVEC(2)*(1 - dcos(a*raddeg)) + dcos(a*raddeg)
      R(2,3) = PVEC(2)*PVEC(3)*(1 - dcos(a*raddeg)) - 
     .                                       PVEC(1)*dsin(a*raddeg)

      R(3,1) = PVEC(3)*PVEC(1)*(1 - dcos(a*raddeg)) - 
     .                                       PVEC(2)*dsin(a*raddeg)
      R(3,2) = PVEC(3)*PVEC(2)*(1 - dcos(a*raddeg)) + 
     .                                       PVEC(1)*dsin(a*raddeg)
      R(3,3) = PVEC(3)*PVEC(3)*(1 - dcos(a*raddeg)) + dcos(a*raddeg)


      return
      end




c------------------------------------------------------------------------

      subroutine sumrots( R1MAT, R2MAT, S)
c
c     the subroutine sums rotations R1 followed by R2 to yield an equivalent 
c     pole, S.
c     the individual rotations are latitude,
c     longitude, angle in decimal degrees.
c     the sign conventions are:
c                  latitude positive north
c                  longitude positive east
c                  angle positive in the right handed sense
c     calculations are carried out in double precision.
c
      implicit none

      double precision R1MAT(3,3), R2MAT(3,3), S(3,3)
c
      integer i, j, k
      double precision sum
c
c       write(6,*) 'In sumrots'
 
      do 10 i = 1 , 3 
        do 20 j = 1 , 3 
          sum = 0.
          do 30 k = 1 ,  3 
            sum =  sum + R2MAT(i,k) * R1MAT(k,j)
30        continue
          S(i,j) = sum
20      continue
10    continue 

c
      return
      end


c----------------------------------------------------------------------




c
      subroutine mat2pol(R,theta,phi,alpha)
c
c
c     subroutine mat2pol          Aug 95          A.Nankivell
c
c
c     the subroutine calculates the rotation axis (latitude theta, longitude phi)
c     and rotation angle (alpha) of the rotation matrix R.
c
c     the calculations are carried out in double precision.
c
c	all angles passed in degrees, processed in radians
c
      implicit none

      double precision raddeg, theta, phi, alpha, R(3,3)
c
      double precision s,u,v,w,z

c       write(6,*) 'In mat2pol'

c
      raddeg=0.1745329251994329D-01

      s = R(1,1) + R(2,2) + R(3,3) - 1

      u = R(3,2) - R(2,3)
      v = R(1,3) - R(3,1)
      w = R(2,1) - R(1,2)

      z = dsqrt(u**2 + v**2 + w**2)

 
      if ( z .eq. 0.) then
        theta = 0.
      else
        theta = (dasin( w / z )/raddeg)
      endif

      phi= (datan2( v , u )/raddeg)
 
      alpha = (datan2 ( z , s )/raddeg)

         
c
      return
      end


c--------------------------------------------------------------

c
      subroutine pnt2vec(plat, plon, V)
c
c     subroutine pnt2vec         Aug 95        Adrian Nankivell
c
c     converts a lat,lon point  to a vector on a unit sphere
c
c     calculations carried out in double precision
c
c     angles received in degrees and processed in radians
c
      implicit none

      double precision raddeg, plat, plon, V(3)

      raddeg=0.1745329251994329D-01
c
c       write(6,*) 'In pnt2vec'

c        write(6,*) plat,plon

      V(3) = dsin(plat*raddeg)
      V(2) = dcos(plat*raddeg) * dsin(plon*raddeg) 
      V(1) = dcos(plat*raddeg) * dcos(plon*raddeg) 

c      already normalised, so return

      return
      end

