c    Program magprepro.f 
c..................................................
c Fits a great-circle to magnetic anomaly picks
c
c Original program Peter R. Shaw
c Re-written / updated Adrian P Nankivell
c
c..................................................
c
      implicit none
c
      integer lpl, lmpk, n4gc
      integer ipol, npoles, nrsecs, nanomgrps
      integer pickid, npick
      integer FALSE, TRUE
      integer npixmax, npixmaxside, npixmaxpol
      integer gc2side, gc2pole
      integer iploop, iside, oppside, iiside, iipol
      integer n_gcstot, ngcs
      integer j, ifitcode, ict, gcside, gcpol

      double precision lat, lon, err
      double precision pangsep, dabs, dmax1
      double precision P1(3), P2(3), GCP(3)
      double precision alat, alon, blat, blon

      character*3 pl_in
      character*4 id_in
      character*6 pairid
      character*40 info
c
c....... declare parameters

c....  max # poles
      parameter ( lpl = 50 ) 

c....  max # magnetics picks in one anomaly group:  
      parameter ( lmpk = 5000 )

c... no of anoms reqd before gt circle is fitted
      parameter( n4gc = 3 )

c....  boolean 

      parameter( FALSE = 0 )
      parameter( TRUE = 1 )

c....... declare arrays

c.........anomaly groups are stored sorted into poles, not
c.             int the order they are read
c.        indexes are (side of plate), (index of pole), (pick no.)

      integer NPICKS(2,0:lpl), GCUSE(2,0:lpl), N_SERIAL(2,0:lpl,lmpk)

      double precision PLAT(2, 0:lpl,lmpk), PLON(2, 0:lpl, lmpk)
 
c............. arrays for storing Great circle info

      double precision GCPTSLAT(lmpk), GCPTSLON(lmpk)
      double precision GCLAT(2, 0:lpl), GCLON(2, 0:lpl)
      double precision GCPLOT(2, 0:lpl, 4)
      double precision ERRMAX(2, 0:lpl), SQERR(2, 0:lpl)

      character*3 PLATE(2)
      character*4 IDPOL(0:lpl)

c.......... hardwire in central anomaly as c1
c
      data IDPOL(0) / '  c1' /

      print*, ''
      print*, '*** MAGPREPRO ***'
      print*, ''
    
      call openfile('filename with picks to be sorted:','read',1)

      call openfile('relevant poles filename:','read',2)

      call openfile('output filename:','write',3)
      call openfile('gc plot data filename:','write',11)
      call openfile('gc pick data filename:','write',12)


      print *,''
3     print *,' Fit GCs to only 3-pick groups          - enter 3'
      print *,'      also to a selected 2-pick group   - enter 2'
      print *,' and rotate single picks to each other  - enter 1'
      print *,' only rotate to conjugate anomalies     - enter 0'


      read(*,'(i1)') ifitcode

      if( ifitcode .ne. 3 .and. ifitcode .ne. 2  .and. ifitcode .ne. 1
     .      .and. ifitcode .ne. 0)         goto 3

c
c....  read in pole identifiers from poles file
c
      read(2,'(a6,x,i2)') pairid, npoles

      if( npoles .gt. lpl ) stop 'too many poles'

      PLATE(1) = pairid(1:3)
      PLATE(2) = pairid(4:6)

      do 5 ipol = 1, npoles

         read(2,'(32x, a4)') IDPOL(ipol)

cd         write( *,'(a,i2,x,a)') 'pole ',ipol,':'//IDPOL(ipol)//':'


5     continue

      close(2)

c
c............ START processing picks from 'raw' magnetics file
c
c.............. start of loop for each ridge segment

      nrsecs = 0

10    continue

        nrsecs = nrsecs + 1

        write( *,'(a,i3,/)') 'Ridge Section:- ',nrsecs

	do 50 ipol = 0, npoles
		NPICKS(1, ipol) = 0
		NPICKS(2, ipol) = 0
50	continue

c.............. start of loop for each line read in

100	continue

c... read in next line (details of next pick / group separator )

		read(1,111,err=9999,end=5000) id_in, pl_in,
     .			 lat, lon, pickid
111		format( a4, x, a3, 2x, 2f10.4, x, i6)

c..................... check for end of anomaly group

		if(id_in.eq.'----' ) then
			go to 100

c..................... check for end of ridge or end of dataset

		else if( id_in .eq. 'xxxx' .or.
     .                      		id_in .eq. '....' ) then
			go to 1000
		endif

cd		print *,'>',id_in, pl_in, lat, lon, pickid

c............. determine plate and pole of pick
c		(store zero anomalies on plate 1)

		ipol= -1 
		do 500 iploop = 0, npoles
		    if ( id_in .eq. IDPOL(iploop) ) ipol = iploop
500		continue

		if( pl_in .eq. PLATE(1) .or. ipol .eq. 0 )then
			iside = 1
		else if( pl_in .eq. PLATE(2) ) then
			iside = 2
		else
			write(*, '(a)' ) 'plate '//pl_in//
     .                          ' not one of plate pair '//pairid
			stop
		endif

c........  if pole not recognised don't use and read in next pick

		if( ipol .eq. -1) then
			goto 100
		endif


c........... else store in relevant arrays

		npick = NPICKS(iside, ipol) + 1
		if ( npick .gt. lmpk ) then
			print *, 'too many picks in group ',
     .				 pl_in,' ', id_in
			stop 
		endif

		PLAT(iside, ipol, npick) = lat
		PLON(iside, ipol, npick) = lon
		N_SERIAL(iside, ipol, npick) = pickid
		NPICKS(iside, ipol) = npick


        go to 100

c..........READ IN ALL OF 1 RIDGE SEGMENT
c
c
c
c
c
c
c......>>>>>>>>>>>>>>>>>>>  process anomaly groups to fit great circles

1000    nanomgrps = 0
	npixmax = 0
	gc2side = -1
	gc2pole = -1
	n_gcstot = 0

c...................... LOOP for each possible anomaly group
		
        do 1500 iside = 1, 2
          do 1500 ipol = 0, npoles 

	    info =''

            GCUSE(iside,ipol) = FALSE

c.........   fit great circle if enough picks:

	    if ( NPICKS(iside,ipol) .ge. 3 ) then


		do 1100 j=1, NPICKS(iside,ipol)
			GCPTSLAT(j) = PLAT(iside,ipol,j)
			GCPTSLON(j) = PLON(iside,ipol,j)
1100		continue

        	call gcfit( GCPTSLAT, GCPTSLON, NPICKS(iside,ipol),
     .                          GCLAT(iside,ipol), GCLON(iside,ipol), 
     .                     alat, alon, blat, blon )

                GCPLOT(iside,ipol,1) = alon
                GCPLOT(iside,ipol,2) = alat
                GCPLOT(iside,ipol,3) = blon
                GCPLOT(iside,ipol,4) = blat 

		ERRMAX(iside,ipol)=0.
		SQERR(iside,ipol)=0.

		do 1200 j=1, NPICKS(iside,ipol)

		    err=dabs(90 - pangsep( GCPTSLAT(j), GCPTSLON(j),
     .                     GCLAT(iside,ipol), GCLON(iside,ipol)) )
		    SQERR(iside,ipol) = SQERR(iside,ipol) + err**2
		    ERRMAX(iside,ipol) = dmax1( ERRMAX(iside,ipol),err)

1200		continue


		if(  NPICKS(iside,ipol) .ge. n4gc ) n_gcstot = n_gcstot +1

		info = ' - Great Circle fitted'

c.........  not enough picks for fitting best great circle, so find exact g.c.:

	    else if ( NPICKS(iside,ipol) .eq. 2 ) then

		call pnt2vec( PLAT(iside,ipol,1),
     .                    PLON(iside,ipol,1), P1)
		call pnt2vec( PLAT(iside,ipol,2),
     .                    PLON(iside,ipol,2), P2)
		call vecxprod( P1, P2, GCP)
		call vec2pnt(GCP, GCLAT(iside,ipol),
     .                          GCLON(iside,ipol) )

		SQERR(iside,ipol) = 0.
		ERRMAX(iside,ipol) = 0.

                GCPLOT(iside,ipol,1) =  PLON(iside,ipol,1)
                GCPLOT(iside,ipol,2) =  PLAT(iside,ipol,1)
                GCPLOT(iside,ipol,3) =  PLON(iside,ipol,2)
                GCPLOT(iside,ipol,4) =  PLAT(iside,ipol,2)
		
                info = ' - EXACT Great Circle calculated'


	    endif


c............ did we have any picks for this group?

	    if ( NPICKS(iside, ipol) .gt. 0) then

		nanomgrps = nanomgrps + 1

		write(*, 1301) PLATE(iside), IDPOL(ipol),
     .					NPICKS(iside,ipol), info

1301		format( 'Anomaly Group ', a3,x,a4,x,i3,' picks',a)

		if( NPICKS(iside,ipol) .gt. npixmax ) then
			npixmax = NPICKS(iside,ipol)
			npixmaxside = iside
			npixmaxpol = ipol
		endif

	    endif


1500	continue


	write(*,'(a,i3,a)') 'end of ridge section - ',nanomgrps,
     .                                          ' anomaly groups'
	

c-- --  -- -- -- -- NOW, work out which gc's to fit to which groups
c
c................... checking procedure first..............

c----------- if only one anomaly group - skip ........

        if (nanomgrps .le. 1 ) then

	  print *, 'Only 1 anomaly group - no fitting possible -',
     .          ' move on to next ridge section'
	  goto 3000


c	----- if only one pick for each anomaly group - skip , unless........

        else if (npixmax .eq. 1 .and. ifitcode .eq. 1) then

	  print *, 'Only 1 pick in each group - could rotate each',
     .			'pick to each other pick'
	  goto 1600

        else if (npixmax .eq. 1 .and. ifitcode .ne. 1) then

	  print *, 'Only 1 pick in each group - no fitting possible -',
     .          ' move on to next ridge section'
	  goto 3000


c	----- and if max number of picks in a group was 2........
c.................. select one gc to fit to..............

        else if (npixmax .eq. 2 .and. ifitcode .eq. 2 ) then

		write(*,'(a,i3,a,/,a)') 'Section ', nrsecs, 
     .     ' > Max. of 2 picks in a group',
     .    'Select number of anomaly group to fit GC to from list below'


		ict = 0

		write( *,1540) ict, 'fit', 'none'
1540		format(i2,' : ',a3,x,a4)

		do 1550 iside = 1, 2
		  do 1550 ipol = 0, npoles

			if ( NPICKS(iside, ipol) .lt. 2) then
			  goto 1549
			else
			  ict = ict + 1 
			  write( *,1540) ict, PLATE(iside), IDPOL(ipol)
			endif

1549		  continue
1550		continue

c           write(6,*) 'got to the read statement'
1551		read(*,'(i1)') j


		if ( j .eq. 0 ) then
c ................................. skip all anomalies, onto next section
                   goto 3000
                endif
		ict = 0
		do 1560 iside = 1, 2
		  do 1560 ipol = 0, npoles

			if ( NPICKS(iside, ipol) .lt. 2 ) goto 1560

			ict = ict + 1 

			if ( j .eq. ict ) then

				gc2side = iside
				gc2pole = ipol

                                GCUSE(iside, ipol) = TRUE

				goto 1561
			endif


1560		continue

c........ if here then no match - try again 
		print *,'NOT in list given'
		goto 1551

1561		continue

                n_gcstot = 1

c	----- and if max number of picks in a group was less than required (3)........

        else if (npixmax .lt. 3 .and. (ifitcode .eq. 3
     .                    .or. ifitcode .eq.0 )) then
              print *, 'No (proper) GCs for this ridge section - '//
     .                  'move on to next'
              goto 3000
	endif
c
c.......   GREAT CIRCLE SORTING COMPLETED 
c
c...........start pairing anomaly groups with great circles to rotate to
c

1600	continue

c..............................  loop for each possible anomaly group

	gcpol = -1
	gcside = -1

c                                 loop for side of ridge
	do 1900 iside = 1, 2 

	  if ( iside .eq. 1) then
	    oppside = 2
	  else if ( iside .eq. 2) then
	    oppside = 1
	  endif

c                                     loop for each pole
          do 1900 ipol = 0, npoles 
 
c............ do we have any picks for this group?

		if ( NPICKS(iside, ipol) .le. 0) then
			goto 1899

c........ was the max no points in a group 2 , in which case fit all anomalies
c	 to the same group as chosen earlier, if 2-fit chosen

		else if( npixmax .eq. 2 .and. ifitcode .eq. 2) then

			if( iside .ne. gc2side 
     .				.or. ipol .ne. gc2pole ) then

				gcpol = gc2pole
				gcside = gc2side

			else
		   		 write(*, '(a)' )
     .	 'no target for anom set '//PLATE(iside)//' '//IDPOL(ipol)
				 go to 1899
			endif


c................  else max picks was 3 or more, so look for conjugate anomaly first

		else if( NPICKS(oppside, ipol) .ge. n4gc ) then 

			gcpol = ipol
			gcside = oppside

		else if( ifitcode .eq.0   .and.
     .                           NPICKS(oppside, ipol).lt. n4gc ) then 

                   write(*, '(a)' )
     .	 'no conjugate for anom set '//PLATE(iside)//' '//IDPOL(ipol)
				 go to 1899

c................  else look for central anomaly

c		else if( ipol .ne. 0 .and. NPICKS( 1, 0) .ge. n4gc ) then 

c			gcpol = 0
c			gcside = 1

c..................no conjugate or central so now rotate to each anomaly


		else 

			if( NPICKS(iside, ipol) .ge. n4gc ) then
				ngcs = n_gcstot - 1
			else
				ngcs = n_gcstot
			endif

			if (ngcs .eq. 0 ) then
				write(*, '(a)' )
     .	 'no target for anom set '//PLATE(iside)//' '//IDPOL(ipol)
				go to 1899
			endif

			write(3,2001) IDPOL(ipol), PLATE(iside),
     .     			NPICKS(iside, ipol), ngcs

			do 1650 j=1, NPICKS(iside, ipol)

		     		write(3,2002) PLAT(iside, ipol, j),
     .			PLON(iside, ipol, j), N_SERIAL(iside, ipol, j)

1650			continue

			do 1700 iiside = 1, 2
			  do 1700 iipol = 0, npoles
			    if ( NPICKS(iiside, iipol) .ge. n4gc 
     .				.and. (iiside .ne. iside .or. 
     .					iipol .ne. ipol ) ) then 

	 		      write(3,2003) IDPOL(iipol), PLATE(iiside),
     .			GCLAT(iiside, iipol), GCLON(iiside, iipol), 
     .   111.2*dsqrt(SQERR(iiside, iipol)/dble(NPICKS(iiside, iipol))),
     .   111.2*ERRMAX(iiside, iipol) ,NPICKS(iiside, iipol)

			      write(*,'(a,x,a,x,a)') 
     .	'Rotating '//IDPOL(ipol),PLATE(iside)//' picks to '// 
     .	IDPOL(iipol),PLATE(iiside)//' great circle'

                              GCUSE(iiside,iipol) = TRUE

			    endif
1700			continue

			write(3,'(a)') 
     .      '------------------------------------------------'


			go to 1899

		endif


c......... we have single target, so output data into file

		ngcs = 1

1800		write(3,2001) IDPOL(ipol), PLATE(iside),
     .     				 NPICKS(iside, ipol), ngcs

		do 1810 j=1, NPICKS(iside, ipol)

		     write(3,2002) PLAT(iside, ipol, j),
     .			PLON(iside, ipol, j), N_SERIAL(iside, ipol, j)

1810		continue


	 	write(3,2003) IDPOL(gcpol), PLATE(gcside),
     .			GCLAT(gcside, gcpol), GCLON(gcside, gcpol), 
     .   111.2*dsqrt(SQERR(gcside, gcpol)/dble(NPICKS(gcside, gcpol))),
     .   111.2*ERRMAX(gcside, gcpol) ,NPICKS(gcside, gcpol)


		write(3,'(a)') 
     .      '------------------------------------------------'

		write(*,'(a,x,a,x,a)') 'Rotating '//IDPOL(ipol),
     .	PLATE(iside)//' picks to '//IDPOL(gcpol), PLATE(gcside)//
     .	' great circle'

                GCUSE(gcside,gcpol) = TRUE

1899		continue


1900	continue


2001	format(a4, x, a3, 2x, i6, x, i2)
2002	format(2f10.4, x, i6)
2003	format(a4, x, a3, 2x, 2f10.4, 2f6.2, i6)



c........   end of loop for anomaly sets, repeat whole for next ridge section
c
c................ check for end of file first

 3000   continue


c.................................... end of ridge section - output gc data		
        do 4100 iside = 1, 2
           do 4100 ipol = 0, npoles 
              if( GCUSE(iside,ipol) .eq. TRUE) then
c                      output gc line points to plot file
                 write(11,'(2(f9.4,x),/,2(f9.4,x),/,a)') 
     .                    GCPLOT(iside,ipol,1),GCPLOT(iside,ipol,2),
     .		          GCPLOT(iside,ipol,3),GCPLOT(iside,ipol,4),'>'

c                      output gc picks to plot file
                 do 4000 j = 1, NPICKS(iside,ipol)
                    write(12,111) IDPOL(ipol), PLATE(iside), 
     .              PLAT(iside,ipol,j),PLON(iside,ipol,j),
     .                  N_SERIAL(iside,ipol,j)
 4000            continue
              endif
 4100      continue

        if(id_in.eq.'....') go to 5000

        write( *,'(a,/)') 'xxxx - NEXT RIDGE SEGMENT'

      goto 10 

c............. processed ALL data

 5000 close(1)
      close(3)

      close(11)
      close(12)

      stop 'ok'

 9999 stop 'error'

      end


