c..   Program magpickproc
c..
c
c
      implicit none
c

      integer lpl, lpr, lmpk, ldt
      integer iter, npoles, npicks
      integer i, m, n, ios, lgout


      character*2  ch_iter
      character*6  pairid
      character*40 direc
      character*80 openfile

c....... declare parameters

c.... logical unit number for rotated pick output for display
      parameter (  lgout = 11 ) 


c....  max # poles
      parameter (  lpl = 50 ) 

c....  max # params to solve for. 
      parameter (  lpr = 3 * lpl )

c....  max # magnetics picks in one anomaly group:  
      parameter (  lmpk = 5000 )

c....  max # data points:  
      parameter (  ldt = 50000 )

c....... declare arrays

      integer NPERPOLE(0:lpl), S_ID(lmpk) 

      double precision A(ldt,lpr), B(ldt), W(ldt) 
      double precision FPOLES(lpl,3)
      double precision S_LOC(lmpk, 2), F_LOC(lmpk, 2), PK_LOC(ldt, 3)

      character*4 IDPOL(0:lpl)

c
c......... define directory containing data files
c
c
      data direc /'data/'/

c
c.......... hardwire in central anomaly as c1
c
      data IDPOL(0) / '  c1' /

c --------------------- start of real code ------------------
c
      write(*, '(/,a)') '-- MAGPICKPROC --'


c.......... determine number of iteration

      call strcat( direc, 'iter.dat', openfile)
      open( 1, file = openfile, status = 'old', iostat = ios )

      if( ios .ne. 0 ) then

        write( 6, 10 ) openfile, ios
10      format(/,5x,'error occurred opening file : ',a80,/,
     .           5x,'iostat error code = ',i8,//)

        stop

      end if

      read( 1, 51 ) iter
 51   format(20x,i2)

      close( 1 )

c......... synthesize Euler pole file name

      call int2char( iter, ch_iter)

      call strcat( direc, 'poles_'//ch_iter//'.dat', openfile)
      write(*,'(a)') ' opening file '//openfile

      open( 1, file = openfile, status = 'old', iostat = ios )

      if( ios .ne. 0 ) then
        write( 6, 10 ) openfile, ios
        stop
      end if        

c........... input rotation pole parameters

      call readpolesfile( 1, lpl, npoles, FPOLES, IDPOL(1), pairid )

      close(1)


c........ open output file for rotated pick information
c

      call strcat( direc, 'rotmagpicks.dat', openfile)
      open( lgout, file = openfile, status = 'unknown', iostat = ios )

      if( ios .ne. 0 ) then
        write( 6, 10 ) openfile, ios
        stop
      end if        

c..   process data using common subroutine
c

      call magpickproc(pairid, lpl, npoles, FPOLES, IDPOL,
     .         NPERPOLE, lmpk, S_LOC, S_ID, F_LOC, lgout, ldt, lpr,
     .         npicks, PK_LOC, A, B, W)


c ............ all data processed

      close(lgout)

      do 100 i = 0, npoles

        write(*,'(a,i4)') ' total # of  picks for anomaly '//
     .                       IDPOL(i)//' = ', NPERPOLE(i)

 100  continue

      m = npicks
      n = 3*npoles


      write(*,200) m, n
200   format(/,5x,'Partial differential matrix dimensions',//,
     .         5x,' m = ',i4,' n = ',i2,/)
c
c..   write out variables using n * (1x,f11.6) format
c
c..   output partial differential matrix
c
      call strcat( direc, 'mag_a.dat', openfile)
      open( 1, file = openfile, status = 'unknown', iostat = ios )

      if( ios .ne. 0 ) then
        write( 6, 10 ) openfile, ios
        stop
      end if        

      call writematrix( 1, ldt, lpr, m, n, A )

      close( 1 )
c
c..   output error vector
c
c
      call strcat( direc, 'mag_b.dat', openfile)
      open( 1, file = openfile, status = 'unknown',  iostat = ios )

      if( ios .ne. 0 ) then
        write( 6, 10 ) openfile, ios
        stop
      end if        

      call writevector( 1, ldt, m, B )

      close( 1 )
c
c..   output weight vector
c
      call strcat( direc, 'mag_w.dat', openfile)
      open( 1, file = openfile, status = 'unknown', iostat = ios )

      if( ios .ne. 0 ) then
        write( 6, 10 ) openfile, ios
        stop
      end if        

      call writevector( 1, ldt, m, W )

      close( 1 )
c
c..   output lat, lon & serial no (as double) of input data picks
c
      call strcat( direc, 'mag_loc.dat', openfile)
      open( 1, file = openfile, status = 'unknown', iostat = ios )

      if( ios .ne. 0 ) then
        write( 6, 10 ) openfile, ios
        stop
      end if        

      call writematrix( 1, ldt, 3, m, 3, PK_LOC )

      close( 1 )


      stop ' ** magpickproc finished **'
 9999 stop 'oops'

      end
