c
c.... Program Fzpickproc.f
c.... --------------------
c....
c.... Original program written by Peter R. Shaw
c.... Woods Hole Oceanographic Institution
c....
c.... Reference : Shaw, P. R. and S. C. Cande, High - resolution      
c.... inversion for South Atlantic plate kinematics using joint
c.... altimeter and magnetic anomaly data, J. geophys. Res., 95,
c.... pp. 2625 - 2644, 1990.
c....
c.... Version 2.0 - 11 th January 1993
c....
c.... Modified by Richard W. Woollett, British Antarctic Survey.
c.... Then by Adrian Nankivell , BAS and University of Oxford
c....
c.... Matlab calls replaced by Fortran subroutines
c....
c....

      implicit none
c
      integer lpl, lfpk, ldt, lpr
      integer ios, iter, npoles
      integer nloops, npicks
      integer jpole, ma, na, k


      character *2  ch_iter
      character *6  pairid
      character *40 direc
      character *80 openfile

c....  max # poles
      parameter (  lpl = 50 ) 

c....  # params to solve for. 
      parameter (  lpr = 3 * lpl )

c....  max # crossings per fz
      parameter (  lfpk = 1000 )

c....  # data points:  approx lfpk * #fzs 
      parameter (  ldt = 50000 )

c....  # iterations for seed calculation  
      parameter (  nloops = 2 )

c --------------- declare arrays -----------------

c....   Number of fz picks per stage
      integer NPERPOLE(lpl)

c....   Finite rotation poles (lat,lon,angle ) (don't need age)
      double precision FPOLES(lpl,3)
c....   Anomaly ID for finite rotation poles 
      character*4 IDPOL(0:lpl)

c....   Stage poles (lat,lon,angle)
      double precision STAGEAB(lpl,3), STAGEBA(lpl,3)

c....   Flowline points( 3-vectors)
      double precision  FLOW(0:lpl,3)

c....   Partial derivative matrices for the stage poles
      double precision DSTABDP(lpl,6,3), DSTBADP(lpl,6,3)

c....   Radial partial derivatives of flowline points
      double precision SEEDPD(lpl)

c....   Lat./lon. of picks for a fz
      double precision PICKLOCS(lfpk,2)

c....   Lat./lon. of all picks
      double precision PK_LOC(ldt,2)

c....   Partial derivative matrix A, error vector B 
      double precision A(ldt,lpr), B(ldt)

c....   Partial derivative matrix A_S, error vector B_S for seed inv.
      double precision A_S(lfpk,1), B_S(lfpk)

c....   Weight matrix W 
      double precision W(ldt)


c....   Define data directory path
c      data direc /'/home/piglet_data2/adriann/recon/data/'/
      data direc /'data/'/
c
c.......... hardwire in central anomaly as c1
c
      data IDPOL(0) / '  c1' /

c Graeme 2013 problem with nperpole assuming huge values - initialise

       do 4000 k = 1, lpl
        NPERPOLE(k)=0
4000   continue

c Graeme segment over

c
c --------------------- start of real code ------------------
c
      write(*, '(a)') '-- FZPICKPROC --'

c.... Determine iteration no.
c
      call strcat( direc, 'iter.dat', openfile)
      open( unit = 1, file = openfile, status = 'old',iostat=ios)

      if( ios .ne. 0 ) then

        write( 6, 10 ) openfile, ios
10      format(/,5x,'error occurred opening file : ',a80,/,
     .           5x,'iostat error code = ',i8,//)

        stop

      end if

      read( 1, 20 ) iter
20    format(20x,i2)

      close( 1 )
c
c.... convert integer iter to character ch_iter
c
      call int2char( iter, ch_iter )

c ...... open poles file

      call strcat( direc, 'poles_'//ch_iter//'.dat', openfile)
      write( 6, '(a)' ) 'opening file '//openfile

      open( unit = 1, file = openfile, status = 'old', iostat = ios )

      if( ios .ne. 0 ) then
        write( 6, 10 ) openfile, ios
        stop
      end if        
c
c.... read finite rotation poles from file
c:
c
      call readpolesfile( 1, lpl, npoles, FPOLES, IDPOL(1), pairid)

      close( 1 )

c................... now run using standard subroutine

      call fzpickproc( pairid, lpl, npoles, lfpk, ldt, 
     .        lpr, npicks, FPOLES, IDPOL, STAGEAB, STAGEBA, FLOW,
     .        DSTABDP, DSTBADP, SEEDPD, NPERPOLE, PICKLOCS,
     .        PK_LOC, A_S, B_S, nloops, A, B, W)


c ............ all data processed

      if (npicks .gt. ldt) stop ' too many FZ data points'

      write(*,'(/)') 

      do 200 jpole = 1, npoles

        write(*,'(a,i10)') ' total # of crossings for stage -> '//
     .                    IDPOL(jpole)//' = ', NPERPOLE(jpole)

200   continue
c
c.... Specify total number of picks and number of params
c
      ma = npicks
      na = 3 * npoles


c.... OUTPUT partial derivative matrix a, error vector b and the
c.... fracture zone pick coordinates.
c
c
      write( 6, 301 ) ma, na 
301   format(/,5x,'fz partial derivative matrix double precisions ',//,
     .         5x,'m = ',i4,' n = ',i2,//)


      call strcat( direc, 'flow_a.dat', openfile)
      open( unit = 1, file = openfile, status ='unknown',iostat = ios )

      if( ios .ne. 0 ) then

        write( 6, 10 ) openfile, ios

        stop

      end if

      call writematrix( 1, ldt, lpr, ma, na , A )

      close( 1 )
c
c.... output error vector
c
c
      call strcat( direc, 'flow_b.dat', openfile)
      open( 1, file = openfile, status = 'unknown',iostat = ios )

      if( ios .ne. 0 ) then
        write( 6, 10 ) openfile, ios
        stop
      end if

      call writevector( 1, ldt, ma, B )

      close( 1 )
c
c..   output weight vector
c
      call strcat( direc, 'flow_w.dat', openfile)
      open( 1, file = openfile, status = 'unknown' ,iostat = ios )

      if( ios .ne. 0 ) then
        write( 6, 10 ) openfile, ios
        stop
      end if

      call writevector( 1, ldt, ma, W )

      close( 1 )
c
c.... output fz pick latitude, longitude data arrays as matrix
c
      call strcat( direc, 'flow_loc.dat', openfile)
      open( 1, file = openfile, status = 'unknown', iostat = ios )

      if( ios .ne. 0 ) then
        write( 6, 10 ) openfile, ios
        stop
      end if

      call writematrix( 1, ldt, 2, ma, 2, PK_LOC )

      close( 1 )

      stop ' ** fzpickproc finished **'
      end
