c
      double precision function angpdcalc(A, B, DADp)
c
c     subroutine angpdcalc         Aug 95        Adrian Nankivell
c
c     calculates the partial derivative of the inverse cos of
c   a dot product, ie when calculating angles
c
c	we are calculating ang = acos(A.B)
c	  A is peturbed to DADp, what is d(ang)/dp ?
c
c     calculations carried out in double precision
c
c     all angles in degrees
c
      implicit none

      double precision A(3), B(3), DADp(3)
c
      double precision adotb 
      double precision vecdprod
c

      adotb = vecdprod(A, B)

      angpdcalc = - vecdprod( DADp, B) / dsqrt( 1. - adotb**2 )

      return
      end
