c
c      program confimp_calc3d.f
c      -------------------
c ORIGINAL PROGRAM BY ADRIAN NANKIVELL, 199*
C
C alterations August 2002 G Eagles: replaced calls to
C NAG routines for calls to public-domain alternatives. 
C See comments.
c
c alterations December 2008 G Eagles: replaced calls to 
c degree-type trigonometry functions with calls to radian-type
c functions. Now compiles with g77 under cygwin.
c
c
      implicit none
c
      integer mdat, mdatmax, nparmax
      integer lgin, lgouta, lgoutb, lgoutc
      integer mrow, mfz, mbfz, mlfz, nfz, mwfz, mfzrj, mfzrw
      integer mtf, mbtf, mltf, ntf, mwtf
      integer mtfrw, mtfrj
      integer mmag, mbmag, mlmag, nmag, mwmag, nmagpicks
      integer mmagrw, mmagrj
      integer i,j,k

      double precision  fzwin, tfwin,  magwin
      double precision  fzbias, tfbias,  magbias
      double precision  d2km,  test
      double precision  fzstd, tfstd, magstd
      double precision  weight, raddeg

c----  define maximum array dimensions
c

c....  max # data points (fz or tf or mag) :  
      parameter  ( mdat = 100000 )

c....  max # total data points :  
      parameter  ( mdatmax = 200000)

c....  max # params to solve for. 
      parameter  ( nparmax = 180 )

      parameter (  d2km = 111.2 ) 
c
c----  define main variables
c
      character * 40  direc
      character * 60  openfile
      character * 40  dummy
c
c
c
c----  define main arrays
c
c----  common arrays

      double precision A_IN( mdat, nparmax ), A_INNM( mdat, nparmax )
      double precision B_IN( mdat )
      double precision W_IN( mdat )

c----  specific arrays
 
      double precision WFZNM( mdat ), FZLOC(mdat,2), FZ_LOCI(mdat,3)
      double precision WTFNM(mdat), TFLOC(mdat,2), TF_LOCI(mdat,3)
      double precision WMAGNM( mdat ), MAGLOC(mdat,3), MAG_LOCS(mdat,3)
      double precision MAG_LOCI(mdat,4)

      double precision ACON( mdatmax, nparmax )

c
c....  declerations for importance calculations (inc NAG routines)

      double precision sum
      double precision A_INT(nparmax,mdat)
      double precision ATA(nparmax,nparmax)

      integer IPIV(nparmax), LWORK, INFO
      parameter (LWORK = nparmax * 64)

      double precision WORK(LWORK)
      character * 1  UPLO
      parameter (UPLO = 'L')

c....  declerations for confidence interval calculations 

      integer iter, npoles, ipol, mpos, IFAIL

      double precision plat, plon, pang
      double precision majang, minang, ax1, ax2, ax3
      double precision COVMAT(3,3), EVAL(3), EVEC(3,3)
      double precision AT(nparmax,mdatmax)

      character ch_iter*2, idpol*4, pairid*6


c----  declare external subroutines
c
C      external APROD, F04QAF, F07MJF, F07MDF, F02ABF
C NB no calls to aprod or f04qaf in the original
C
      external DSYTRF, DSYTRI, DSYEV
c
c----  define directory path to data files
c
      data direc /'data/'/
c     data direc /'/users/potential/apn/recon/data/'/
c
c----  define i/o units + nag error flag
c
      data lgin, lgouta, lgoutb, lgoutc, IFAIL / 7, 8, 9, 11, 0 /
c
c----  define variables required by nag subroutine
c
c----  integer variables
c
c----  DEC 2008  variable for radian-degree conversion
c
      raddeg=0.1745329251994329D-01
c
      write(*,'(a)') '-- CONFIMP_CALC2 --'

c........... get value for datawin from file inv.dat

      call STRCAT( direc, 'inv.dat', openfile)
      open( lgin, file = openfile, status = 'old' )

      read( lgin, '(a)' ) dummy
      read( lgin, '(a)' ) dummy
      read( lgin, '(a)' ) dummy
      read( lgin, '(3f8.0)' ) magwin, fzwin, tfwin
      read( lgin, '(a)' ) dummy
      read( lgin, '(3f8.0)' ) magbias, fzbias, tfbias

      close( lgin )

c     if set to 0 (or negative), or unset, use default values

      if ( magwin .le. 0.) magwin = 3.0D0
      if ( fzwin .le. 0.) fzwin = 3.0D0
      if ( tfwin .le. 0.) tfwin = 3.0D0

      write(*,'(3(x,a,x,f8.5))') 'magnetics window =', magwin,
     .     'fz window =', fzwin, 'transform window =', tfwin
      write(*,'(3(x,a,x,f8.5))') 'magnetics bias =', magbias,
     .     'fz bias =', fzbias, 'transform bias =', tfbias


c
c.......... enter estimated standard deviations of magnetic
c               isochron and fracture zone picks
c
      call STRCAT( direc, 'std.dat', openfile)
      open( lgin, file = openfile, status = 'old' )

      read( lgin, * ) fzstd, magstd, tfstd

      close( lgin )


c.......... first process FRACTURE ZONE inversion input data ............
c
c........  enter fracture zone pick misfit partial derivative matrix

      call STRCAT( direc, 'flow_a.dat', openfile)
      open( lgin, file = openfile, status = 'old' )

      read( lgin, * ) mfz, nfz

      if( mfz .gt. mdat .or. nfz .gt. nparmax ) then

        write( 6, 11 ) mfz, nfz, mdat, nparmax
11      format(/,5x,'error : input dimensions of matrix afz',/,
     .           5x,'exceed initial array size',/,
     .           5x,'mfz  = ',i4,' nfz    = ',i4,/,
     .           5x,'mdat = ',i4,' nparmax = ',i4,/)

        stop

      end if

      do 20 i = 1, mfz

        read( lgin, * ) ( A_IN( i, j ), j = 1, nfz )

20     continue

      close( lgin )
c
c.............. enter fracture zone pick residuals ( misfit )

      call STRCAT( direc, 'flow_b.dat', openfile)
      open( lgin, file = openfile, status = 'old' )

      read( lgin, * ) mbfz

      if( mbfz .ne. mfz ) then

        write( 6, 31 ) mbfz, mfz
31      format(/,5x,'error : incompatible number of rows in',/,
     .           5x,'data files flow_a.dat and flow_b.dat',/,
     .           5x,'mbfz = ',i4,' mfz = ',i4,/)

        stop

      end if

      do 40 i = 1, mfz

        read( lgin, * ) B_IN( i )

40     continue

      close( lgin )

c----  enter rms error of fracture zone
c
      call STRCAT(  direc, 'flow_w.dat', openfile)
      open( lgin, file = openfile, status = 'old' )
 
      read( lgin, * ) mwfz
 
      if( mwfz .ne. mfz ) then
 
        write( 6, 51 ) mwfz, mfz
51      format(/,5x,'error : incompatible number of rows in',/,
     .           5x,'data files flow_a.dat and flow_w.dat',/,
     .           5x,'mwfz = ',i4,' mfz = ',i4,/)

        stop

      end if


      do 60 i = 1, mfz

        read( lgin, * ) W_IN( i )

60    continue

      close( lgin )


c
c................  enter fracture zone pick locations
c
      call STRCAT( direc, 'flow_loc.dat', openfile)
      open( lgin, file = openfile, status = 'old' )

      read( lgin, * ) mlfz

      if( mlfz .ne. mfz ) then

        write( 6, 71 ) mlfz, mfz
71      format(/,5x,'error : incompatible number of rows in',/,
     .           5x,'data files flow_a.dat and flow_loc.dat',/,
     .           5x,'mlfz = ',i4,' mfz = ',i4,/)

        stop

      end if

      do 80 i = 1, mfz

        read( lgin, * ) FZLOC( i, 1 ), FZLOC( i, 2 )

80    continue

      close( lgin )


c
c----  determine relative weights 
c
      test = fzstd / d2km

      do 90 i = 1, mfz

        if( W_IN( i ) .lt. test ) W_IN( i ) = test
        W_IN( i ) = test / W_IN( i )

90    continue

c............... normalize fz pick derivative matrix and residual vector
c
      do 110 i = 1, mfz

        B_IN( i ) = B_IN( i ) * d2km / fzstd

        do 100 j = 1, nfz

          A_IN( i, j ) = A_IN( i, j ) * d2km / fzstd

100      continue

110    continue

c
c----  transfer matrix and vector to temporary storage
c----  removing outliers
c
      mrow = 0
      mfzrw = 0
      mfzrj = 0

      do 130 i = 1, mfz

        if( abs( B_IN( i ) ) .le. fzwin ) then

          mfzrw = mfzrw + 1

          do 120 j = 1, nfz
            A_INNM( mfzrw, j ) = A_IN( i, j )
120       continue

          WFZNM( mfzrw ) = W_IN( i )

          FZ_LOCI( mfzrw, 1 ) = FZLOC( i, 1)
          FZ_LOCI( mfzrw, 2 ) = FZLOC( i, 2)

        else
          mfzrj = mfzrj + 1
        end if

130   continue


      write( 6, 141 ) mfz, mfzrw, mfzrj
141   format(/,5x,'results of fracture zone pick residual',/,
     .         5x,'outlier removal',//,
     .         5x,'total number of rows     ',i4,/,
     .         5x,'number of good residuals ',i4,/,
     .         5x,'number of outliers      ',i4,/)


c
c---- premultiply A_INNM matrix by weights 
c (avoiding large diagonal matrix to save memory space and computation time)
c----  storing result straight into A, also into A_IN for importance calc.
c


      do 155 i = 1, mfzrw
    
            weight  = WFZNM( i ) * fzbias
            mrow = mrow + 1

            do 150 j = 1, nfz
               
               ACON(mrow,j) = A_INNM(i,j)

               A_IN(i,j) = A_INNM(i,j) * weight

 150        continue
     
 155  continue

     
c--------- NOW calculate data importances for fracture zone data

cd     print *,'Skipping fz importance calculations'
cd     goto 200

      do 160 i = 1, mfzrw
        do 160 j = 1, nfz

	  A_INT(j,i) = A_IN(i,j)

160   continue

      do 180 i = 1, nfz
        do 180 j = 1, nfz

          sum = 0.

          do 170 k = 1, mfzrw
            sum = sum + A_INT(i,k) * A_IN(k,j)
170        continue

	  ATA(i,j) = sum

180   continue
C
C
C NB Calls to NAG subroutines. These can be replaced by calls to LAPACK
C public domain subs. /opt/sx/MathKeisan/lib/liblapack.a (AWI).
C F07MDF replaced by DSYTRF.
C F07MJF replaced by DSYTRI.
C Both of these are direct swaps since the LAPACK routines are merely
C renamed according to NAG conventions, and have not been replaced 
C since Adrian wrote confimp_calc3d with NAG version ~16 library.
C
      call DSYTRF( UPLO, nfz, ATA, nparmax, IPIV, WORK, LWORK, INFO)
      call DSYTRI( UPLO, nfz, ATA, nparmax, IPIV, WORK, INFO)

C      call F07MDF( UPLO, nfz, ATA, nparmax, IPIV, WORK, LWORK, INFO)
C      call F07MJF( UPLO, nfz, ATA, nparmax, IPIV, WORK, INFO)

c..... the upper triangle of ATA now contains the lower triangle of (ATA)-1

c....  complete the full matrix (ATA)-1 first

      do 190 i = 1, nfz
        do 190 j = i+1, nfz 
          ATA(i,j) = ATA(j,i)
190   continue


c.... now calculate data importances

      do 199 k = 1, mfzrw

        sum = 0.

        do 198 i = 1, nfz
          do 198 j = 1, nfz

            sum = sum + A_IN(k,i) * ATA(i,j) * A_IN(k,j)

198     continue

        FZ_LOCI(k,3) = sum

199   continue

      write( *, '(a,/)') ' Fracture zone data Importances calculated'

cd 200 continue
c
c............now process TRANSFORM inversion input data ............
c
c----  enter transform pick misfit partial derivative matrix
c
      call STRCAT( direc, 'tf_a.dat', openfile)
      open( lgin, file = openfile, status = 'old' )

      read( lgin, * ) mtf, ntf 

      if( mtf .gt. mdat ) then

        write( 6, 201 ) mtf, mdat
201     format(/,5x,'error : number of rows in input transform',/,
     .           5x,'isochron pick misfit partial derivative',/,
     .           5x,'matrix exceeds initial array dimension',/,
     .           5x,'mtf = ',i4,' mdat = ',i4,/)

        stop

      end if

      if( ntf .ne. nfz ) then

        write( 6, 211 ) ntf, nfz
211     format(/,5x,'error : number of columns in input misfit',/,
     .           5x,'partial derivative matrices are incompatible',/,
     .           5x,'ntf = ', i3,' nfz = ',i3,/)

        stop

      end if

      do 220 i = 1, mtf

        read( lgin, * ) ( A_IN( i, j ), j = 1, ntf )

220   continue

      close( lgin )
c
c----  enter transform pick residuals ( misfit )
c
      call STRCAT( direc, 'tf_b.dat', openfile)
      open( lgin, file = openfile, status = 'old' )

      read( lgin, * ) mbtf

      if( mbtf .ne. mtf ) then

        write( 6, 231 ) mbtf, mtf
231     format(/,5x,'error : incompatible number of rows in',/,
     .           5x,'data files tf_a.dat and tf_b.dat',/)
 
        stop
 
      end if
 
      do 240 i = 1, mtf
 
        read( lgin, * ) B_IN( i )
 
240   continue
 
      close( lgin )
c
c----  enter weights 
c
      call STRCAT(  direc, 'tf_w.dat', openfile)
      open( lgin, file = openfile, status = 'old' )
 
      read( lgin, * ) mwtf
 
      if( mwtf .ne. mtf ) then
 
        write( 6, 250 ) mwtf, mtf
250    format(/,5x,'error : incompatible number of rows in',/,
     .           5x,'data files tf_a.dat and tf_w.dat',/,
     .           5x,'mwtf = ',i4,' mtf = ',i4,/)

        stop

      end if


      do 260 i = 1, mtf

        read( lgin, * ) W_IN( i )

260   continue

      close( lgin )


c----  enter transform pick locations
c
      call STRCAT( direc, 'tf_loc.dat', openfile)
      open( lgin, file = openfile, status = 'old' )

      read( lgin, * ) mltf

      if( mltf .ne. mtf ) then

        write( 6, 271 ) mltf, mtf
271     format(/,5x,'error : incompatible number of rows in',/,
     .           5x,'data files tf_a.dat and tf_loc.dat',/,
     .           5x,'mltf = ',i4,' mtf = ',i4,/)

        stop

      end if

      do 280 i = 1, mtf

        read( lgin, * ) TFLOC(i,1), TFLOC(i,2)

280   continue

      close( lgin )

c
c.............onto data processing .....................
c
c----  determine relative weights  
c
      test = tfstd / d2km

      do 290 i = 1, mtf

        if( W_IN( i ) .lt. test ) W_IN( i ) = test
        W_IN( i ) = test / W_IN( i )

290   continue
c
c----  normalize transform pick partial derivative
c----  matrix and residual vector
c
      do 310 i = 1, mtf

        B_IN( i ) = B_IN( i ) * d2km / tfstd

        do 300 j = 1, ntf
          A_IN( i, j ) = A_IN( i, j ) *  d2km / tfstd
300     continue

310   continue
c
c----  transfer matrix and vector to temporary storage
c----  removing outliers
c
      mtfrw = 0
      mtfrj = 0

      do 330 i = 1, mtf

        if( abs( B_IN( i ) ) .le. tfwin ) then

          mtfrw = mtfrw + 1

          do 320 j = 1, ntf
            A_INNM( mtfrw, j ) = A_IN( i, j )
320       continue

          WTFNM( mtfrw ) = W_IN( i )

          TF_LOCI( mtfrw, 1 ) = TFLOC( i, 1)
          TF_LOCI( mtfrw, 2 ) = TFLOC( i, 2)


        else
          mtfrj = mtfrj + 1
        end if

330   continue

      write( 6, 341 ) mtf, mtfrw, mtfrj
341   format(/,5x,'results of transform pick residual',/,
     .         5x,'outlier removal',//,
     .         5x,'total number of rows    ',i4,/,
     .         5x,'number of good residuals',i4,/,
     .         5x,'number of outliers      ',i4,/)
c
c
c---- premultiply A_INNM matrix by weights 
c (avoiding large diagonal matrix to save memory space and computation time)
c----  storing result straight into A, also into A_IN for importance calc.
c


      do 360 i = 1, mtfrw
    
            weight  = WTFNM( i ) * tfbias
            mrow = mrow + 1

            do 350 j = 1, ntf
               
               ACON(mrow,j) = A_INNM(i,j)

               A_IN(i,j) = A_INNM(i,j) * weight

 350        continue
     
 360  continue

c
c.......... now calculate data importances for transform data

cd     print *,'Skipping transform importance calculations'
cd     goto 440

      do 380 i = 1, mtfrw
        do 380 j = 1, ntf

	  A_INT(j,i) = A_IN(i,j)

380   continue

      do 400 i = 1, ntf
        do 400 j = 1, ntf

          sum = 0.

          do 390 k = 1, mtfrw
            sum = sum + A_INT(i,k) * A_IN(k,j)
390        continue

	  ATA(i,j) = sum

400   continue

      call DSYTRF( UPLO, ntf, ATA, nparmax, IPIV, WORK, LWORK, INFO)
      call DSYTRI( UPLO, ntf, ATA, nparmax, IPIV, WORK, INFO)

C      call F07MDF( UPLO, ntf, ATA, nparmax, IPIV, WORK, LWORK, INFO)
C      call F07MJF( UPLO, ntf, ATA, nparmax, IPIV, WORK, INFO)

c..... the upper triangle of ATA now contains the upper triangle of (ATA)-1

c....  complete the full matrix (ATA)-1 first

      do 410 i = 1, ntf
        do 410 j = i+1, ntf 
          ATA(i,j) = ATA(j,i)
410   continue


c.... now calculate data importances

      do 430 k = 1, mtfrw

        sum = 0.

        do 420 i = 1, ntf
          do 420 j = 1, ntf

            sum = sum + A_IN(k,i) * ATA(i,j) * A_IN(k,j)

420     continue

        TF_LOCI(k,3) = sum

430   continue


      write( *, '(a,/)' ) ' Transform data Importances calculated'

cd 440 continue
c
c............now process MAGNETIC inversion input data ............
c
c----  enter magnetic isochron pick misfit partial derivative matrix
c
      call STRCAT( direc, 'mag_a.dat', openfile)
      open( lgin, file = openfile, status = 'old' )

      read( lgin, * ) mmag, nmag 

      if( mmag .gt. mdat ) then

        write( 6, 501 ) mmag, mdat
501     format(/,5x,'error : number of rows in input magnetic',/,
     .           5x,'isochron pick misfit partial derivative',/,
     .           5x,'matrix exceeds initial array dimension',/,
     .           5x,'mmag = ',i4,' mdat = ',i4,/)

        stop

      end if

      if( nmag .ne. nfz ) then

        write( 6, 511 ) nmag, nfz
511     format(/,5x,'error : number of columns in input misfit',/,
     .           5x,'partial derivative matrices are incompatible',/,
     .           5x,'nmag = ', i3,' nfz = ',i3,/)

        stop

      end if

      do 520 i = 1, mmag

        read( lgin, * ) ( A_IN( i, j ), j = 1, nmag )

520   continue

      close( lgin )
c
c----  enter magnetc isochron pick residuals ( misfit )
c
      call STRCAT( direc, 'mag_b.dat', openfile)
      open( lgin, file = openfile, status = 'old' )

      read( lgin, * ) mbmag

      if( mbmag .ne. mmag ) then

        write( 6, 531 ) mbmag, mmag
531     format(/,5x,'error : incompatible number of rows in',/,
     .           5x,'data files mag_a.dat and mag_b.dat',/)
 
        stop
 
      end if
 
      do 540 i = 1, mmag
 
        read( lgin, * ) B_IN( i )
 
540   continue
 
      close( lgin )
c
c----  enter combined misfit of rotated and non - rotated isochron
c----  picks about best fit great circle through non - rotated picks
c
      call STRCAT(  direc, 'mag_w.dat', openfile)
      open( lgin, file = openfile, status = 'old' )
 
      read( lgin, * ) mwmag
 
      if( mwmag .ne. mmag ) then
 
        write( 6, 550 ) mwmag, mmag
550    format(/,5x,'error : incompatible number of rows in',/,
     .           5x,'data files mag_a.dat and mag_w.dat',/,
     .           5x,'mwmag = ',i4,' mmag = ',i4,/)

        stop

      end if


      do 560 i = 1, mmag

        read( lgin, * ) W_IN( i )

560   continue

      close( lgin )


c----  enter magnetics pick locations
c
      call STRCAT( direc, 'mag_loc.dat', openfile)
      open( lgin, file = openfile, status = 'old' )

      read( lgin, * ) mlmag

      if( mlmag .ne. mmag ) then

        write( 6, 571 ) mlmag, mmag
571     format(/,5x,'error : incompatible number of rows in',/,
     .           5x,'data files mag_a.dat and mag_loc.dat',/,
     .           5x,'mlmag = ',i4,' mmag = ',i4,/)

        stop

      end if

      do 580 i = 1, mmag

        read( lgin, * ) MAGLOC(i,1), MAGLOC(i,2), MAGLOC(i,3)

580   continue

      close( lgin )

c
c.............onto data processing .....................
c
c----  determine relative weights of isochron equations
c
      test = magstd / d2km

      do 590 i = 1, mmag

        if( W_IN( i ) .lt. test ) W_IN( i ) = test
        W_IN( i ) = test / W_IN( i )

590   continue
c
c----  normalize magnetic isochron pick partial derivative
c----  matrix and residual vector
c
      do 610 i = 1, mmag

        B_IN( i ) = B_IN( i ) * d2km / magstd

        do 600 j = 1, nmag
          A_IN( i, j ) = A_IN( i, j ) *  d2km / magstd
600     continue

610   continue
c
c----  transfer matrix and vector to temporary storage
c----  removing outliers
c
      mmagrw = 0
      mmagrj = 0

      do 630 i = 1, mmag

        if( abs( B_IN( i ) ) .le. magwin ) then

          mmagrw = mmagrw + 1

          do 620 j = 1, nmag
            A_INNM( mmagrw, j ) = A_IN( i, j )
620       continue

          WMAGNM( mmagrw ) = W_IN( i )

          MAG_LOCS( mmagrw, 1 ) = MAGLOC( i, 1)
          MAG_LOCS( mmagrw, 2 ) = MAGLOC( i, 2)
          MAG_LOCS( mmagrw, 3 ) = MAGLOC( i, 3)

        else
          mmagrj = mmagrj + 1
        end if

630   continue

      write( 6, 641 ) mmag, mmagrw, mmagrj
641   format(/,5x,'results of magnetic isochron pick residual',/,
     .         5x,'outlier removal',//,
     .         5x,'total number of rows    ',i4,/,
     .         5x,'number of good residuals',i4,/,
     .         5x,'number of outliers      ',i4,/)
c
c----  create matrix of magnetic isochron pick weights


c
c---- premultiply A_INNM matrix by weights 
c (avoiding large diagonal matrix to save memory spoace and computation time)
c----  storing result straight into A, also into A_IN for importance calc.
c


      do 660 i = 1, mmagrw
    
            weight  = WMAGNM( i ) * magbias
            mrow = mrow + 1

            do 650 j = 1, nmag
               
               ACON(mrow,j) = A_INNM(i,j)

               A_IN(i,j) = A_INNM(i,j) * weight

 650        continue
     
 660  continue

c
c.......... now calculate data importances for magnetics data

cd     print *,'Skipping magnetics importance calculations'
cd     goto 750

      do 680 i = 1, mmagrw
        do 680 j = 1, nmag

	  A_INT(j,i) = A_IN(i,j)

680   continue

      do 700 i = 1, nmag
        do 700 j = 1, nmag

          sum = 0.

          do 690 k = 1, mmagrw
            sum = sum + A_INT(i,k) * A_IN(k,j)
690        continue

	  ATA(i,j) = sum

700   continue

      call DSYTRF( UPLO, nmag, ATA, nparmax, IPIV, WORK, LWORK, INFO)
      call DSYTRI( UPLO, nmag, ATA, nparmax, IPIV, WORK, INFO)

C      call F07MDF( UPLO, ntf, ATA, nparmax, IPIV, WORK, LWORK, INFO)
C      call F07MJF( UPLO, ntf, ATA, nparmax, IPIV, WORK, INFO)

c..... the upper triangle of ATA now contains the upper triangle of (ATA)-1

c....  complete the full matrix (ATA)-1 first

      do 710 i = 1, nmag
        do 710 j = i+1, nmag 
          ATA(i,j) = ATA(j,i)
710   continue


c.... now calculate data importances

      nmagpicks = 0

      do 740 k = 1, mmagrw

        sum = 0.

        do 720 i = 1, nmag
          do 720 j = 1, nmag

            sum = sum + A_IN(k,i) * ATA(i,j) * A_IN(k,j)

720     continue

c........... check for data point, write only one importance per data point

        do 730 j = 1, nmagpicks

           if(  MAG_LOCS(k,1) .eq. MAG_LOCI(j,1) .and.
     .            MAG_LOCS(k,2) .eq. MAG_LOCI(j,2)  .and.
     .            MAG_LOCS(k,3) .eq. MAG_LOCI(j,4) ) then


c................. found data point, so add importances
              MAG_LOCI(j,3) = MAG_LOCI(j,3) + sum
              goto 739
           endif

 730    continue

c...........not found, must be new data point

        nmagpicks = nmagpicks +1
        MAG_LOCI(nmagpicks,1) = MAG_LOCS(k,1)
        MAG_LOCI(nmagpicks,2) = MAG_LOCS(k,2)
        MAG_LOCI(nmagpicks,3) = sum
        MAG_LOCI(nmagpicks,4) = MAG_LOCS(k,3)


 739    continue

740   continue


      write( *, '(a,/)' ) ' Magnetic data Importances calculated'

cd 750 continue

c----------------- All data entered into final matrix -----------
c------------------ now proceed with actual inversion -----------

c................ output pick locations and importances
c
      call STRCAT( direc, 'flow_loci.dat', openfile)
      open( lgouta, file = openfile, status = 'unknown')

      call writematrix( lgouta, mdat, 3, mfzrw, 3, FZ_LOCI )

      close( lgouta )
c

      call strcat( direc, 'tf_loci.dat', openfile)
      open( lgouta, file = openfile, status = 'unknown', err = 9999 )

      call writematrix( lgouta, mdat, 3, mtfrw, 3, TF_LOCI )

      close( lgouta )
c

      call strcat( direc, 'mag_loci.dat', openfile)
      open( lgouta, file = openfile, status = 'unknown', err = 9999 )

      call writematrix( lgouta, mdat, 4, nmagpicks, 4, MAG_LOCI )

      close( lgouta )
   
c...  FINALLY, CALCULATIONS FOR  ERROR ELLIPSE DETERMINATION
c
c......  calculate data covariances ...................

      write(*, '(a)') ' Calculating error ellipses'


      do 2000 i = 1, mrow
       do 2000 j = 1, nfz

	  AT(j,i) = ACON(i,j)

2000  continue

      do 2020 i = 1, nfz
       do 2020 j = 1, nfz

         sum = 0.

         do 2010 k = 1, mrow
           sum = sum + AT(i,k) * ACON(k,j)
2010     continue

	  ATA(i,j) = sum

2020  continue


      call DSYTRF( UPLO, nfz, ATA, nparmax, IPIV, WORK, LWORK, INFO )
      call DSYTRI( UPLO, nfz, ATA, nparmax, IPIV, WORK, INFO)

C      call F07MDF( UPLO, nmag, ATA, nparmax, IPIV, WORK, LWORK, INFO)
C      call F07MJF( UPLO, nmag, ATA, nparmax, IPIV, WORK, INFO)


c .... the lower triangle of ATA now contains the lower triangle of (ATA)-1


c ...........NOW EXTRACT EXTERNAL INFO NEEDED

c ...    determine number of iteration
c
      call strcat( direc, 'iter.dat', openfile)
      open( lgin, file = openfile, status = 'old', err = 9999 )

      read( lgin, 2031 ) iter
2031  format(20x,i2)
 
      close( lgin )
c
c..   synthesize Euler pole file name
c
      call int2char( iter, ch_iter )

c ............ open output files ........

      call strcat( direc, 'confint_'//ch_iter//'.dat', openfile)
c
      open( lgouta, file = openfile, status = 'unknown', err = 9999 )

      write(*,'(a)') ' Writing file '//openfile

      call strcat( direc, 'confints_'//ch_iter//'.dat', openfile)
c
      open( lgoutb, file = openfile, status = 'unknown', err = 9999 )

      write(*,'(a)') ' Writing file '//openfile

c GRAEME
      call strcat( direc, 'covars_'//ch_iter//'.dat', openfile)

      open( lgoutc, file = openfile, status = 'unknown', err = 9999 )

      write(*,'(a)') ' Writing file '//openfile
C END GRAEME

c ............ open poles file ........

      call strcat( direc, 'poles_'//ch_iter//'.dat', openfile)
c     write(*,'(a)') ' opening file '//openfile
c
      open( lgin, file = openfile, status = 'old', err = 9999 )

      read(lgin,'(a6,x,i2)',end=9999) pairid, npoles
 
c
c ....   loop for each set of poles - read in pole, then work on it
c ..      input rotation pole parameters
c

      do 3000 ipol = 1, npoles 

        read(lgin,'(3(x,f9.0), 2x, a4)',err=9999) plat, plon, pang,
     .                                                        idpol


c ......... extract covariance matrix 

        mpos = (ipol-1)*3

        do 2100 i = 1, 3
          do 2100 j = 1, i

            COVMAT(i,j) = ATA(mpos+i, mpos+j)
            if( i .ne. j) COVMAT(j,i) = ATA(mpos+i, mpos+j)


2100    continue

c........ adjust for non-linearity of longitude

        do 2110 i= 1,3 
          COVMAT(i,2) = COVMAT(i,2) * dcos(plat*raddeg)
          COVMAT(2,i) = COVMAT(2,i) * dcos(plat*raddeg)
2110    continue

c these lines write the covariance matrices to screen or to file
c       write( *, * ) (( COVMAT(i,j) , j=1,3), i=1,3)
       write ( lgoutc, 2112 )  (( COVMAT(i,j) , j=1,3), i=1,3)

2112    format ( 9(f11.6, 1x))

c       write(6,*)COVMAT

c.......... now find eigenvalues and eigenvectors of individual cov mat
c              -in gc degrees surface - (presently only for lat, lon)
C
C NB Use of DSYEV subroutine from LAPACK in place of NAG F02ABF.
C Storage of the output eigenvectors is slightly different: F02ABF 
C stores each vector in columns so that the ith column corresponds
C to the ith eigenvalue, in ascending order, and further chooses
C to normalise the vectors so that the squares of their elements total
C one. They are then listed so that the largest element is real and
C positive. The DSYEV ordering is similarly by i columns for i
C (ascending) eigenvalues, and orthonormalised, but does not seem to
C use the convention whereby the largest element is real and
C positive. NAG documentation suggests that this should not alter
C the validity of the output eigenvectors.
C 
C
C Fill array EVEC with COVMAT, as COVMAT as input to DSYEV would be
C overwritten on output with eigenvectors EVEC, but we need COVMAT
C again to calculate the eigenvectors for the 3-D case...
C 
        do 2115 i = 1, 3
          do 2115 j = 1, i
            EVEC(i,j) = COVMAT(i,j)
2115    continue

        call DSYEV('V', 'L', 2, EVEC, 3, EVAL, WORK, LWORK, IFAIL)
C        call F02ABF(COVMAT, 3, 2, EVAL, EVEC, 3, E, IFAIL)
c		write(6,*)EVEC

c ......... from these, determine the angle from horizontal of semi-major axis
c             and output details suitable for psvelomeca

c        write( *, * ) 'evec',(( EVEC(i,j) , j=1,2), i=1,2)
c        write( *, * ) 'eval',( EVAL(i) , i=1,2)

        ax1 = dsqrt(EVAL(1))
        ax2 = dsqrt(EVAL(2))
c
c  * 2.45... calcell does this now
c
        minang = datan2( EVEC(1,1), EVEC(2,1) )/raddeg
        majang = datan2( EVEC(1,2), EVEC(2,2) )/raddeg

        if (majang .lt. 0 ) majang = majang + 180.
        if (minang .lt. 0 ) minang = minang + 180.


        write ( lgouta, 2120 ) plon, plat, 0., 0.,
     .                     ax2, ax1, majang, idpol


2120    format ( 7(f11.6, 1x), a4)

c.......... now find eigenvalues and eigenvectors of individual cov mat
c              -in gc degrees surface - 
C
C Fill array EVEC with 
C 
        do 2125 i = 1, 3
          do 2125 j = 1, i
            EVEC(i,j) = COVMAT(i,j)
2125    continue

        call DSYEV('V', 'L', 3, EVEC, 3, EVAL, WORK, LWORK, IFAIL)
C        call F02ABF(COVMAT, 3, 3, EVAL, EVEC, 3, E, IFAIL)
c		write(6,*)"3 axes"
c		write(6,*)EVEC

c ......... from these, determine the angle from horizontal of semi-major axis
c             and output details suitable for psvelomeca

cd        write( *, * ) 'evec',(( EVEC(i,j) , j=1,3), i=1,3)
cd        write( *, * ) 'eval',( EVAL(i) , i=1,3)

        ax1 = dsqrt(EVAL(1))
        ax2 = dsqrt(EVAL(2))
        ax3 = dsqrt(EVAL(3))
c
c  * 2.79... now calcell does this...
c
        minang = datan2( EVEC(1,2), EVEC(2,2) )/raddeg
        majang = datan2( EVEC(1,3), EVEC(2,3) )/raddeg

        if (majang .lt. 0 ) majang = majang + 180.
        if (minang .lt. 0 ) minang = minang + 180.


        write ( lgoutb, 2120 ) plon, plat, pang, 
     .                     ax3, ax2, ax1, majang, idpol



c........ next pole ....

3000  continue


c .. all poles read and processed
 
 
      close(lgin)
      close(lgouta)
      close(lgoutb)
      close(lgoutc)



      stop ' ** confimp_calc3d finished **'
 9999 stop 'oops'
      end       
