# Command line arguments
The table below show all arguments that are available in the `reformat` module.
| **Argument**                                             | **Type**                                                      | **Default**      | **Description**                                                               |
| -------------------------------------------------------- | ------------------------------------------------------------- | ---------------- | ----------------------------------------------------------------------------- |
| `-h, --help`                                             | Flag                                                          | –                | Print help message.                                                           |
| **Required Input/Output**                                |                                                               |                  |                                                                               |
| `-a, --alignment <alignment>`                            | Path (file)                                                   | –                | Path to `.parquet` or `.jsonl` file produced by `fishnet align`.              |
| `-o, --out <out>`                                        | Path (file)                                                   | –                | Output path. Extension determines format (`.parquet` or `.tsv`).              |
| **Pod5 Input**                                           |                                                               |                  |                                                                               |
| `-p, --pod5 <pod5>...`                                   | Path(s) (file or directory)                                   | –                | POD5 input(s). Required if alignment file lacks raw signal. Multiple allowed. |
| `--rna`                                                  | Flag                                                          | –                | Set if direct RNA POD5 file(s) are provided (reverse signal).                 |
| **Data Filter (one required)**                           |                                                               |                  |                                                                               |
| `-r, --ref-regions <ref-regions>...`                     | String(s)                                                     | –                | Filter by reference region(s) (`<REF>:<START>-<END>`). 1-based inclusive.     |
| `-R, --bed-file <bed-file>`                              | Path (file)                                                   | –                | BED file with reference regions (0-based start, exclusive end).               |
| `-P, --positions-of-interest <positions-of-interest>...` | String(s)                                                     | –                | Filter by positions of interest (`<REF>:<SITE>-<HALF-SIZE>`).                 |
| `-m, --motifs <motifs>...`                               | String(s)                                                     | –                | Filter for motif sequence(s) (A/C/G/T/U). Multiple allowed.                   |
| `-M, --motifs-file <motifs-file>`                        | Path (file)                                                   | –                | File with one motif per line (A/C/G/T/U only).                                |
| **Processing Strategy**                                  |                                                               |                  |                                                                               |
| `-s, --strategy <strategy>`                              | Enum (`stats`, `interpolate`)                                 | `stats`          | Processing strategy: compute statistics or interpolate signal.                |
| `--alignment-type <alignment-type>`                      | Enum (`reference`, `query`)                                   | –                | Select which alignment type to parse.                                         |
| `--skip-signal-norm`                                     | Flag                                                          | –                | Skip z-standardization of signal intensity.                                   |
| `--skip-dwell-norm`                                      | Flag                                                          | –                | Skip z-standardization of dwell times.                                        |
| **Strategy 1: Statistics Settings**                      |                                                               |                  |                                                                               |
| `--stats <stats>...`                                     | Enum(s) (`mean`, `median`, `std`, `dwell`, `signal-to-noise`) | `mean std dwell` | Statistics to compute per base when using `--strategy stats`.                 |
| **Strategy 2: Interpolation Settings**                   |                                                               |                  |                                                                               |
| `--target-size <target-size>`                            | Integer                                                       | `30`             | Target size for interpolated signal chunks per base.                          |
| **Threading Settings**                                   |                                                               |                  |                                                                               |
| `-t, --threads <threads>`                                | Integer                                                       | `8`              | Number of parallel threads (set to `1` for single-threaded).                  |
| `--queue-size <queue-size>`                              | Integer                                                       | `1000`           | Queue size for worker communication (affects memory use).                     |
| **Input/Output Settings**                                |                                                               |                  |                                                                               |
| `--input-chunk-size <input-chunk-size>`                  | Integer                                                       | `4000`           | Number of alignments read per iteration. Larger = faster, more memory.        |
| `-f, --force-overwrite`                                  | Flag                                                          | –                | Overwrite existing output file if it exists.                                  |
| `--output-shape <output-shape>`                          | Enum (`melted`, `exploded`, `nested`)                         | `nested`         | Determines output structure (nested only for Parquet).                        |
| `--output-batch-size <output-batch-size>`                | Integer                                                       | `4000`           | Number of alignments buffered before writing output.                          |
| **Logging Settings**                                     |                                                               |                  |                                                                               |
| `--log-level <log-level>`                                | Enum (`off`, `error`, `warn`, `info`, `debug`, `trace`)       | `off`            | Controls verbosity of logging.                                                |
| `--log-path <log-path>`                                  | Path (file)                                                   | `log.txt`        | Log file path (used if `--log-level` ≠ `off`).                                |
