# Fishnet - processing repository

This repository contains all scripts for the processing and visualization performed for the paper. It is split into the following parts:

1. Preparing the datasets ([`01_data/`](./01_data/README.md))
2. Performing a benchmark of processing times ([`02_compare_time/`](./02_compare_time/README.md))
3. Comparing produced alignments ([`03_compare_alignments/`](./03_compare_alignments/README.md))
4. Analyzing m1A sites ([`04_m1a_analysis/`](./04_m1a_analysis/README.md))

Refer to the `README.md` files in each subdirectory for detailled information.

Beyond the four modules, the repository contains the [./bin/](./bin/) directory, containing executables for [`Fishnet`](./bin/fishnet), [`f5c`](./bin/f5c), [`Remora`](./bin/remora) and [`Hyperfine`](./bin/hyperfine). [`requirements.txt`](./requirements.txt) contains all python dependencies that are needed. These are installed automatically into a venv when processing the DNA data in `01_data`.