import sys
from tqdm import tqdm

def main():
    in_path = sys.argv[1]
    out_path = sys.argv[2]
    
    print(f"Processing: {in_path}, writing to: {out_path}")

    with open(in_path, "r") as in_file, open(out_path, "w") as out_file:
        next(in_file)
        
        line = next(in_file).strip().split("\t")
        current_read = line[0]
        alignment = [line[5]]
        base_algn_len = line[6]
        progress = tqdm()

        for line in in_file:
            line = line.strip().split("\t")
            if line[0] == current_read:
                alignment.append(line[5])
                base_algn_len = line[6]
            else:
                # Add the alignment end index before writing
                alignment.append(str(int(alignment[-1]) + int(base_algn_len)))
                out_file.write(
                    f"{current_read}\t{",".join(alignment)}\n"
                )
                progress.update()

                current_read = line[0]
                alignment = [line[5]]
                base_algn_len = line[6]

        progress.close()

if __name__=="__main__":
    main()