import sys
from tqdm import tqdm

def main():
    in_path = sys.argv[1]
    out_path = sys.argv[2]
    alignment_type = sys.argv[3]

    print(f"Processing: {in_path}, writing to: {out_path}")

    with open(in_path, "r") as in_file, open(out_path, "w") as out_file:
        for line in tqdm(in_file):
            line = line.strip().split("\t")

            out_file.write(
                f"{line[0]}\t{line[1] if alignment_type == "query" else line[2]}\n"
            )

if __name__=="__main__":
    main()