#!/bin/bash
set -euo pipefail

BASEDIR="$(cd "$(dirname "${BASH_SOURCE[0]}")" && pwd)"
SCRIPTDIR="${BASEDIR}/scripts"
OUTDIR="${BASEDIR}/alignments_compared"

source "${BASEDIR}/../venv/bin/activate"


echo "Comparing similarities between Fishnet and Remora for the query alignment..."

python "${SCRIPTDIR}/calculate_diff_all.py" \
    "${BASEDIR}/alignments_merged/query_alignments.parquet" \
    "${BASEDIR}/alignments_compared/query_metrics.parquet"


echo "Comparing similarities between Fishnet and Remora for the reference alignment..."

python "${SCRIPTDIR}/calculate_diff_fishnet_remora.py" \
    "${BASEDIR}/alignments_merged/reference_alignments.parquet" \
    "${BASEDIR}/alignments_compared/reference_metrics.parquet"
