#!/bin/bash
set -euo pipefail

BASEDIR="$(cd "$(dirname "${BASH_SOURCE[0]}")" && pwd)"
SCRIPTDIR="${BASEDIR}/scripts"
OUTDIR="${BASEDIR}/alignments_merged"

source "${BASEDIR}/../venv/bin/activate"


echo "Merging the query alignments from all tools..."

python "${SCRIPTDIR}/merge_parsed_alignments.py" \
    "${BASEDIR}/alignments/fishnet_query.parquet" \
    "${BASEDIR}/alignments_parsed/remora_query.tsv" \
    "${BASEDIR}/alignments_merged/query_alignments.parquet" \
    "${BASEDIR}/alignments_parsed/f5c_query.tsv" \
    "${BASEDIR}/alignments_parsed/uncalled4_query.tsv"


echo "Merging the reference alignments from Fishnet and Remora..."

python "${SCRIPTDIR}/merge_parsed_alignments.py" \
    "${BASEDIR}/alignments/fishnet_reference.parquet" \
    "${BASEDIR}/alignments_parsed/remora_reference.tsv" \
    "${BASEDIR}/alignments_merged/reference_alignments.parquet"
