#!/bin/bash
set -euo pipefail

BASEDIR="$(cd "$(dirname "${BASH_SOURCE[0]}")" && pwd)"
INDIR="${BASEDIR}/alignments"
SCRIPTDIR="${BASEDIR}/scripts"
OUTDIR="${BASEDIR}/alignments_parsed"

source "${BASEDIR}/../venv/bin/activate"

# Ignoring uncalled4/f5c reference alignment since the eventalign files do not contain a start signal index
echo "Parsing the output file into a uniform format"

echo "Parsing f5c query output..."
python "${SCRIPTDIR}/parse_f5c_query_output.py" "${INDIR}/f5c_query.tsv" "${OUTDIR}/f5c_query.tsv"

echo "Parsing uncalled4 query output..."
python "${SCRIPTDIR}/parse_uncalled4_query_output.py" "${INDIR}/uncalled4_query.tsv" "${OUTDIR}/uncalled4_query.tsv"

echo "Parsing remora query output..."
python "${SCRIPTDIR}/parse_remora_output.py" "${INDIR}/remora_query.tsv" "${OUTDIR}/remora_query.tsv" "query"

echo "Parsing remora reference output..."
python "${SCRIPTDIR}/parse_remora_output.py" "${INDIR}/remora_reference.tsv" "${OUTDIR}/remora_reference.tsv" "reference"

