#!/bin/bash
set -euo pipefail

# Run Uncalled4 query to signal alignment using the default settings

if [ $# -lt 5 ]; then
    echo "Usage: $0 <bam-path> <pod5-path> <out-path> <ref-path> <num-threads>"
    exit 1
fi

bam_path=$1
pod5_path=$2
kmer_table_path=$3
out_path=$4
ref_path=$5
n_threads=$6

uncalled4 align \
    --bam-in $bam_path \
    --reads $pod5_path \
    --flowcell "FLO-PRO114M" \
    --kit "SQK-LSK114" \
    --tsv-out $out_path \
    --processes $n_threads \
    --self