#!/bin/bash
set -euo pipefail

# Run Remora query to signal alignment using the default settings used in Fishnet

if [ $# -lt 4 ]; then
    echo "Usage: $0 <bam-path> <pod5-path> <kmer-table-path> <out-path> <remora-script>"
    exit 1
fi

bam_path=$1
pod5_path=$2
kmer_table_path=$3
out_path=$4
REMORA=$5

$REMORA \
    --bam $bam_path \
    --pod5 $pod5_path \
    --kmer $kmer_table_path \
    --out $out_path \
    --alignment_type "reference"