#!/bin/bash
set -euo pipefail

# Run Fishnet reference to signal alignment using the default settings

if [ $# -lt 5 ]; then
    echo "Usage: $0 <bam-path> <pod5-path> <kmer-table-path> <out-path> <num-threads> <fishnet-binary>"
    exit 1
fi

bam_path=$1
pod5_path=$2
kmer_table_path=$3
out_path=$4
n_threads=$5
FISHNET=$6

$FISHNET align \
    --bam $bam_path \
    --pod5 $pod5_path \
    --kmer-table $kmer_table_path \
    --out $out_path \
    --threads $n_threads \
    --alignment-type "reference"