#!/bin/bash
set -euo pipefail

# Run Uncalled4 query to signal alignment using the default settings

if [ $# -lt 6 ]; then
    echo "Usage: $0 <fastq_path> <bam_path> <pod5_path> <ref_path> <out_path> <n_threads> <f5c-binary>"
    exit 1
fi

fastq_path=$1
bam_path=$2
blow5_path=$3
ref_path=$4
out_path=$5
n_threads=$6
F5C=$7

$F5C eventalign -r $fastq_path -b $bam_path -g $ref_path --slow5 $blow5_path -t $n_threads > $out_path