#!/bin/bash
set -euo pipefail

# Run Uncalled4 query to signal alignment using the default settings

if [ $# -lt 4 ]; then
    echo "Usage: $0 <bam-path> <pod5-path> <out-path> <ref-path> <num-threads> <f5c-binary>"
    exit 1
fi

fastq_path=$1
blow5_path=$2
out_path=$3
n_threads=$4
F5C=$5

$F5C resquiggle $fastq_path $blow5_path -t $n_threads > $out_path