#!/bin/bash
set -euo pipefail

BASEDIR="$(cd "$(dirname "${BASH_SOURCE[0]}")" && pwd)"
JOBDIR="${BASEDIR}/scripts/jobs"

show_menu() {
    echo "How would you like to submit the jobs?"
    echo ""
    echo "1) Submit all jobs in sequentially"
    echo "2) Submit specific pattern"
    echo "3) Exit"
    echo ""
}


function submit_all {
    echo "Submitting all jobs to be executed sequentially."
    local count=0

    for job in "$JOBDIR"/*.sh; do
        if [[ -f "$job" ]]; then
            # echo $job
            sbatch "$job"
            count=$((count + 1))
        fi
    done

    echo "Finished. Submitted ${count} jobs"
}


function submit_by_pattern {
    local pattern=$1
    local count=0

    for job in "$JOBDIR"/${pattern}.sh; do
        if [[ -f "$job" ]]; then
            # echo $job
            sbatch "$job"
            count=$((count + 1))
        fi
    done

    echo "Finished. Submitted ${count} jobs"
}

submit_custom() {
    read -p "Enter pattern to match (structure is <tool>_<read-len>_<n-reads>_<alignment-type>_<n-threads>): " pattern
    submit_by_pattern "$pattern"
}

while true; do
    show_menu
    read -p "Enter choice [1-3]: " choice
    echo ""
    
    case $choice in
        1)
            submit_all
            break
            ;;
        2)
            submit_custom
            break
            ;;
        3)
            echo "Exiting..."
            exit 0
            ;;
        *)
            echo "Invalid choice. Please try again."
            echo ""
            ;;
    esac
done