#!/bin/bash
set -euo pipefail

BASEDIR="$(cd "$(dirname "${BASH_SOURCE[0]}")" && pwd)"
M1ADIR="${BASEDIR}/rna_m1a"

POD5DIR="${M1ADIR}/pod5"
BAMDIR="${M1ADIR}/bam"
REFDIR="${M1ADIR}/ref"

source "${M1ADIR}/.env"


function basecall {
    local pod5_file=$1
    local ref_file=$2
    local out_file=$3

    dorado basecaller "$DORADO_MODEL" "$pod5_file" \
        --reference "$ref_file" \
        --emit-moves \
        -x "$DORADO_CUDA" \
        > "$out_file"
}


echo "Downloading kmer table..."

wget -O "${M1ADIR}/levels.txt" \
    "https://raw.githubusercontent.com/nanoporetech/kmer_models/refs/heads/master/rna004/9mer_levels_v1.txt"


# TODO: Download pod5 files and place in pod5 directory


echo "Base-calling and mapping modified samples..."

basecall "${POD5DIR}/mod_cox1.pod5" "${REFDIR}/mod_cox1_ref.fa" "${BAMDIR}/mod_cox1.bam"
basecall "${POD5DIR}/mod_cox2.pod5" "${REFDIR}/mod_cox2_ref.fa" "${BAMDIR}/mod_cox2.bam"
basecall "${POD5DIR}/mod_cox3.pod5" "${REFDIR}/mod_cox3_ref.fa" "${BAMDIR}/mod_cox3.bam"


echo "Base-calling and mapping unmodified samples..."

basecall "${POD5DIR}/unmod_cox1.pod5" "${REFDIR}/unmod_cox1_ref.fa" "${BAMDIR}/unmod_cox1.bam"
basecall "${POD5DIR}/unmod_cox2.pod5" "${REFDIR}/unmod_cox2_ref.fa" "${BAMDIR}/unmod_cox2.bam"
basecall "${POD5DIR}/unmod_cox3.pod5" "${REFDIR}/unmod_cox3_ref.fa" "${BAMDIR}/unmod_cox3.bam"
