%% arbitrary communities with aribitrary alphas and betas(with noise)

N_range = [30,100]; % [minimum,maximum] number of nodes in a community
M_range = [5,7]; % [minimum,maximum] number of communities
alpha_range = [1.2,1.5]; % [minimum, maximum] ranges of alphas (within-community edge weights before noise)
%beta_range = [0.2,0.2]; % [minimum, maximum] ranges of betas (between-community edge weights before noise)
noise = 0.2; % magnitude of noise

M = randi(M_range); % number of communities
N = randi(N_range, 1,M); % vector of community sizes
alpha = rand(1,M).*(alpha_range(2)-alpha_range(1)) + alpha_range(1);  % vector of alphas
beta = 0.2; % beta value

K = generate_graph_with_communities(M, N, alpha, beta, noise); % generate graph with communities

% Scramble K so that the graph remains the same but the nodes are labelled
% randomly and hence loses the block structure
p = randperm(sum(N)); % random permutation
K_s = K(p, p); % scramble K

% Number of communities using a new measure which uses inverse of eigengap
M_estimate = M_estimate_inv_eigengap(K_s);

% Permuation to resort the adjacency matrix into block structure
sigma = sort_adj_matrix(K_s, M_estimate);

% Sorting according to the sum of 1st M_estimate eigenvalues
K_sigma = K_s(sigma, sigma);

% Error - fraction of misplaced nodes
epsilon = sort_error(N, M, p, sigma);

% Step 2 of sorting
sigma_step_2 = sort_adj_matrix_step_2(K_s, M_estimate);
K_sigma_step_2 = K_s(sigma_step_2, sigma_step_2);

% Error - fraction of misplaced nodes after step 2
epsilon_step_2 = sort_error(N, M, p, sigma_step_2);

%% Figures

figure;
nexttile; imagesc(K); title("Ground truth"); axis image;
nexttile; imagesc(K_s); title("Randomly scrambled"); axis image;
nexttile; imagesc(K_sigma); title(sprintf("Sorted (\\epsilon = %.2f)", epsilon)); axis image;
nexttile; imagesc(K_sigma_step_2); title(sprintf("Step 2 (\\epsilon = %.2f)", epsilon_step_2)); axis image;
