# 🌱 Terrestrial Biodiversity impact and Land Use footprint Analysis
This project assesses the environmental impacts of transitioning from beef to novel burger patties across ten selected EU countries between 2015 and 2018, using the FABIO and FABEXIO EE-MRIO databases.
The analysis covers both climate-driven biodiversity impacts (CDB) and land use footprint (LU) with land-driven biodiversity impacts (LDB), considering impacts within the food system and beyond the food system.

Although 2015 is used as the default case study in example scripts, the workflow supports multi-year aggregation (2015–2018) for robust comparisons.

## 📁 Project Structure

├── FABEXIO-CBD-2015.py                       # Example: 2015 climate-driven biodiversity analysis (supply chain scope)
├── FABIO-LU&LDB-food-2015.py             # Example: 2015 land use & land-driven biodiversity within food system
├── FABEXIO-LU&LDB-non-food-2015.py           # Example: 2015 land use & land-driven biodiversity beyond food system
├── Auxiliary/                                # Region and sector concordance files (EXIOBASE ↔ FABIO)
│   ├── fabio-exio_reg.csv
│   └── fabio-exio-sup.xlsx
│   
├── GLAM/                                     # GLAM land use and climate change characterization factors
│   ├── CF_FABEXIO_GLAM.xlsx
│   ├── CF_EXIOBASE_GLAM_NB.xlsx
│   ├── EXIO39_to_GLAM_char.tsv               
│   └── EXIO39_to_GLAM_flows.tsv
├── README.md                                 # Project documentation



## 🧪 Script & Notebook Overview

### FABEXIO-CDB-2015.py
- Calculates climate-driven biodiversity impacts in 2015
- Scope: Entire supply chain of beef-to-novel transition
- Model: FABIO
- Uses GLAM climate change CFs from:
 - EXIO39_to_char.tsv
 - EXIO39_to_flows.tsv
- Requires region/sector mappings from Auxiliary/

### FABIO-LU&LDB-food-2015.py
- Calculates land use footprint and land-driven biodiversity impacts in 2015
- Scope: Within the food system
- Uses updated land use accounts from EXIOBASE_to_FABIO_mapping.py
- Model: FABIO
- Uses GLAM land use CFs from: CF_EXIOBASE_GLAM_NB.xlsx
-The land use account was imported from Supporting Information S7. 

### FABEXIO-LU&LDB-non-food-2015.py
- Calculates land use footprint and land-driven biodiversity impacts in 2015
- Scope: Beyond the food system (non-food sectors included)
- Model: FABEXIO
- Uses GLAM land use CFs from: CF_FABEXIO_GLAM.xlsx
- Requires region/sector mappings from Auxiliary/
-The land use account was imported from Supporting Information S7. 


## ⚙️ Configuration

The `config.py` file contains key paths, database versions, and food sector selections. Ensure you modify the paths to match your local setup.

## 🔗 Data Downloads

- FABIO v1.2** is available at: [https://github.com/fineprint-global/fabio]
- EXIOBASE v3.8.2** is available at: [https://zenodo.org/records/5589597]
- FABEXIO (internal project data)


