# Samples README

This folder contains small CSV samples for Arabic dialect datasets. Each CSV is a quick, ready-to-use slice with consistent columns for fast testing, demos, and conference materials.

## What’s included

The set may vary depending on the package, but commonly includes:
- `egyptian_sample.csv`
- `levantine_sample.csv`
- `gulf_sample.csv`
- `iraqi_sample.csv`
- `maghrebi_sample.csv` (Darija)
- `yemeni_sample.csv`
- `msa_sample.csv` (if included)

Each file typically contains around 10 example pairs.

## CSV schema

All CSVs share the same columns:
- `source` — Arabic (dialect) text
- `target` — English translation
- `dialect` — Dialect label (e.g., Egyptian, Levantine)

## Notes

- These samples are small, illustrative subsets intended for quick examination, not exhaustive coverage.
- File presence may differ across distributions. If a dialect file isn’t present, it wasn’t included in this package.
