function [LFCs, LFPs, r, pvar, weightsf, PCs, EOFs, N, pvar_slow, pvar_lfc, r_eofs, pvar_slow_eofs] = run_lfca(LON_AXIS,LAT_AXIS,data,truncation,cutoff,region)

%% Preprocessing
% compute anomaly from annual cycle
[data_anomalies,Mt] = monthly_anomalies(data);

% reshape data for LFCA
s = size(data_anomalies);
[Y,X] = meshgrid(LAT_AXIS,LON_AXIS);
area = cos(Y*pi/180);
area(isnan(mean(data_anomalies,3))) = 0;

domain = ones(size(area));

if nargin>5
switch region
    case 'Pacific'
        domain(X<100) = 0;
        domain(X<103 & Y<5) = 0;
        domain(X<105 & Y<2) = 0;
        domain(X<111 & Y<-6) = 0;
        domain(X<114 & Y<-7) = 0;
        domain(X<127 & Y<-8) = 0;
        domain(X<147 & Y<-18) = 0;
        domain(Y>70) = 0;
        domain(Y>65 & (X<175 | X>200)) = 0;
        domain(Y<-45) = 0;
        domain(X>260 & Y>17) = 0;
        domain(X>270 & Y<=17 & Y>14) = 0;
        domain(X>276 & Y<=14 & Y>9) = 0;
        domain(X>290 & Y<=9) = 0;

    case 'Tropical_Pacific'
        domain(X<100) = 0;
        domain(X<103 & Y<5) = 0;
        domain(X<105 & Y<2) = 0;
        domain(X<111 & Y<-6) = 0;
        domain(X<114 & Y<-7) = 0;
        domain(X<127 & Y<-8) = 0;
        domain(X<147 & Y<-18) = 0;
        domain(Y>30) = 0;
        domain(Y<-30) = 0;
        domain(X>260 & Y>17) = 0;
        domain(X>270 & Y<=17 & Y>14) = 0;
        domain(X>276 & Y<=14 & Y>9) = 0;
        domain(X>290 & Y<=9) = 0;

    case 'Pacific_exp'
        domain(X<100) = 0;
        %domain(X<103 & Y<5) = 0;
        %domain(X<105 & Y<2) = 0;
        %domain(X<111 & Y<-6) = 0;
        %domain(X<114 & Y<-7) = 0;
        %domain(X<127 & Y<-8) = 0;
        %domain(X<147 & Y<-18) = 0;
        domain(Y>70) = 0;
        domain(Y>65 & (X<175 | X>200)) = 0;
        domain(X>260 & Y>17) = 0;
        domain(X>270 & Y<=17 & Y>14) = 0;
        domain(X>276 & Y<=14 & Y>9) = 0;
        domain(X>290 & Y<=9) = 0;

    case 'South_Pacific'
        domain(X<100) = 0;
        domain(Y>15) = 0;
        domain(X>270 & Y<=17 & Y>14) = 0;
        domain(X>276 & Y<=14 & Y>9) = 0;
        domain(X>290 & Y<=9) = 0;

    case 'Pacific_30S-70N'
        domain(X<100) = 0;
        domain(X<103 & Y<5) = 0;
        domain(X<105 & Y<2) = 0;
        domain(X<111 & Y<-6) = 0;
        domain(X<114 & Y<-7) = 0;
        domain(X<127 & Y<-8) = 0;
        domain(X<147 & Y<-18) = 0;
        domain(Y>70) = 0;
        domain(Y>65 & (X<175 | X>200)) = 0;
        domain(Y<-30) = 0;
        domain(X>260 & Y>17) = 0;
        domain(X>270 & Y<=17 & Y>14) = 0;
        domain(X>276 & Y<=14 & Y>9) = 0;
        domain(X>290 & Y<=9) = 0;

    case 'Atlantic_exp'
        domain(Y>85) = 0;
        domain(Y<-45) = 0;
        domain(X<260 & X>60 & Y>17) = 0;
        domain(X<270 & X>36 & Y<=17 & Y>14) = 0;
        domain(X<276 & X>36 & Y<=14 & Y>9) = 0;
        domain(X<290 & X>24 & Y<=9) = 0;

    case 'Atlantic'
        domain(Y>85) = 0;
        domain(Y<0) = 0;
        domain(X<260 & X>60 & Y>17) = 0;
        domain(X<270 & X>36 & Y<=17 & Y>14) = 0;
        domain(X<276 & X>36 & Y<=14 & Y>9) = 0;
        domain(X<290 & X>24 & Y<=9) = 0;

    case 'Pacific_20-70N'
        domain(X<105) = 0;
        domain(Y>70) = 0;
        domain(Y<20) = 0;
        domain(X>260) = 0;
        domain(Y>65 & (X<175 | X>200)) = 0;

    case 'Pacific_20-50S'
        domain(X<147) = 0;
        domain(X>291) = 0;
        domain(Y>-20) = 0;
        domain(Y<-50) = 0;

    case 'Global_Ocean_20-80N'
        domain(Y<20) = 0;
        domain(Y>80) = 0;

    case 'Tropics'
        domain(Y<-30) = 0;
        domain(Y>30) = 0;

    case 'Southern_Ocean_Pacific'
        domain(X<147) = 0;
        domain(X>291) = 0;
        domain(Y>-35) = 0;

    case 'Southern_Hemisphere'
        domain(Y>-20) = 0;

    case 'Southern_Ocean'
        domain(Y>-35) = 0;

    case 'Global60'
        domain(abs(Y)>60) = 0;

end
end

xtf = reshape(data_anomalies,s(1)*s(2),s(3))';
AREA_WEIGHTS = reshape(area,s(1)*s(2),1)';
domain = reshape(domain,s(1)*s(2),1)';

% icol_ret and icol_disc help reconstruct the data onto the original grid
icol_ret = find(AREA_WEIGHTS~=0 & domain);
icol_disc = find(AREA_WEIGHTS==0 | ~domain);
xtf = xtf(:,icol_ret);
AREA_WEIGHTS = AREA_WEIGHTS(icol_ret);

% scale by square root of grid cell area such that covariance is area
% weighted
normvec          = AREA_WEIGHTS' ./ sum(AREA_WEIGHTS);
scale    = sqrt(normvec);

%% Low-frequency component analysis (LFCA)
[LFCs, LFPs, weights, r, pvar, PCs, EOFs, N, pvar_slow, pvar_lfc, r_eofs, pvar_slow_eofs] = lfca(xtf, cutoff, truncation, scale);
LFPs       = insert_cols(LFPs, icol_ret, icol_disc);
EOFs       = insert_cols(EOFs, icol_ret, icol_disc);
weightsf        = insert_rows(weights, icol_ret, icol_disc);