import sys
from molSimplify.Informatics.MOF.MOF_descriptors import get_MOF_descriptors
import pandas as pd

def print_red(message):
    # ANSI escape code for red text
    red = "\033[91m"
    reset = "\033[0m"
    print(f"{red}{message}{reset}")

def print_green(message):
    # ANSI escape code for red text
    red = "\033[92m"
    reset = "\033[0m"
    print(f"{red}{message}{reset}")

def print_blue(message):
    # ANSI escape code for red text
    red = "\033[93m"
    reset = "\033[0m"
    print(f"{red}{message}{reset}")

def main():
    # User command-line inputs
    structure_path = sys.argv[1]
    name = sys.argv[2]
    RACs_folder = sys.argv[3]
    wiggle_room = float(sys.argv[4])

    # Initialize result log
    log_path = f'{RACs_folder}/RAC_getter_log.txt'
    with open(log_path, 'w') as f:
        try:
            # Attempt to generate descriptors
            full_names, full_descriptors = get_MOF_descriptors(
                structure_path, 3, path=RACs_folder,
                xyzpath=f'{RACs_folder}/{name}.xyz', wiggle_room=wiggle_room,
                max_num_atoms=6000,
                get_sbu_linker_bond_info=True,
                surrounded_sbu_file_generation=True,
                detect_1D_rod_sbu=True
            )        
        except ValueError as e:
            f.write(f'FAILED - ValueError: {e}\n')
            return None
        except NotImplementedError as e:
            f.write(f'FAILED - NotImplementedError: {e}\n')
            return None
        except AssertionError as e:
            f.write(f'FAILED - AssertionError: {e}\n')
            return None
        except Exception as e:
            f.write(f'FAILED - General Exception: {e}\n')
            return None
        
        # Check if featurization failed
        if (len(full_names) <= 1) and (len(full_descriptors) <= 1):
            f.write('FAILED - Featurization error: Insufficient descriptors generated\n')
        
        featurization_list = []
        full_names.append('filename')
        full_descriptors.append(name+'.cif')
        featurization = dict(zip(full_names, full_descriptors))
        featurization_list.append(featurization)
        df = pd.DataFrame(featurization_list)
        df.to_csv(f'{RACs_folder}/featurization_frame.csv',index=False)
        # Confirm the log was updated
        print(f"  -RAC log saved to {log_path}")        
        return(featurization)

if __name__ == "__main__":
    main()
