# -*- coding: utf-8 -*-
"""
Created on Thu Nov  2 15:57:55 2023

@author: Timon
"""

import numpy as np
import matplotlib.pyplot as plt
import time
import os
import importlib.util

class SpongeAPDL_2:
    
    def __init__(self, mapdl):
        # material properties
        self.iter = 1
        self.E = 1100        #in MPa
        self.NOBUCK = 2
        #
        self.mapdl = mapdl
        self.R=0
        self.H=0
        self.NV=0
        self.NC=0
        self.D_SHELIX=0
        self.AA=0
        self.BB=0      #Wall Thickness
        self.LOOP_NO = 0
        self.R_E = 0
        ## added 10/3/23
        self.NumBhelix = 0
        self.NumBhelix2 = 0
        
        self.PITCH=0
        self.DELTA_TH = 0
        self.DELTA_H = 0
        self.TH_SHELIX = 0
        return
    
    def FEA_compute(self,input):
        try:
            mapdl = self.mapdl
            self.change_params(input)
            self.construct_geom(input)
            self.prestress()
            totvol, critbuckload,reaction_force = self.get_total_vol_buckload()
            cost = [critbuckload,totvol,reaction_force]  #Should we check if both values are float? In case something goes wrong 
            print("cost for iteration ", self.iter, " is ", cost)
            self.finish_one_iteration(input,totvol, reaction_force, critbuckload, cost)
        except Exception as e:
            print(e)
            cost = [0.0,20000.0, 0.0]
            self.finish_one_iteration(input,0, 0, 0, cost)
              #Setting high value for Volume?
        return cost
    
    def FEA_testing(self, input):
        try:
            mapdl = self.mapdl
            self.change_params(input)
            self.construct_geom(input)
            self.prestress()
            totvol, critbuckload,reaction_force, F_tot_stiffness = self.get_total_vol_buckload()
            cost = [critbuckload, totvol, reaction_force, F_tot_stiffness]
            print("cost for iteration ", self.iter, " is ", cost)
            self.finish_one_iteration(input,totvol, reaction_force, critbuckload, cost)
        except Exception as e:
            print(e)
            cost = [0.0,20000.0,0.0,0]
            self.finish_one_iteration(input,0, 0, 0, cost)         
        return cost
    
    def change_params(self, input): #input = [R,H,NV,NV,D_SHELIX,AA,BB,LOOP_NO,R_E,NumBhelix,NumBhelix2]
        #!!!!!!!!!!!!!!!!
        self.R=input[0]
        self.H=input[1]
        self.NV=int(input[2])
        self.NC=int(input[3])
        self.D_SHELIX=input[4]
        self.AA=input[5]
        self.BB=input[6]         #Wall Thickness
        self.LOOP_NO = int(input[7])
        self.R_E = input[8]/2 #???
        ## added 10/3/23
        self.NumBhelix = int(input[9])
        self.NumBhelix2 = int(input[10])
        self.iter = int(input[11])
        # dependent params
        self.PITCH=self.H/self.LOOP_NO
        self.DELTA_TH = 2*np.pi/self.NV
        self.DELTA_H = self.H/(self.NC-1)
        self.TH_SHELIX = self.D_SHELIX/self.R
        
    def construct_geom(self,input):
        # fetch params #
        R = self.R
        H = self.H
        NV = self.NV
        NC = self.NC
        D_SHELIX = self.D_SHELIX
        AA = self.AA
        BB = self.BB
        LOOP_NO = self.LOOP_NO
        R_E = self.R_E
        NumBhelix = self.NumBhelix
        NumBhelix2 = self.NumBhelix2
        ##end fetch##
        mapdl = self.mapdl
        mapdl.prep7()
        mapdl.et(1,'PLANE82')
        mapdl.clocal(11,1,"","","","","","",2)
        mapdl.csys(11)
        RR = R_E
        COUNT = 1
        for TH in range(0,181,15):
            mapdl.k(COUNT,RR,TH,0)
            COUNT = COUNT + 1
            
        mapdl.flst(3,13,3)
        SPLINE_COUNT = 1
        for I in range(1,14):
            mapdl.fitem(3,SPLINE_COUNT)
            SPLINE_COUNT = SPLINE_COUNT + 1

        mapdl.bsplin("",'P51X')
        mapdl.csys(0)
        mapdl.l(1,13)
        mapdl.lesize("All","","",40,"",1,"","",1)
        mapdl.al(1,2)
        mapdl.amesh("All")
        mapdl.esel("All")

        #mapdl.eplot("All") #plot element cross section of big helix

        mapdl.secwrite("big_helix")
        mapdl.aclear("All")
        mapdl.adele("All","","",1)
        #!!!!!!!!!!!!!!!!!!!!!!
        #!!  MAIN CODE STARTS
        #!!!!!!!!!!!!!!!!!!!!!!

        mapdl.et(1,'BEAM188') #ELEMENT TYPE 3D 2-node beam element
        mapdl.mptemp("","","","","","","")
        mapdl.mptemp(1,0)
        mapdl.mpdata("EX",1,"",self.E)
        mapdl.mpdata("PRXY",1,"",0.3) #Define material properties
        mapdl.sectype(1,"BEAM","RECT","",0) #Define rectangular cross section for beam elements
        mapdl.secoffset("CENT")
        mapdl.secdata(AA,BB,0,0,0,0,0,0,0,0,0,0) #Defines size of cross section

        mapdl.sectype(2,"BEAM","MESH") #ELLIPSOIDAL Cross SECTION
        mapdl.secoffset("ORIG","","","")
        mapdl.secread("big_helix","SECT","MESH")
        
        #!!!!!!!!!!!!!!!!!!!!!!
        #!!  VERTICAL BEAMS
        #!!!!!!!!!!!!!!!!!!!!!!
        COUNT=1
        TH=0
        for II in range(1,NV+1):
            mapdl.k(COUNT,R*np.cos(TH),R*np.sin(TH),0)
            TH = TH + self.DELTA_TH
            COUNT = COUNT + 1

        TH=0
        for II in range(1,NV+1):
            mapdl.k(COUNT,R*np.cos(TH),R*np.sin(TH),H)
            TH = TH + self.DELTA_TH
            COUNT = COUNT + 1


        COUNT_LINE=1
        for II in range(1,NV+1):
            mapdl.l(COUNT_LINE,COUNT_LINE+NV)
            COUNT_LINE = COUNT_LINE + 1
            
        #!!!!!!!!!!!!!!!!!!!!!!!!!!!
        #!!  CIRCUMFERENTIAL BEAMS
        #!!!!!!!!!!!!!!!!!!!!!!!!!!!
        HH=0
        for II in range(1,NC+1):
            mapdl.k(COUNT,0,0,HH)
            mapdl.circle(COUNT,R)
            COUNT = COUNT + 5
            COUNT_LINE = COUNT_LINE + 4
            HH = HH + self.DELTA_H
            
        #mapdl.lplot("All")

        #!!!!!!!!!!!!!!!!!!!!!
        #!!  SMALL HELICES 1st direction
        #!!!!!!!!!!!!!!!!!!!!!
        TH0 = self.TH_SHELIX/2
        TH1 = -self.TH_SHELIX/2
        HH=0

        for JJ in range(1,int(NV/2)+1):
            SPLINE_INIT = COUNT
            HH=0
            for II in range(1,NC+1):
                mapdl.k(COUNT,R*np.cos(TH0),R*np.sin(TH0),HH)
                COUNT = COUNT + 1
                TH0 = TH0 + self.DELTA_TH
                HH = HH + self.DELTA_H 
            mapdl.flst(3,NC,3)
            for II in range(1,NC+1):
                mapdl.fitem(3,SPLINE_INIT)
                SPLINE_INIT = SPLINE_INIT + 1
            mapdl.bsplin("",'P51X')
            
            COUNT_LINE = COUNT_LINE + 1
            SPLINE_INIT = COUNT
            HH=0
            for II in range(1,NC+1):
                mapdl.k(COUNT,R*np.cos(TH1),R*np.sin(TH1),HH)
                COUNT = COUNT + 1
                TH1 = TH1 + self.DELTA_TH
                HH = HH + self.DELTA_H
            mapdl.flst(3,NC,3)
            
            for II in range(1,NC+1):
                mapdl.fitem(3,SPLINE_INIT)
                SPLINE_INIT = SPLINE_INIT + 1
            mapdl.bsplin("",'P51X')
            
            COUNT_LINE = COUNT_LINE + 1
            TH0 = self.TH_SHELIX/2+(2*self.DELTA_TH)*JJ
            TH1 = -self.TH_SHELIX/2+(2*self.DELTA_TH)*JJ
            
        #mapdl.lplot("All")

        #!!!!!!!!!!!!!!!!!!!!!
        #!!  SMALL HELICES 2nd direction
        #!!!!!!!!!!!!!!!!!!!!!
        TH0 = self.TH_SHELIX/2
        TH1 = -self.TH_SHELIX/2
        HH=0

        for JJ in range(1,int(NV/2)+1):
            SPLINE_INIT = COUNT
            HH=0
            for II in range(1,NC+1):
                mapdl.k(COUNT,R*np.cos(TH0),R*np.sin(TH0),HH)
                COUNT = COUNT + 1
                TH0 = TH0 - self.DELTA_TH #sign switches
                HH = HH + self.DELTA_H 
            mapdl.flst(3,NC,3)
            for II in range(1,NC+1):
                mapdl.fitem(3,SPLINE_INIT)
                SPLINE_INIT = SPLINE_INIT + 1
            mapdl.bsplin("",'P51X')
            
            COUNT_LINE = COUNT_LINE + 1
            SPLINE_INIT = COUNT
            HH=0
            for II in range(1,NC+1):
                mapdl.k(COUNT,R*np.cos(TH1),R*np.sin(TH1),HH)
                COUNT = COUNT + 1
                TH1 = TH1 - self.DELTA_TH #sign switches
                HH = HH + self.DELTA_H
            mapdl.flst(3,NC,3)
            
            for II in range(1,NC+1):
                mapdl.fitem(3,SPLINE_INIT)
                SPLINE_INIT = SPLINE_INIT + 1
            mapdl.bsplin("",'P51X')
            
            COUNT_LINE = COUNT_LINE + 1
            TH0 = self.TH_SHELIX/2+(2*self.DELTA_TH)*JJ
            TH1 = -self.TH_SHELIX/2+(2*self.DELTA_TH)*JJ
            
        #mapdl.lplot("All")
        #print("Small Helixes finished")
        #!!!!!!!!!!!!!!!!!!!!!
        #!!  Large HELICE
        #!!!!!!!!!!!!!!!!!!!!!
        NUM_KP = mapdl.get('NUM_KP',"KP",0,"NUM","MAXD")
        COUNT = NUM_KP + 1
        HH = 0
        TH0 = 0
        DELTA_H_BIGHELIX = self.PITCH/NV
        SPLINE_INIT = COUNT

       
        
        if NumBhelix != 0:
            thetainit = (2*np.pi)/(NumBhelix)
            interval = NV // NumBhelix
            #print("Large Helix 1")
            for i in range(NumBhelix):
                HH = 0
                TH0 = (2 * np.pi / NV) * interval * i
                #TH0 = thetainit * i
                SPLINE_INIT=COUNT #????
                for j in range(LOOP_NO):                                   
                    for II in range(1,(NV)+2): ##Mistake here? If we do a 2nd loop in it?
                        mapdl.k(COUNT,R*np.cos(TH0),R*np.sin(TH0),HH)
                        TH0 = TH0 - self.DELTA_TH
                        HH = HH + DELTA_H_BIGHELIX
                        COUNT = COUNT + 1
                    mapdl.flst(3,(NV)+1,3)
                
                    for II in range(1,(NV)+2):
                        mapdl.fitem(3,SPLINE_INIT)
                        SPLINE_INIT = SPLINE_INIT + 1
                    mapdl.bsplin("",'P51X')
                    SPLINE_INIT -= 1


        #!!!!!!!!!!!!!!!!!!!!!
        #!!  Large HELICE2
        #!!!!!!!!!!!!!!!!!!!!!
        NUM_KP = mapdl.get('NUM_KP',"KP",0,"NUM","MAXD")
        COUNT = NUM_KP + 1
        HH = 0
        TH0 = 0
        DELTA_H_BIGHELIX = self.PITCH/NV
        SPLINE_INIT = COUNT
        if NumBhelix2 != 0:
            thetainit = (2*np.pi)/(NumBhelix2)
            interval = NV // NumBhelix2
            for i in range(NumBhelix2):
                HH = 0
                TH0 = (2 * np.pi / NV) * interval * i
                #TH0 = thetainit * i
                SPLINE_INIT=COUNT
                for j in range(LOOP_NO):
                    for II in range(1,(NV)+2):
                        mapdl.k(COUNT,R*np.cos(TH0),R*np.sin(TH0),HH)
                        TH0 = TH0 + self.DELTA_TH
                        HH = HH + DELTA_H_BIGHELIX
                        COUNT = COUNT + 1
                    mapdl.flst(3,(NV)+1,3)
                
                    for II in range(1,(NV)+2):
                        mapdl.fitem(3,SPLINE_INIT)
                        SPLINE_INIT = SPLINE_INIT + 1
                    mapdl.bsplin("",'P51X') ###Limit for BSPLIN command is 200 Points, need to split large Helix in multiple smaller ones
                    SPLINE_INIT -=1
                    
                    
                    # for q in range(4):  # Four quarter circles per loop
                    #     SPLINE_INIT = COUNT  # Starting keypoint for the spline
                    #     for II in range(1, (NV // 4) + 2):  # Create keypoints for one quarter circle
                    #         mapdl.k(COUNT, R * np.cos(TH0), R * np.sin(TH0), HH)
                    #         TH0 += self.DELTA_TH / 4  # Increment angle for quarter circle
                    #         HH += DELTA_H_BIGHELIX / 4  # Increment height for quarter circle
                    #         COUNT += 1  # Increment keypoint counter
                    # mapdl.flst(3, (NV // 4) + 1, 3)  # Start a new list of keypoints for quarter circle

                    # for II in range(1, (NV // 4) + 2):  # Add keypoints to the list
                    #     mapdl.fitem(3, SPLINE_INIT)
                    #     SPLINE_INIT += 1
                    # mapdl.bsplin("", 'P51X')  # Create a spline through keypoints for quarter circle
                    # SPLINE_INIT -= 1  # Adjust for next quarter circle
                    
                    ##
                    
                    # for II in range(1,(NV)+2):
                    #     mapdl.k(COUNT,R*np.cos(TH0),R*np.sin(TH0),HH)
                    #     TH0 = TH0 + self.DELTA_TH
                    #     HH = HH + DELTA_H_BIGHELIX
                    #     COUNT = COUNT + 1
                    # mapdl.flst(3,(NV)+1,3)
                
                    # for II in range(1,(NV)+2):
                    #     mapdl.fitem(3,SPLINE_INIT)
                    #     SPLINE_INIT = SPLINE_INIT + 1
                    # mapdl.bsplin("",'P51X') ###Limit for BSPLIN command is 200 Points, need to split large Helix in multiple smaller ones
                    # SPLINE_INIT -=1
        #mapdl.lplot("All")
        #mapdl.lplot("All")
        print("Geometry finished")
        mapdl.lsel("All")
        mapdl.btol("1e-10") #1e-10
        mapdl.lovlap("All")  #Merge all overlapping beams in one strucutre
        #mapdl.lplot("All")
        #print("Beams merged")
        
        HELIX_TAN = H / (LOOP_NO * 2 * np.pi * R)  #HELIX_TAN cannot be equal to H/((NC-1)/NV *2np.pi*R) otherwise small helix are ellipsoid --> LOOP_NO cant be (NC-1)/NV
        TAN_MIN = HELIX_TAN - 0.15 #0.15
        TAN_MAX = HELIX_TAN + 0.15 #0.15

        # Get line numbers
        L_NUM1 = int(mapdl.get('L_NUM1',"LINE",0,"NUM","MIND"))
        L_NUM2 = int(mapdl.get('L_NUM2',"LINE",0,"NUM","MAXD"))
        print(str(L_NUM2) + " total lines")
        # Get number of keypointss
        NUM_KP = mapdl.get('NUM_KP',"KP",0,"NUM","MAXD")
        COUNT = NUM_KP + 1
        P0 = mapdl.k(COUNT, 0,0,0)
        COUNT += 1
        
        ## Alternative faster approach
        import re
        def parse_llist(llist_output):
            lines = {}
            for line in llist_output.splitlines():
                # Regular expression to match the line format
                # Format: "line_number keypoint1 keypoint2 ..."
                match = re.search(r'^\s*(\d+)\s+(\d+)\s+(\d+)', line)
                if match:
                    line_id = int(match.group(1))
                    kp1_id = int(match.group(2))
                    kp2_id = int(match.group(3))
                    lines[line_id] = {'kp1': kp1_id, 'kp2': kp2_id}
            return lines
        llist_output = mapdl.llist()  # Fetch the llist output from PyAnsys
        parsed_lines = parse_llist(llist_output)
        
        def parse_kplist(kplist_output):
            keypoints = {}
            for line in kplist_output.splitlines():
                # Regular expression to match the line format
                # Format: "keypoint_number x_coord y_coord z_coord ..."
                match = re.search(r'^\s*(\d+)\s+(-?\d+\.?\d*(?:[Ee]-?\d+)?)\s+(-?\d+\.?\d*(?:[Ee]-?\d+)?)\s+(-?\d+\.?\d*(?:[Ee]-?\d+)?)', line)
                #match = re.search(r'^\s*(\d+)\s+(-?\d+\.?\d*)\s+(-?\d+\.?\d*)\s+(-?\d+\.?\d*)', line)
                if match:
                    kp_id = int(match.group(1))
                    x_coord = float(match.group(2))
                    y_coord = float(match.group(3))
                    z_coord = float(match.group(4))
                    keypoints[kp_id] = (x_coord, y_coord, z_coord)
            return keypoints
        # Example usage
        kplist_output = mapdl.klist()  # Fetch the klist output from PyAnsys
        parsed_keypoints = parse_kplist(kplist_output)
        
        
        #t1 = time.time()
        
        
        for II in range(L_NUM1, L_NUM2 + 1):
            # Get coordinates of the first and second keypoint
            kp1_id = parsed_lines[II]['kp1']
            kp2_id = parsed_lines[II]['kp2']
            LKP1 = np.array(parsed_keypoints[kp1_id])
            LKP2 = np.array(parsed_keypoints[kp2_id])

            # Calculate distances and other metrics
            # Assuming P0 is defined and its coordinates are available in a similar format as keypoints
            kpx, kpy, kpz = LKP1
            kpx = round(kpx, 3)
            kpy = round(kpy, 3)
            kpz = round(kpz, 3)

            deltas = LKP2 - LKP1
            XY_DIST = np.linalg.norm(deltas[:2])
            XY_DIST = round(XY_DIST, 3)
            mapdl.k(COUNT, 2 * kpx, 2 * kpy, kpz)

            if XY_DIST < 1E-8:
                L_TAN = 0
            else:
                L_TAN =  round(np.abs(deltas[2]) / XY_DIST,3)
            mapdl.lsel(type_='S', item='LINE', comp='', vmin=II, vmax='', vinc='', kswp='')
            if TAN_MIN < L_TAN < TAN_MAX:
                mapdl.latt(1, "", 1, COUNT, "", 2)
                #print("Large Helix Section")
            else:
                mapdl.latt(1, "", 1, COUNT, "", 1)

            COUNT += 1
        

        ### Meshing strucutre
        #### Alternative foor Loop to assign cross section, might be faster:

        # for II in range(L_NUM1, L_NUM2 + 1):
        #     try:
        #         # Get coordinates of the first keypoint
        #         LKP1 = mapdl.get('LKP1', "Line", II, "KP", "1")
        #         # Get coordinates of the second keypoint
        #         LKP2 = mapdl.get('LKP2', "Line", II, "KP", "2")
        #         #Distance of KP to Zero and KP2-KP1
        #         kptot, kpx, kpy, kpz = mapdl.kdist(P0,LKP1)
        #         mapdl.k(COUNT, 2 * kpx, 2 * kpy, kpz)   
        #         DIST, DX, DY, DZ = mapdl.kdist(LKP1,LKP2)
        #         XY_DIST = np.sqrt(DX**2 + DY**2)
        #         #Check conditions
        #         if XY_DIST < 1E-8:
        #             L_TAN = 0
        #         else:
        #             L_TAN =  np.abs(DZ) / XY_DIST
        #         mapdl.lsel(type_='S', item='LINE', comp='', vmin=II, vmax='', vinc='', kswp='')
        #         if TAN_MIN < L_TAN < TAN_MAX:
        #             mapdl.latt(1, "", 1, COUNT, "", 2)
        #             #print("Large Helix Section")
        #         else:
        #             mapdl.latt(1, "", 1, COUNT, "", 1)
        #         COUNT += 1
        #     except Exception as e:
        #         print(f"Skipping line {II} due to error: {e}")
        #         continue
    
        #elapsed1 = (time.time() - t1)/60
        #print("time elapsed for assigning cross section is ", elapsed1)    
        #print("Cross sections assigned")
        mapdl.lsel("All")
        mapdl.lmesh("All") #Meshing & Plot of Mesh

        mapdl.esel('ALL')
        print("Meshing done")
        #mapdl.eshape(scale='1', key='')
        #mapdl.eplot(vtk=True, show_edges=True, smooth_shading=True, show_node_numbering=False) ###Option for showing elements?
        return
    
    def prestress(self):
        #Boundary conditions
        #Bottom Layer fixed
        mapdl = self.mapdl
        mapdl.csys(1)
        mapdl.seltol(1e-8)
        mapdl.nsel('S', 'LOC', 'Z', 0, 0)
        mapdl.nsel('R', 'LOC', 'X', self.R, self.R)    
        mapdl.d('ALL', 'ALL', 0)
        mapdl.allsel('ALL')
        mapdl.csys(0)

        #Top Layer fixed in X, Y
        mapdl.csys(1)
        mapdl.seltol(1e-8)
        mapdl.nsel('S', 'LOC', 'Z', self.H, self.H)
        mapdl.nsel('R', 'LOC', 'X', self.R, self.R)    
        mapdl.d('ALL', 'UX', 0)
        mapdl.d('ALL', 'UY', 0)
        mapdl.allsel('ALL')
        mapdl.csys(0)
        
        ### Displacement of Top Layer in Z of -1mm
        mapdl.csys(1)
        mapdl.seltol(1e-8)
        mapdl.nsel('S', 'LOC', 'Z', self.H, self.H)
        mapdl.nsel('R', 'LOC', 'X', self.R, self.R)    
        mapdl.d('ALL', 'UZ', -1)
        mapdl.allsel('ALL')
        mapdl.csys(0)
        
        #### Alternatively Pressure (SFBEAM) on top layer
        # mapdl.esel(type_='S', item='CENT', comp='Z', vmin=self.H, vmax=self.H) # Selects elements based on a criterion related to their centroid position in Z  
        # numel = mapdl.get(entity='ELEM', entnum=0, item1='COUNT') # Retrieves the count of selected elements
        # ce = mapdl.get(entity='ELEM', entnum=0, item1='NUM', it1num='MIN')  # Retrieves the minimum element number from the selected set
        
        # for i in range(1, int(numel + 1)):
        #     # Gets the first node number of the current element
        #     n1 = mapdl.get(entity='ELEM', entnum=ce, item1='NODE', it1num=1)
        #     # Gets the second node number of the current element
        #     n2 = mapdl.get(entity='ELEM', entnum=ce, item1='NODE', it1num=2)
        #     # Retrieves the X, Y, and Z coordinates of the first node
        #     n1x = mapdl.get(entity='NODE', entnum=n1, item1='LOC', it1num='X')
        #     n1y = mapdl.get(entity='NODE', entnum=n1, item1='LOC', it1num='Y')
        #     #n1z = mapdl.get(entity='NODE', entnum=n1, item1='LOC', it1num='Z')
        #     # Retrieves the X, Y, and Z coordinates of the second node
        #     n2x = mapdl.get(entity='NODE', entnum=n2, item1='LOC', it1num='X')
        #     n2y = mapdl.get(entity='NODE', entnum=n2, item1='LOC', it1num='Y')
        #     #n2z = mapdl.get(entity='NODE', entnum=n2, item1='LOC', it1num='Z')
        #     # Calculate centroid and vectors
        #     x_cent = 0.5 * (n1x + n2x)
        #     y_cent = 0.5 * (n1y + n2y)
        #     v1_xcomp = n2x - n1x
        #     v1_ycomp = n2y - n1y
        #     crprod = v1_xcomp * y_cent - v1_ycomp * x_cent
        #     # Applies a positive pressure load if the condition is met, otherwise negative
        #     if crprod < 0:
        #         mapdl.sfbeam(ce, 2, 'PRES', 1)
        #     else:
        #         mapdl.sfbeam(ce, 2, 'PRES', -1)
        #     # Retrieves the next element number in the selected set
        #     ce = mapdl.get(entity='ELEM', entnum=ce, item1='NXTH') 
            
            
            
            
        mapdl.allsel('ALL') #Select all entities again 
        ###### Apply circumfrencial pressure
        #mapdl.sfbeam('ALL', 1, 'PRES', 1) ### For circumfrencial pressure
        #####
        mapdl.psf(item='PRES', comp='NORM', key='2', kshell='0', color='1')
        mapdl.pbc(item='All', key='1', min_='', max_='', abs_='')
        #mapdl.view(1, 1, 1, 1)
        #mapdl.eplot(show_edges=True, smooth_shading=True, show_node_numbering=False,show_bounds=True,background="k",plot_bc=True,render_lines_as_tubes=True, render_points_as_spheres=True,  vtk=False)
        #mapdl.eplot(show_edges=True, smooth_shading=True, show_node_numbering=False,show_bounds=True,background="k",plot_bc=True,render_lines_as_tubes=True, render_points_as_spheres=True,  vtk=True)
        
        mapdl.finish()
        mapdl.slashsolu() #Solve Static Problem
        mapdl.antype('STATIC')
        mapdl.nlgeom(0)
        mapdl.pstres('ON')

        output = mapdl.solve()
        #print(output)
        mapdl.finish()
        result = mapdl.result
        return
    
    def get_total_vol_buckload(self):
        mapdl = self.mapdl
        # Get reaction force and total volume of strucutre
        mapdl.post1()
        label = 'VOLU'
        mapdl.etable(label,'VOLU')
        mapdl.ssum()
        totvol = mapdl.get("TOTVOL","SSUM",0,"ITEM","VOLU")
        print(str(totvol) + ' Total volume in mm^3')
        # Reaction Force
        ## Fz, only bottom layer
        mapdl.set("last", "last")
        mapdl.nsel("S", "LOC", "Z", 0, 0)
        mapdl.fsum()
        F_Z = mapdl.get("REAC_Z", "FSUM", "","ITEM", "FZ")
        print(str(F_Z) + ' Reaction force in N in Z direction')
        ##Fx, Sum over X, need to seperate for pos and neg values
        mapdl.nsel("S", "LOC", "X", 0, self.R)
        mapdl.fsum()
        F_X1 = mapdl.get("REAC_X1", "FSUM", "","ITEM", "FX")
        mapdl.nsel("S", "LOC", "X", -self.R, 0)
        mapdl.fsum()
        F_X2 = mapdl.get("REAC_X2", "FSUM", "","ITEM", "FX")
        F_X=abs(F_X1)+abs(F_X2)
        ##FY, Sum over Y, need to seperate for pos and neg values
        mapdl.nsel("S", "LOC", "Y", 0, self.R)
        mapdl.fsum()
        F_Y1 = mapdl.get("REAC_Y1", "FSUM", "","ITEM", "FY")
        mapdl.nsel("S", "LOC", "Y", -self.R, 0)
        mapdl.fsum()
        F_Y2 = mapdl.get("REAC_Y2", "FSUM", "","ITEM", "FY")
        F_Y=abs(F_Y1)+abs(F_Y2)
        #### Calculate total Force
        F_tot_stiffness = -np.sqrt(F_X**2 + F_Y**2 + F_Z**2)
        print(str(F_tot_stiffness) + ' Total reaction force in N for stiffness')
        mapdl.allsel()
        #mapdl.eplot()
        #mapdl.result.plot_nodal_displacement(0,comp= "NORM", show_displacement=False, displacement_factor = 1.5, show_edges=True, line_width=4)
        mapdl.prep7()
              
        
        
        ## 2nd (Pressure)
        mapdl.allsel('ALL')
        mapdl.ddele('ALL', 'ALL')
        mapdl.fdele('ALL', 'ALL')
        ## Delete

        mapdl.csys(1)
        mapdl.seltol(1e-8)
        mapdl.nsel('S', 'LOC', 'Z', 0, 0)
        mapdl.nsel('R', 'LOC', 'X', self.R, self.R)    
        mapdl.d('ALL', 'ALL', 0)
        mapdl.allsel('ALL')
        mapdl.csys(0)

        #Top Layer fixed in X, Y
        mapdl.csys(1)
        mapdl.seltol(1e-8)
        mapdl.nsel('S', 'LOC', 'Z', self.H, self.H)
        mapdl.nsel('R', 'LOC', 'X', self.R, self.R)    
        mapdl.d('ALL', 'UX', 0)
        mapdl.d('ALL', 'UY', 0)
        mapdl.allsel('ALL')
        mapdl.csys(0)
        
        ##Pressure
        mapdl.esel(type_='S', item='CENT', comp='Z', vmin=self.H, vmax=self.H) # Selects elements based on a criterion related to their centroid position in Z  
        numel = mapdl.get(entity='ELEM', entnum=0, item1='COUNT') # Retrieves the count of selected elements
        ce = mapdl.get(entity='ELEM', entnum=0, item1='NUM', it1num='MIN')  # Retrieves the minimum element number from the selected set
        
        for i in range(1, int(numel + 1)):
            # Gets the first node number of the current element
            n1 = mapdl.get(entity='ELEM', entnum=ce, item1='NODE', it1num=1)
            # Gets the second node number of the current element
            n2 = mapdl.get(entity='ELEM', entnum=ce, item1='NODE', it1num=2)
            # Retrieves the X, Y, and Z coordinates of the first node
            n1x = mapdl.get(entity='NODE', entnum=n1, item1='LOC', it1num='X')
            n1y = mapdl.get(entity='NODE', entnum=n1, item1='LOC', it1num='Y')
            #n1z = mapdl.get(entity='NODE', entnum=n1, item1='LOC', it1num='Z')
            # Retrieves the X, Y, and Z coordinates of the second node
            n2x = mapdl.get(entity='NODE', entnum=n2, item1='LOC', it1num='X')
            n2y = mapdl.get(entity='NODE', entnum=n2, item1='LOC', it1num='Y')
            #n2z = mapdl.get(entity='NODE', entnum=n2, item1='LOC', it1num='Z')
            # Calculate centroid and vectors
            x_cent = 0.5 * (n1x + n2x)
            y_cent = 0.5 * (n1y + n2y)
            v1_xcomp = n2x - n1x
            v1_ycomp = n2y - n1y
            crprod = v1_xcomp * y_cent - v1_ycomp * x_cent
            # Applies a positive pressure load if the condition is met, otherwise negative
            if crprod < 0:
                mapdl.sfbeam(ce, 2, 'PRES', 1)
            else:
                mapdl.sfbeam(ce, 2, 'PRES', -1)
            # Retrieves the next element number in the selected set
            ce = mapdl.get(entity='ELEM', entnum=ce, item1='NXTH') 
        
        mapdl.allsel('ALL') #Select all entities again
        mapdl.finish()
        mapdl.slashsolu() #Solve Static Problem
        mapdl.antype('STATIC')
        mapdl.nlgeom(0)
        mapdl.pstres('ON')

        output = mapdl.solve()
        #print(output)
        mapdl.finish()
        result = mapdl.result
        ##
        # Get reaction force and total volume of strucutre
        mapdl.post1()
        # label = 'VOLU'
        # mapdl.etable(label,'VOLU')
        # mapdl.ssum()
        # totvol = mapdl.get("TOTVOL","SSUM",0,"ITEM","VOLU")
        # print(str(totvol) + ' Total volume in mm^3')
        # Reaction Force
        ## Fz, only bottom layer
        mapdl.set("last", "last")
        mapdl.nsel("S", "LOC", "Z", 0, 0)
        mapdl.fsum()
        F_Z = mapdl.get("REAC_Z", "FSUM", "","ITEM", "FZ")
        print(str(F_Z) + ' Reaction force in N in Z direction')
        ##Fx, Sum over X, need to seperate for pos and neg values
        mapdl.nsel("S", "LOC", "X", 0, self.R)
        mapdl.fsum()
        F_X1 = mapdl.get("REAC_X1", "FSUM", "","ITEM", "FX")
        mapdl.nsel("S", "LOC", "X", -self.R, 0)
        mapdl.fsum()
        F_X2 = mapdl.get("REAC_X2", "FSUM", "","ITEM", "FX")
        F_X=abs(F_X1)+abs(F_X2)
        ##FY, Sum over Y, need to seperate for pos and neg values
        mapdl.nsel("S", "LOC", "Y", 0, self.R)
        mapdl.fsum()
        F_Y1 = mapdl.get("REAC_Y1", "FSUM", "","ITEM", "FY")
        mapdl.nsel("S", "LOC", "Y", -self.R, 0)
        mapdl.fsum()
        F_Y2 = mapdl.get("REAC_Y2", "FSUM", "","ITEM", "FY")
        F_Y=abs(F_Y1)+abs(F_Y2)
        #### Calculate total Force
        F_tot = -np.sqrt(F_X**2 + F_Y**2 + F_Z**2)
        print(str(F_tot) + ' Total reaction force in N')
        mapdl.allsel()
        #mapdl.eplot()
        #mapdl.result.plot_nodal_displacement(0,comp= "NORM", show_displacement=False, displacement_factor = 1.5, show_edges=True, line_width=4)
        mapdl.prep7()
        ## Solve Buckling case
        mapdl.finish()
        mapdl.slashsolu()
        mapdl.antype('BUCKLE')
        mapdl.finish()
        mapdl.slashsolu()
        mapdl.bucopt(method='LANB', nmode=self.NOBUCK, shift='0', ldmulte='0', rangekey='CENTER')
        mapdl.mxpand(nmode=self.NOBUCK, freqb='0', freqe='0', elcalc='1', signif='0.001')
        try:
            output = mapdl.solve()
            #print(output)
            mapdl.finish()
            result = mapdl.result
    
            mapdl.post1()
            load_multiplier = mapdl.get("MULTIPLIER_LOAD", "MODE", 1,"FREQ")
            print(str(load_multiplier) + " Load multiplier")
            CRITICAL_LOAD = mapdl.get('CRITICAL_LOAD', 'ACTIVE', 0, 'SET', 'TIME')
            print(str(CRITICAL_LOAD) + 'Criical Load old')
    
            CRIT_LOAD = load_multiplier*F_tot
            print(str(CRIT_LOAD) + 'Criical Load new')
            
        except Exception as e:
        #   print(f"Skipping line {II} due to error: {e}")
            CRIT_LOAD = 0
            
        return totvol, CRIT_LOAD, F_tot, F_tot_stiffness
    
    def plot_deformed(self):
        mapdl = self.mapdl
        mapdl.eplot(show_edges=True, smooth_shading=True, show_node_numbering=False,show_bounds=True,background="k",plot_bc=True,render_lines_as_tubes=True, render_points_as_spheres=True)
        mapdl.result.plot_nodal_displacement(0,comp= "NORM", show_displacement=False, displacement_factor = 1.5, show_edges=True, line_width=4)
        return
    
    def finish_one_iteration(self,input,totvol, reaction_force, critbuck, cost):
        try: 
            iter=self.iter
            folder_name = f"{iter:08}"
            folder_path = os.path.join('./', folder_name)
            os.makedirs(folder_path, exist_ok=True)
            #print("sim", str(self.iter), " is finished.")
            #percentage = self.solid_volume_percentage(input)
            #print("Solid Area Percentage is : ", str(percentage))
            #np.savetxt('./sim_results/sim'+str(self.iter)+'.txt', np.hstack((input,totvol, reaction_force, critbuck, cost)), delimiter='/n')
            self.mapdl.eshape(scale='1', key='')
            self.mapdl.view(1, 1, 1, 1)
            dpi = 600
            fig = plt.figure(dpi=dpi)
            self.mapdl.eplot(vtk=False)
            fig.savefig(os.path.join(folder_path, f"model_new.png"), dpi=dpi)
            print("Save succesfull")
        except Exception as e:
            print("Save not succesfull")
        self.iter += 1
        self.mapdl.clear()
        
        
    def gen_iteration_plot(self):
        fig = plt.figure()
        plt.title('Optimization')
        plt.ylabel('cost of optimization')
        plt.xlabel('Iterations Number')
        return 1
    def plot_korali_iterations(self, cost):
        plt.scatter(self.iter, cost)
        plt.pause(0.5)
        return
    def finish_exit_pymapdl(self):
        ##TEST DONE##
        self.mapdl.exit()
        print("exit mapdl successful")