# -*- coding: utf-8 -*-
"""
Created on Thu May 23 14:36:53 2024

@author: ltlblue
"""
import os
import importlib.util
import numpy as np
from SpongeAPDL_2 import SpongeAPDL_2 as APDL
# from SpongeAPDLBending import SpongeAPDLBending as APDLBending
# from SpongeAPDLTorsion import SpongeAPDLTorsion as APDLTorsion
from ansys.mapdl.core import launch_mapdl

# Function to import a module from a given file path
def import_config_from_path(path):
    spec = importlib.util.spec_from_file_location("config", path)
    config = importlib.util.module_from_spec(spec)
    spec.loader.exec_module(config)
    return config

def main():
    base_dir = "."  # Assuming the folders are in the current directory
    i=0
    folder_index = 746
    while True:
        exec_loc = "/Program Files/ANSYS Inc/v232/ansys/bin/winx64/ansys232.exe"
        mapdl = launch_mapdl(exec_loc, additional_switches='-smp', override=True)
        apdl_class = APDL(mapdl)
        #apdlbending_class = APDLBending(mapdl)
        #apdltorsion_class = APDLTorsion(mapdl)
        
        
        folder_name = f"{folder_index:08}"  # Format folder index with leading zeros
        folder_path = os.path.join(base_dir, folder_name)
        config_path = os.path.join(folder_path, "config.py")

        if not os.path.exists(config_path):
            print(f"Config file not found in {folder_path}, stopping loop.")
            break

        try:
            #print(f"Processing {config_path}...")
            config = import_config_from_path(config_path)
            NV = config.NV
            NC = config.NC
            AA = config.AA
            BB = config.BB
            LOOP_NO = config.LOOP_NO
            R_E = config.R_E 
            NumBelix = config.NumBelix
            NumBelix2 = config.NumBelix2
            
            ## RUN FEA
            R=11
            H=100
            D_SHELIX =1.3 
            input_params = [R, H, NV, NC, D_SHELIX, AA, BB, LOOP_NO, R_E, NumBelix, NumBelix2, folder_index]
            print(input_params)
            ##Buckling Top Pressure
            try:
                cost = apdl_class.FEA_testing(input_params)
                crit_buck_load_top_pressure, volume, F_reac_top_pressure, F_tot_stiffness = cost[0], cost[1], cost[2], cost[3]
            except Exception as e:
                print(e)
                crit_buck_load_top_pressure, volume, F_reac_top_pressure, F_tot_stiffness = -1.0, 20000.0, 0.0, 0.0
            ##Bending
            try:
                #cost2 = apdlbending_class.FEA_testing(input_params)
                #crit_buck_load_bending, F_reac_bending = cost2[0], cost2[1]
                crit_buck_load_bending, F_reac_bending = 0.0, 0.0
            except Exception as e:
                print(e)
                crit_buck_load_bending, F_reac_bending = 0.0, 0.0
            ##Torsion    
            try:
                #cost3 = apdltorsion_class.FEA_testing(input_params)
                #crit_buck_load_torsion, F_reac_torsion = cost3[0], cost3[1]
                crit_buck_load_torsion, F_reac_torsion = 0.0, 0.0
            except Exception as e:
                print(e)
                crit_buck_load_torsion, F_reac_torsion = 0.0, 0.0
            ##Save results:    
            result_file_path = os.path.join(folder_path, "FEAresult_new.txt")  # Output as .txt file
            with open(result_file_path, 'w') as result_file:
                result_file.write(f"NV = {NV}\n")
                result_file.write(f"NC = {NC}\n")
                result_file.write(f"AA = {AA}\n")
                result_file.write(f"BB = {BB}\n")
                result_file.write(f"LOOP_NO = {LOOP_NO}\n")
                result_file.write(f"R_E = {R_E}\n")
                result_file.write(f"NumBelix = {NumBelix}\n")
                result_file.write(f"NumBelix2 = {NumBelix2}\n")
                result_file.write(f"crit_buck_load_top_pressure = {crit_buck_load_top_pressure}\n")
                result_file.write(f"volume = {volume}\n")
                result_file.write(f"F_reac_top_pressure = {F_reac_top_pressure}\n")
                result_file.write(f"F_tot_stiffness = {F_tot_stiffness}\n")
                #result_file.write(f"crit_buck_load_bending = {crit_buck_load_bending}\n")
                #result_file.write(f"F_reac_bending = {F_reac_bending}\n")
                #result_file.write(f"crit_buck_load_torsion = {crit_buck_load_torsion}\n")
                #result_file.write(f"F_reac_torsion = {F_reac_torsion}\n")

            #print(f"Parameters saved to {result_file_path}")
        except Exception as e:
            print(f"Error processing {config_path}: {e}")

        folder_index += 1
        #change to 1
        # x=[731, 732, 733, 736, 738, 1000]
        # i=i+1
        # folder_index=x[i]
        print(folder_index)
        mapdl.exit()


#run main
if __name__ == "__main__":
    main()


    

