rm(list=ls())
library(Seurat)
library(ggsci)
library(ggplot2)
library(tidyverse)

#单细胞表达
# "EPAS1"

col1 = c(pal_d3("category20")(15))
col1

setwd("D:/R_do2/SingleB/9_gene_sc/")   #设置工作路径
load("sc_anno.rda")
scRNA <- subset(scRNA,group=="Tumor")
FeaturePlot(scRNA,features = "EPAS1",
            pt.size = 0.01,
            label = T,cols = c("lightgray", "red"),
            reduction = 'umap')

#细胞通讯准备
scRNA_epi =subset(scRNA,cell_type=='Epithelial cells')
scRNA_epi@meta.data$gene_group <- ifelse(as.numeric(scRNA_epi@assays$RNA@counts['EPAS1',])>0,'EPAS1+Epi',
                                         'EPAS1-Epi')

scRNA_others=subset(scRNA,cell_type != 'Epithelial cells')
scRNA_others$gene_group=scRNA_others$cell_type
scRNA=merge(scRNA_epi,scRNA_others)

#细胞通讯
#devtools::install_github("sqjin/CellChat")
library(CellChat)
meta.data1 <- scRNA@meta.data
cellchat1 <- createCellChat(object = scRNA, 
                            meta =meta.data1, 
                            group.by = "gene_group")
levels(cellchat1@idents)
CellChatDB <- CellChatDB.human 
CellChatDB.use <- subsetDB(CellChatDB,
                           search = "Secreted Signaling")

cellchat1@DB <- CellChatDB.use

future::plan("multicore", workers = 4)
cellchat1 <- subsetData(cellchat1) 
cellchat1 <- identifyOverExpressedGenes(cellchat1)
cellchat1 <- identifyOverExpressedInteractions(cellchat1)

cellchat1 <- computeCommunProb(cellchat1, raw.use = TRUE)
cellchat1 <- filterCommunication(cellchat1, min.cells = 10)

# 在信号通路级别推断细胞-细胞通信
cellchat1 <- computeCommunProbPathway(cellchat1)
cellchat1 <- aggregateNet(cellchat1)
cellchat1 <- netAnalysis_computeCentrality(cellchat1, slot.name = "netP") # the slot 'netP' means the inferred intercellular communication network of signaling pathways

# 网络可视化
groupSize <- as.numeric(table(cellchat1@idents))
#整体评估

netVisual_circle(cellchat1@net$count, 
                 vertex.weight = groupSize,
                 weight.scale = T, 
                 label.edge= F,
                 title.name = "Number of interactions")

netVisual_circle(cellchat1@net$weight, 
                 vertex.weight = groupSize,
                 weight.scale = T, 
                 label.edge= F,
                 title.name = "Number of interactions")


netVisual_bubble(cellchat1,
                 sources.use = c(4,5),
                 remove.isolate = FALSE)

netAnalysis_signalingRole_heatmap(cellchat1, pattern = "outgoing", width = 6, height = 10) #OrRds

#单细胞 拟时序

rm(list = ls())
setwd("D:/R_do2/SingleB/9_gene_sc/")   #设置工作路径
load("sc_anno.rda")
library(monocle)

subscRNA <- subset(scRNA,cell_type == "Epithelial cells")

data <- as(as.matrix(subscRNA@assays$RNA@counts), 'sparseMatrix')

pd <- new('AnnotatedDataFrame', data = subscRNA@meta.data)
fData <- data.frame(gene_short_name = row.names(data), row.names = row.names(data))
fd <- new('AnnotatedDataFrame', data = fData)
mycds <- newCellDataSet(data,
                        phenoData = pd,
                        featureData = fd,
                        expressionFamily = negbinomial.size())#稀疏矩阵用negbinomial.size(),FPKM值用tobit(),logFPKM值用gaussianff()
mycds <- estimateSizeFactors(mycds)
mycds <- estimateDispersions(mycds, cores=8, relative_expr = TRUE)

##2使用monocle选择的高变基因
disp_table <- dispersionTable(mycds)
disp.genes <- subset(disp_table, mean_expression >= 0.1 & dispersion_empirical >= 1 * dispersion_fit)$gene_id
mycds <- setOrderingFilter(mycds, disp.genes)
p3 <- plot_ordering_genes(mycds)

##结果对比
#降维及细胞排序
#降维
mycds <- reduceDimension(mycds, max_components = 2, method = 'DDRTree')#monocle2为DDRTree
#排序
mycds <- orderCells(mycds)
save(mycds,file = "mono.rda")
load("mono.rda") 

plot_cell_trajectory(mycds, color_by = "Pseudotime")+
  scale_color_gradientn(values = seq(0,1,0.2),
                        colours = c('blue','cyan','green','yellow','orange','red'))

subscRNA@meta.data$Pseudotime <- mycds@phenoData@data$Pseudotime 

df1=as.data.frame(subscRNA[["RNA"]]@data["EPAS1",])
colnames(df1) <- "EPAS1"

identical(rownames(df1),rownames(subscRNA@meta.data))

data=cbind(subscRNA@meta.data[,c("Pseudotime","group")],df1) %>% 
  as.data.frame()

ggplot(data, aes(x=Pseudotime, y=EPAS1, color=group))+
  geom_smooth(aes(fill=group))+ #平滑的填充
  xlab('pseudotime') + 
  theme(axis.text = element_text(color = 'black',size = 12),
        axis.title = element_text(color = 'black',size = 14),
        strip.text = element_text(color = 'black',size = 14))+ #分面标题
  scale_color_manual( values = c("#3D5387","#E31A1C"))+#修改颜色
  scale_fill_manual(  values = c("#3D5387" ,"#E31A1C"))#修改颜色

library(Seurat)
library(tidyverse)
library(enrichplot)
library(clusterProfiler)
library(org.Hs.eg.db)

load("sc_anno.rda")
scRNA <- subset(scRNA,group=="Tumor")
scRNA_epi=subset(scRNA,cell_type=='Epithelial cells')

scRNA_epi@meta.data$gene_group <- ifelse(as.numeric(scRNA_epi@assays$RNA@counts['EPAS1',])>0,'EPAS1+epi',
                                        'EPAS1-epi')

Idents(scRNA_epi) <- "gene_group"

df <- FindAllMarkers(object = scRNA_epi, 
                     only.pos = F)

df1 <- df %>% filter(cluster == 'EPAS1+epi' )

genelist <- bitr(df1$gene, fromType="SYMBOL",
                 toType="ENTREZID", OrgDb='org.Hs.eg.db')

DEG <- inner_join(df1,genelist,by=c("gene"="SYMBOL"))
##1.2 按照logFC值对基因进行排序
###1: 提取logFC值，并储存在一个向量中
geneList = DEG[,2]
###2: 对geneList进行命名
names(geneList) = as.character(DEG[,'ENTREZID'])
head(geneList)
###3: 根据logFC值降序排列
geneList = sort(geneList, decreasing = TRUE)

msigdb_GMTs <- "msigdb_GMTs"

##指定用于GSEA富集分析的gmt文件
msigdb <- "h.all.v7.0.entrez.gmt"

##读取上面指定的gmt文件
kegmt <- read.gmt(file.path(msigdb_GMTs,msigdb))
CR<-GSEA(geneList,TERM2GENE = kegmt, pvalueCutoff = 0.05) #GSEA分析
#转换成数据框
CR_df <- as.data.frame(CR)
save(CR, file = "CR.Rdata")
load("CR.Rdata")
enrichplot::dotplot(CR, 
                    showCategory = 20,
                    x = "NES") +  scale_color_gradient(low = "#E31A1C", high = "grey80")  # 灰色渐变到红色

#吉克学长

# 1. NF-κB通路直接调控EMT转录因子 
#NF-κB可激活多个EMT核心转录因子的表达，包括：

# 2. 结合免疫/通讯 讨论


