rm(list = ls())
library(tidyverse)
library(stringr)
setwd("D:/R_do2/SingleB/7_immune2/")   #设置工作路径
exp <- data.table::fread("TCGA_tpm_mRNA_clini.txt")
exp <- exp %>% column_to_rownames("patient_ID") %>% t() %>% as.data.frame()
exp1 <- log2(exp+1)
#http://tide.dfci.harvard.edu/
TIDE <- exp1
# 这里为了得到比较好的结果，采用two direction median centered
TIDE <- sweep(TIDE,2, apply(TIDE,2,median,na.rm=T))
TIDE <- sweep(TIDE,1, apply(TIDE,1,median,na.rm=T))
write.table(TIDE,"TIDE_input.txt",sep = "\t",row.names = T,col.names = NA,quote = F)

###TIDE####
coldat1 <- exp1["EPAS1",,drop = F] %>% t() %>% as.data.frame()
coldat1$group <- ifelse(coldat1[,1] < median(coldat1[,1]) ,"low","high")

coldat1$group <- factor(coldat1$group,levels = c("low","high"))
coldat2 <- coldat1 [order(coldat1[,1]),] %>% dplyr::select("group")
col1 <- c("#6387BB","#DA635C")

TIDE <- read.csv("TIDE_STAD.csv",row.names = 1)

aa <- intersect(rownames(coldat1),rownames(TIDE))
TIDE <- TIDE[aa,] 
rt <- coldat1[aa,,drop=F]
rt <- cbind(rt,TIDE)

library(ggpubr)
library(cowplot)

ggplot(data=rt,aes(x=group,
                   y=MSI.Expr.Sig,
                   fill=group))+
  geom_violin(alpha=0.5,width=0.9,
              position=position_dodge(width=0.8),
              size=0.2)+
  geom_boxplot(alpha=1,width=0.3,
               position=position_dodge(width=0.8),
               size=0.5,outlier.colour = NA)+
  theme_cowplot() +
  scale_fill_manual(values=col1)+
  theme(legend.position="none") +
  stat_compare_means()

ggplot(data=rt,aes(x=Responder,
                   y=EPAS1,
                   fill=Responder))+
  geom_violin(alpha=0.5,width=0.9,
              position=position_dodge(width=0.8),
              size=0.2)+
  geom_boxplot(alpha=1,width=0.3,
               position=position_dodge(width=0.8),
               size=0.5,outlier.colour = NA)+
  theme_cowplot() +
  scale_fill_manual(values=col1)+
  theme(legend.position="none") +
  stat_compare_means()

ggplot(data=rt,aes(x=group,
                   y=Dysfunction,
                   fill=group))+
  geom_violin(alpha=0.5,width=0.9,
              position=position_dodge(width=0.8),
              size=0.2)+
  geom_boxplot(alpha=1,width=0.3,
               position=position_dodge(width=0.8),
               size=0.5,outlier.colour = NA)+
  theme_cowplot() +
  scale_fill_manual(values=col1)+
  theme(legend.position="none") +
  stat_compare_means()

IMvigor210
#IMvigor210CoreBiologies包

rm(list = ls())
load("IMV_PRO.rda")

library(survival)
library(survminer)
col1 <- c("#6387BB","#DA635C","#F0C296","#5FB6B9")
library(tidyverse)

dat <- exp1  %>% 
  dplyr::select("EPAS1")

identical(rownames(dat),rownames(rt1))

rt1 <- rt1 %>% mutate(EPAS1=dat$EPAS1)
rt1$group <- ifelse(rt1$EPAS1 > median(rt1$EPAS1),"high","low")
rt1$group=factor(rt1$group, levels=c("low", "high"))

library(survival)
library(survminer)

diff=survdiff(Surv(futime, fustat) ~group,data = rt1)
pValue=1-pchisq(diff$chisq,df=1)

fit <- survfit(Surv(futime, fustat)~ group, data =rt1)
summary(fit)


ggsurvplot(fit,
           data = rt1,
           pval.size=5,
           legend.title="EPAS1",
           legend = c(0.88, 0.88),
           font.legend=12,
           legend.labs=levels(factor(rt1[,"group"])),
           palette =col1,
           pval = T)


#最佳cutoff数值
res.cut <- surv_cutpoint(rt1,
                         time = 'futime',
                         event = 'fustat',
                         variables = "EPAS1")

cutoff=as.numeric(res.cut$cutpoint[1])
Type=ifelse(rt1[,"EPAS1"]<= cutoff, "low", "high")

data=rt1
data$group=Type
table(data$group)

data$group=factor(data$group, levels=c("low", "high"))
diff=survdiff(Surv(futime, fustat) ~ group, data = data)
length=length(levels(factor(data[,"group"])))
pValue=1-pchisq(diff$chisq, df=length-1)

fit <- survfit(Surv(futime, fustat) ~ group, data = data)

ggsurvplot(fit,
           data = data,
           legend.title="EPAS1",
           pval.size=5,
           legend = c(0.88, 0.88),
           risk.table = F,
           font.legend=12,
           legend.labs=levels(factor(data[,"group"])),
           palette =col1,
           pval = T)


ggplot(data=rt1,aes(x=BOR_single,
                   y=EPAS1,
                   fill=BOR_single))+
  geom_violin(alpha=0.5,width=0.9,
              position=position_dodge(width=0.8),
              size=0.2)+
  geom_boxplot(alpha=1,width=0.3,
               position=position_dodge(width=0.8),
               size=0.5,outlier.colour = NA)+
  theme_cowplot() +
  scale_fill_manual(values=col1)+
  theme(legend.position="none") +
  stat_compare_means()
#吉克学长


