rm(list = ls())
library(IOBR)
#免疫浸润/免疫治疗 
#装IOBR包 devtools::install_github("IOBR/IOBR") 缺什么安什么
if (!requireNamespace("BiocManager", quietly = TRUE)) install.packages("BiocManager")
depens<-c('tibble', 'survival', 'survminer', 'sva', 'limma', "DESeq2","devtools",
          'limSolve', 'GSVA', 'e1071', 'preprocessCore', 'ggplot2', "biomaRt",
          'ggpubr', "devtools", "tidyHeatmap", "caret", "glmnet", "ppcor", "timeROC","pracma")
for(i in 1:length(depens)){
  depen<-depens[i]
  if (!requireNamespace(depen, quietly = TRUE))
    BiocManager::install(depen,update = FALSE)
}
if (!requireNamespace("IOBR", quietly = TRUE))
  devtools::install_github("IOBR/IOBR")

library(tidyverse)
library(stringr)
setwd("D:/R_do2/SingleB/6_immune/")   #设置工作路径

exp <- data.table::fread("TCGA_tpm_mRNA_clini.txt")
exp <- exp %>% column_to_rownames("patient_ID") %>% t() %>% as.data.frame()
exp1 <- log2(exp+1)

####四连算法#####
cibersort <- deconvo_tme(eset = exp1, method = "cibersort", arrays = FALSE, perm = 10)
epic <- deconvo_tme(eset = exp1, method = "epic", arrays = FALSE)
mcp <- deconvo_tme(eset = exp1, method = "mcpcounter")
estimate <- deconvo_tme(eset = exp1, method = "estimate") #肿瘤

save(exp1,cibersort,epic,mcp,estimate,file = "TCGASTAD_imcell4type.rda")
load("TCGASTAD_imcell4type.rda")
#########
cibersort <- cibersort %>% 
  dplyr::select(- c("P-value_CIBERSORT", "Correlation_CIBERSORT", "RMSE_CIBERSORT"))

epic <- epic %>% dplyr::select(c(1:8))
load("uni.rda")

gene1  <-  "EPAS1"

coldat1 <- exp1[gene1,,drop = F] %>% t() %>% as.data.frame()
coldat1$group <- ifelse(coldat1[,1] < median(coldat1[,1]) ,"low","high")

coldat1$group <- factor(coldat1$group,levels = c("low","high"))
coldat2 <- coldat1 [order(coldat1[,1]),] %>% dplyr::select("group")
col1 <- c("#6387BB","#DA635C")

###cibersort_box####

cibersort1 <- cibersort %>% column_to_rownames("ID")
cibersort2 <- cibersort1[rownames(coldat2),]
identical(rownames(cibersort2),rownames(coldat2))

rt <- cbind(coldat2,cibersort2)
x=colnames(rt)[1]
colnames(rt)[1]="Type"
library(reshape2)
#把数据转换成gglpot2输入文件
data=melt(rt,id.vars=c("Type"))
colnames(data)=c("Type","Gene","Expression")
data$Type <- factor(data$Type,levels = c("low","high"))
library(ggpubr)
p=ggboxplot(data, x="Gene", y="Expression", fill = "Type", 
            ylab="Relative infiltration levels",
            xlab="",
            legend.title= gene1,
            palette = c("#6387BB","#E31A1C"),
            width=0.6, add = "none")
p=p+rotate_x_text(60)
p1=p+stat_compare_means(aes(group=Type),
                        method="wilcox.test",
                        symnum.args=list(cutpoints = c(0, 0.001, 0.01, 0.05, 1), symbols = c("***", "**", "*", " ")),
                        label = "p.signif")

p1

library(pheatmap)
cibe2 <- scale(cibersort2)
cibe3 <- cibe2 %>% t() 
cibe3[cibe3 > 3] = 3
cibe3[cibe3 < (-3)] = -3

coldata <- coldat2 %>% select("group")

pheatmap(cibe3,
         cluster_cols = F,
         color = colorRampPalette(c("#6387BB", "white","#E31A1C"))(50), 
         annotation_col = coldata, 
         show_colnames = F,
         show_rownames = T,
         fontsize = 8,
         fontsize_row=6,
         fontsize_col=6)
 

###mcp_box####
mcp1 <- mcp %>% column_to_rownames("ID")
mcp2 <- mcp1[rownames(coldat2),]
identical(rownames(mcp2),rownames(coldat2))

rt <- cbind(coldat2,mcp2)
x=colnames(rt)[1]
colnames(rt)[1]="Type"
library(reshape2)
#把数据转换成gglpot2输入文件
data=melt(rt,id.vars=c("Type"))
colnames(data)=c("Type","Gene","Expression")
data$Type <- factor(data$Type,levels = c("low","high"))
library(ggpubr)
p=ggboxplot(data, x="Gene", y="Expression", fill = "Type", 
            ylab="Relative infiltration levels",
            xlab="",
            legend.title= gene1,
            palette = c("#6387BB","#DA635C"),
            width=0.6, add = "none")
p=p+rotate_x_text(60)
p1=p+stat_compare_means(aes(group=Type),
                        method="wilcox.test",
                        symnum.args=list(cutpoints = c(0, 0.001, 0.01, 0.05, 1), symbols = c("***", "**", "*", " ")),
                        label = "p.signif")

p1
 

###estimate_box####

estimate1 <- estimate[-5] %>% column_to_rownames("ID")
estimate2 <- estimate1[rownames(coldat2),]
colnames(estimate2) <- str_remove(colnames(estimate2),"_estimate")
identical(rownames(estimate2),rownames(coldat2))

rt <- cbind(coldat2,estimate2)
x=colnames(rt)[1]
colnames(rt)[1]="Type"
library(reshape2)
#把数据转换成gglpot2输入文件
data=melt(rt,id.vars=c("Type"))
colnames(data)=c("Type","Gene","Expression")
data$Type <- factor(data$Type,levels = c("low","high"))
library(ggpubr)
p=ggboxplot(data, x="Gene", y="Expression", fill = "Type", 
            ylab="Relative infiltration levels",
            xlab="",
            legend.title=gene1,
            palette = c("#6387BB","#DA635C"),
            width=0.6, add = "none")
p=p+rotate_x_text(60)
p1=p+stat_compare_means(aes(group=Type),
                        method="wilcox.test",
                        symnum.args=list(cutpoints = c(0, 0.001, 0.01, 0.05, 1), symbols = c("***", "**", "*", " ")),
                        label = "p.signif")
p1

###estimate_vln####

rt$Type <- factor(rt$Type,levels = c("low","high"))

ggplot(data=rt,aes(x=Type,
                   y=StromalScore,
                   fill=Type))+
  geom_violin(alpha=0.5,width=0.9,
              position=position_dodge(width=0.8),
              size=0.2)+
  geom_boxplot(alpha=1,width=0.3,
               position=position_dodge(width=0.8),
               size=0.5,outlier.colour = NA)+
  theme_classic() +
  scale_fill_manual(values= c("#6387BB","#DA635C"))+
  theme(legend.position="none") +
  xlab(gene1) +
  stat_compare_means()


ggplot(data=rt,aes(x=Type,
                   y=ImmuneScore,
                   fill=Type))+
  geom_violin(alpha=0.5,width=0.9,
              position=position_dodge(width=0.8),
              size=0.2)+
  geom_boxplot(alpha=1,width=0.3,
               position=position_dodge(width=0.8),
               size=0.5,outlier.colour = NA)+
  theme_classic() +
  scale_fill_manual(values= c("#6387BB","#DA635C"))+
  theme(legend.position="none") +
  xlab(gene1) +
  stat_compare_means()


###cibersort_cor####
coldat3 <- coldat1[rownames(cibersort1),]
rtt <- cbind(coldat3,cibersort1)

cor.test(rtt$EPAS1,rtt$`T_cells_regulatory_(Tregs)_CIBERSORT`,method ="spearman")

ggplot(rtt,aes(EPAS1,`T_cells_regulatory_(Tregs)_CIBERSORT`))+ 
  geom_point(size=2)+
  geom_smooth(method=lm, se=T,na.rm=T, col="grey") +
  theme_classic()


###ICI_box####
range(exp1)
gene <- c('CD274',"PDCD1LG2","PDCD1","LAG3")
exp_ici <-exp1[gene,] %>% t() %>% as.data.frame()

exp_ici <- exp_ici[rownames(coldat2),]
identical(rownames(exp_ici),rownames(coldat2))

rt <- cbind(coldat2,exp_ici)

x=colnames(rt)[1]
colnames(rt)[1]="Type"
library(reshape2)
#把数据转换成gglpot2输入文件
data=melt(rt,id.vars=c("Type"))
colnames(data)=c("Type","Gene","Expression")
data$Type <- factor(data$Type,levels = c("low","high"))
library(ggpubr)
p=ggboxplot(data, x="Gene", y="Expression", fill = "Type", 
            ylab="Gene expression",
            xlab="",
            legend.title=x,
            palette = c("#6387BB","#DA635C"),
            width=0.6, add = "none")
p=p+rotate_x_text(60)
p1=p+stat_compare_means(aes(group=Type),
                        method="wilcox.test",
                        symnum.args=list(cutpoints = c(0, 0.001, 0.01, 0.05, 1), symbols = c("***", "**", "*", " ")),
                        label = "p.signif")

p1
#

Type <- rbind(data.frame(ID = colnames(cibersort)[2:23], method = "CIBERSORT"),
              data.frame(ID = colnames(mcp)[2:ncol(mcp)], method = "MCP_counter"), 
              data.frame(ID = colnames(epic)[2:ncol(epic)], method = "EPIC"))

table(Type$method)
Type <- column_to_rownames(Type, "ID")

IMGRPD <- exp1 %>% t() %>% as.data.frame() %>% select("EPAS1") %>% arrange(EPAS1)
IMGRPD$EPAS1 <- log2(IMGRPD$EPAS1+1)
IMGRPD$group <- ifelse(IMGRPD$EPAS1 > median(IMGRPD$EPAS1), "high", "low")
library(pheatmap)

annColors <- list(method = c("CIBERSORT" = "#6387BB", 
                             "EPIC" = "#984EA3",
                             "MCP_counter" = "#E31A1C"),
                  "group" = c("high" = "red", "low" = "blue"), 
                  EPAS1 = colorRampPalette(c("white","red"))(50))


tme_combine <- cibersort %>% 
  inner_join(mcp, "ID") %>% 
  inner_join(epic, "ID") %>% 
  column_to_rownames("ID")

tme_combine <- scale(tme_combine,
                     center = TRUE, scale = TRUE)

#确定匹配
tme_combine1 <- t(tme_combine)[rownames(Type),rownames(IMGRPD)]

tme_combine1[tme_combine1 > 3] = 3
tme_combine1[tme_combine1 < (-3)] = -3

pheatmap(tme_combine1, 
         color = colorRampPalette(c("blue", "white","red"))(50), 
         cluster_rows = FALSE, # 行不聚类
         cluster_cols = FALSE, # 列不聚类
         show_rownames = TRUE, # 不显示行名
         show_colnames = FALSE,
         fontsize_row = 11, 
         annotation_col = IMGRPD, # 不显示行名
         annotation_row = Type,
         annotation_colors = annColors, 
         gaps_col = table(IMGRPD$group)[2])
#吉克学长
