library(tidyverse)
rm(list=ls())
setwd("D:/R_do2/SingleB/5_Enrich/")   #设置工作路径

#富集分析 提示作用 过渡/实验？
#单基因富集
library(tidyverse)
library(DESeq2)
exp<- read.table("TCGA_count_mRNA.txt",sep = "\t",check.names = F,stringsAsFactors = F,header = T,row.names = 1)

##利用中位数分组
tum.sam <- colnames(exp)[substr(colnames(exp),14,16) == "01A"]
exp <- exp[,c(tum.sam)]

coldat1 <- exp["EPAS1",,drop=F] %>% t() %>% as.data.frame()
coldat1$group <- ifelse(coldat1$EPAS1 < median(coldat1$EPAS1) ,"low","high")
coldat2 <- coldat1 %>% arrange(EPAS1)

exp <- exp[,rownames(coldat2)]
identical(rownames(coldat2),colnames(exp))

group_list <- factor(coldat2$group,levels = c("low","high"))
exp <- round(exp)
conditions = data.frame(conditions=group_list)

##差异分析

dds <- DESeqDataSetFromMatrix(
  countData = exp,
  colData = conditions,
  design = ~ conditions)
#使用DESeq进行差异表达分析
dds <- DESeq(dds)
#获取分析结果
#load(paste0(cancer_type,"dd.Rdata"))
contrast=c("conditions",rev(levels(group_list)))
res <- results(dds, contrast)
res
#查看每一项结果的具体含义
mcols(res, use.names = TRUE)
#查看描述性结果
summary(res)

resOrdered <- res[order(res$padj),]   #按照padj值排序
DEG <- as.data.frame(resOrdered)
DEG <- DEG %>% na.omit()

write.table(DEG, file='DESeq2_results.txt',sep = "\t",row.names = T,col.names = NA,quote = F)

logFC_cutoff <- 1
type1 = (DEG$padj < 0.05)&(DEG$log2FoldChange < -logFC_cutoff)
type2 = (DEG$padj < 0.05)&(DEG$log2FoldChange > logFC_cutoff)
DEG$change = ifelse(type1,"DOWN",ifelse(type2,"UP","NOT"))
table(DEG$change)

DESeq2_DEG <- DEG
write.table(DESeq2_DEG, file='DESeq2_diff.txt',sep = "\t",row.names = T,col.names = NA,quote = F)

DEG <- read.table("DESeq2_diff.txt",sep = "\t",check.names = F,stringsAsFactors = F,header = T)
colnames(DEG)[1] <- "Gene"

library(enrichplot)
library(clusterProfiler)
library(org.Hs.eg.db)
library(tidyverse)
genelist <- bitr(DEG$Gene, fromType="SYMBOL",
                 toType="ENTREZID", OrgDb='org.Hs.eg.db')
DEG <- inner_join(DEG,genelist,by=c("Gene"="SYMBOL"))
##1.2 按照logFC值对基因进行排序
###1: 提取logFC值，并储存在一个向量中
geneList = DEG[,3]

###2: 对geneList进行命名
names(geneList) = as.character(DEG[,'ENTREZID'])
head(geneList)
###3: 根据logFC值降序排列
geneList = sort(geneList, decreasing = TRUE)
msigdb_GMTs <- "msigdb_GMTs"

##指定用于GSEA富集分析的gmt文件
msigdb <- "h.all.v7.0.entrez.gmt"

##读取上面指定的gmt文件
kegmt <- read.gmt(file.path(msigdb_GMTs,msigdb))
HAL <-GSEA(geneList,TERM2GENE = kegmt, pvalueCutoff = 0.05) #GSEA分析
#转换成数据框
HAL_df <- as.data.frame(HAL)
save(HAL, file = "HAL.Rdata")

gseaplot2(HAL, geneSetID = c("HALLMARK_EPITHELIAL_MESENCHYMAL_TRANSITION"),
          pvalue_table = T,   subplots = 1:2, #可以调整
          color="#DA635C")

gseaplot2(HAL, geneSetID = c("HALLMARK_INFLAMMATORY_RESPONSE"),
          pvalue_table = T,   subplots = 1:2, #可以调整
          color="#DA635C")

col1 <- c("#DA635C","steelblue","#00AFBB")


gseaTab = NULL
gseaTab <- rbind.data.frame(gseaTab,
                            data.frame(term = HAL_df$ID,
                                       NES = HAL_df$NES,
                                       padj = HAL_df$p.adjust,
                                       stringsAsFactors = F),
                            stringsAsFactors = F)

gseaTab <- gseaTab[order(gseaTab$NES),]
gseaTab$term <- factor(gseaTab$term, 
                       levels = gseaTab$term)

library(cols4all)
ggplot(gseaTab,aes(x = NES,
                          y = term,
                          fill = NES)) + 
  geom_col() +
  theme_classic()+ scale_fill_continuous_c4a_div('sunset', mid = 0)


DEG <- read.table("DESeq2_diff.txt",sep = "\t",check.names = F,stringsAsFactors = F,header = T)
colnames(DEG)[1] <- "Gene"

genelist <- bitr(DEG$Gene, fromType="SYMBOL",
                 toType="ENTREZID", OrgDb='org.Hs.eg.db')
DEG <- inner_join(DEG,genelist,by=c("Gene"="SYMBOL"))

gene_up = DEG[DEG$change == 'UP','ENTREZID'] 
gene_down = DEG[DEG$change == 'DOWN','ENTREZID'] 
gene_diff = c(gene_up,gene_down)
kk <- enrichKEGG(gene         =  gene_diff,
                 organism     = 'hsa',
                 pvalueCutoff = 0.05,
                 qvalueCutoff =0.05)

dotplot(kk, showCategory = 15,color = "p.adjust")
