library(tidyverse)
rm(list=ls())
setwd("D:/R_do2/SingleB/4_Clinical/")   #设置工作路径
##预后
rt1 <- data.table::fread("TCGA_Clinical.txt",data.table = F)
rownames(rt1) <- rt1$patient_ID
rt1 <- rt1 %>% dplyr::select(futime="time",fustat="status")

dat <- data.table::fread("TCGA_tpm_mRNA_clini.txt",data.table = F)
dat <- dat %>% column_to_rownames("patient_ID")

identical(rownames(dat),rownames(rt1))

comsam <- intersect(rownames(dat),rownames(rt1))
dat <- dat[comsam,] %>% dplyr::select("EPAS1")
dat <- log2(dat+1)
rt1 <- rt1[comsam,]

identical(rownames(dat),rownames(rt1))
rt1$EPAS1 <- dat$EPAS1
rt1$group <- ifelse(rt1$EPAS1 > median(rt1$EPAS1),"high","low")

library(survival)
library(survminer)

diff=survdiff(Surv(futime, fustat) ~group,data = rt1)
pValue=1-pchisq(diff$chisq,df=1)

fit <- survfit(Surv(futime, fustat)~ group, data =rt1)
summary(fit)

ggsurvplot(fit,
           data = rt1,
           legend.title = "EPAS1",
           palette = c("#1F78B4","#E31A1C"),
           pval = T)


res.cut <- surv_cutpoint(rt1,
                         time = 'futime',
                         event = 'fustat',
                         variables = "EPAS1")

cutoff=as.numeric(res.cut$cutpoint[1])
Type=ifelse(rt1[,"EPAS1"]<= cutoff, "low", "high")

data=rt1
data$group=Type
table(data$group)

data$group=factor(data$group, levels=c("low", "high"))
diff=survdiff(Surv(futime, fustat) ~ group, data = data)
length=length(levels(factor(data[,"group"])))
pValue=1-pchisq(diff$chisq, df=length-1)

fit <- survfit(Surv(futime, fustat) ~ group, data = data)

ggsurvplot(fit,
           data = data,
           legend.title="EPAS1",
           risk.table = F,
           font.legend=12,
           palette =c("#1F78B4","#E31A1C"),
           pval = T)

##临床相关性
rm(list=ls())
sinfo <- data.table::fread("TCGA_Clinical.txt",data.table = F)
sinfo <- sinfo %>% column_to_rownames("patient_ID")

dat <- data.table::fread("TCGA_tpm_mRNA_clini.txt",data.table = F)
dat <- dat %>% column_to_rownames("patient_ID")

identical(rownames(dat),rownames(sinfo))

comsam <- intersect(rownames(dat),rownames(sinfo))

dat1 <- dat[comsam,] %>% dplyr::select("EPAS1")
dat1 <- log2(dat1+1)

sinfo <- sinfo[comsam,]

identical(rownames(dat1),rownames(sinfo))

dat1$Tstage <- sinfo$T_stage
dat1$Nstage <- sinfo$N_stage
dat1$Mstage <- sinfo$M_stage

dat1$Tstage <- substr(dat1$Tstage,1,2) # T分期只取前两位字符
dat1$Nstage <- substr(dat1$Nstage,1,2) # N分期只取前两位字符
dat1$Mstage <- substr(dat1$Mstage,1,2) # M分期只取前两位字符
table(dat1$Mstage)

dat1[which(dat1$Tstage == ""),"Tstage"] <- NA #  
dat1[which(dat1$Tstage == "TX"),"Tstage"] <- NA # TX无效，改为NA
dat1[which(dat1$Nstage == ""),"Nstage"] <- NA # NX无效，改为NA
dat1[which(dat1$Nstage == "NX"),"Nstage"] <- NA # NX无效，改为NA
dat1[which(dat1$Mstage == ""),"Mstage"] <- NA # MX无效，改为NA
dat1[which(dat1$Mstage == "MX"),"Mstage"] <- NA # MX无效，改为NA

dat1 <- dat1 %>% na.omit()
dat1$Tstage <- factor(dat1$Tstage,levels = c("T1","T2","T3","T4"))   
dat1$Nstage <- factor(dat1$Nstage,levels = c("N0","N1","N2","N3")) 
dat1$Mstage <- factor(dat1$Mstage,levels = c("M0","M1"))      

#调整绘图
library(ggplot2)
library(ggpubr)
ggboxplot(dat1,
          x = "Tstage",
          y = "EPAS1",
          fill = "Tstage", 
          size = 0.6)+
  stat_compare_means()+
  scale_fill_manual(values =  c('#7382BC', '#bb4316',"#1F78B4","#E31A1C"))

library(ggbeeswarm)
ggplot(dat1, aes(Tstage, EPAS1)) +
  geom_boxplot(
    aes(fill = Tstage),
    colour =  'grey50' ) +
  geom_quasirandom(
    aes(colour = Tstage),
    method = 'tukeyDense',
    width =  0.3, 
    size = 2,
    dodge.width = 0.8, 
    alpha = 0.7
  ) +
  scale_fill_manual(values = c("#7382BC80", "#BB431680" ,"#1F78B480", "#E31A1C80")) +
  scale_colour_manual(values = c('#7382BC', '#bb4316',"#1F78B4","#E31A1C")) +
  theme_classic()+  
  theme(legend.position = "none")+
  stat_compare_means()


ggplot(dat1, aes(Nstage, EPAS1)) +
  geom_boxplot(
    aes(fill = Nstage),
    colour =  'grey50' ) +
  geom_quasirandom(
    aes(colour = Nstage),
    method = 'tukeyDense',
    width =  0.3, 
    size = 2,
    dodge.width = 0.8, 
    alpha = 0.7
  ) +
  scale_fill_manual(values = c("#7382BC80", "#BB431680" ,"#1F78B480", "#E31A1C80")) +
  scale_colour_manual(values = c('#7382BC', '#bb4316',"#1F78B4","#E31A1C")) +
  theme_classic()+  
  theme(legend.position = "none")+
  stat_compare_means()

ggplot(dat1, aes(Mstage, EPAS1)) +
  geom_boxplot(
    aes(fill = Mstage),
    colour =  'grey50' ) +
  geom_quasirandom(
    aes(colour = Mstage),
    method = 'tukeyDense',
    width =  0.3, 
    size = 2,
    dodge.width = 0.8, 
    alpha = 0.7
  ) +
  scale_fill_manual(values = c("#1F78B480", "#E31A1C80")) +
  scale_colour_manual(values = c("#1F78B4","#E31A1C")) +
  theme_classic()+  
  theme(legend.position = "none")+
  stat_compare_means()

library(tidyverse)
rm(list=ls())
setwd("D:/R_do2/SingleB/4_Clinical/")   #设置工作路径

load("GSE84433_pro.rda")

dat <- exp3 %>% t() %>% as.data.frame() %>% dplyr::select("EPAS1")

identical(rownames(dat),rownames(rt3))
rt3$EPAS1 <- dat$EPAS1
rt3$group <- ifelse(rt3$EPAS1 > median(rt3$EPAS1),"high","low")

library(survival)
library(survminer)

diff=survdiff(Surv(futime, fustat) ~group,data = rt3)
pValue=1-pchisq(diff$chisq,df=1)

fit <- survfit(Surv(futime, fustat)~ group, data =rt3)
summary(fit)

ggsurvplot(fit,
           data = rt3,
           legend.title = "EPAS1",
           palette = c("#1F78B4","#E31A1C"),
           pval = T)


res.cut <- surv_cutpoint(rt3,
                         time = 'futime',
                         event = 'fustat',
                         variables = "EPAS1")


cutoff=as.numeric(res.cut$cutpoint[1])
Type=ifelse(rt3[,"EPAS1"]<= cutoff, "low", "high")

data=rt3
data$group=Type
table(data$group)

data$group=factor(data$group, levels=c("low", "high"))
diff=survdiff(Surv(futime, fustat) ~ group, data = data)
length=length(levels(factor(data[,"group"])))
pValue=1-pchisq(diff$chisq, df=length-1)

fit <- survfit(Surv(futime, fustat) ~ group, data = data)

ggsurvplot(fit,
           data = data,
           legend.title="EPAS1",
           risk.table = F,
           font.legend=12,
           palette =c("#1F78B4","#E31A1C"),
           pval = T)
#b站吉克学长
