rm(list = ls())
setwd("D:/R_do2/SingleB/3_TCGA_uni/")   #设置工作路径
library(tidyverse)
load("hubgene.rda")

###
exp <- data.table::fread("TCGA_tpm_mRNA_clini.txt") %>% 
  column_to_rownames("patient_ID") 

exp1 <- log2(exp[,JJ2]+1)

rt <- data.table::fread("TCGA_Clinical.txt")%>% 
  column_to_rownames("patient_ID") %>% dplyr::select(c("time","status")) 

aa <- intersect(rownames(rt),rownames(exp1))
rt <- rt[aa,]
exp1 <- exp1[aa,]

exp2 <- scale(exp1)

identical(rownames(rt),rownames(exp2))
surv.expr <- cbind(rt,exp2)

write.table(surv.expr, file='surv_expr_TCGA.txt',sep = "\t",row.names = T,col.names = NA,quote = F)

library(survival)
Coxoutput <- NULL # 初始化结果
for(i in 3:ncol(surv.expr)){
  g <- colnames(surv.expr)[i]
  cox <- coxph(Surv(time,status) ~ surv.expr[,i], data = surv.expr) # 单变量cox模型
  coxSummary = summary(cox)
  
  # 取出模型的相应系数
  Coxoutput <- rbind.data.frame(Coxoutput,
                                data.frame(gene = g,
                                           HR = as.numeric(coxSummary$coefficients[,"exp(coef)"])[1],
                                           z = as.numeric(coxSummary$coefficients[,"z"])[1],
                                           pvalue = as.numeric(coxSummary$coefficients[,"Pr(>|z|)"])[1],
                                           lower = as.numeric(coxSummary$conf.int[,3][1]),
                                           upper = as.numeric(coxSummary$conf.int[,4][1]),
                                           stringsAsFactors = F),
                                stringsAsFactors = F)
}

write.table(Coxoutput, file = "COX_TCGA.txt",sep = "\t",row.names = F,col.names = T,quote = F)

#森林图绘制
Coxoutput2 <- Coxoutput
str(Coxoutput2)
ltt <- cbind(c("Gene",Coxoutput2$gene),
             c("HR",round(as.numeric(Coxoutput2$HR),3)),
             c("L CI",round(as.numeric(Coxoutput2$lower),3)),
             c("U CI",round(as.numeric(Coxoutput2$upper),3)),
             c("pvalue",round(as.numeric(Coxoutput2$pvalue),3)))

library(forestplot)

forestplot(labeltext=ltt,
           mean=c(NA,as.numeric(Coxoutput2$HR)),
           lower=c(NA,as.numeric(Coxoutput2$lower)), 
           upper=c(NA,as.numeric(Coxoutput2$upper)),
           graph.pos=5,# 图在表中的列位置
           graphwidth = unit(.25,"npc"),# 图在表中的宽度比
           fn.ci_norm="fpDrawDiamondCI",
           col=fpColors(box="red", lines="red", zero = "black"),# box颜色
           boxsize=0.4,# box大小固定
           lwd.ci=1,
           ci.vertices.height = 0.1,ci.vertices=T,# 显示区间
           zero=1,# zero线横坐标
           clip=c(0.1,1.5),
           xticks = c(0.5,1,1.5),
           lwd.zero=1.5,# zero线宽
           lwd.xaxis=1,
           xlab="Hazard ratios",
           txt_gp=fpTxtGp(label=gpar(cex=0.7),
                          ticks=gpar(cex=0.7),
                          xlab=gpar(cex=0.7),
                          title=gpar(cex=0.7)),
           hrzl_lines=list("1" = gpar(lwd=1.5, col="black"),
                           "2" = gpar(lwd=1.5, col="black"), 
                           "24" = gpar(lwd=1.5, col="black")), 
           lineheight = unit(.75,"cm"),# 固定行高
           colgap = unit(0.3,"cm")) # 横坐标刻度根据需要可随意设置

Coxoutput1 <- Coxoutput[which(Coxoutput$pvalue < 0.05),] #0.05

hr <- round(Coxoutput1$HR,3)
CI_LL <- round(Coxoutput1$lower,3)
CI_HL <- round(Coxoutput1$upper,3)
HR <- paste0(hr,"(", CI_LL, "-", CI_HL, ")")
p <- round(Coxoutput1$pvalue,6)
unicox1 <- data.frame(Gene = Coxoutput1$gene,
                      HR_95CI = HR,
                      pvalue = p)
gene1 <- unicox1$Gene

write.csv(unicox1,file = "unicox1.csv",row.names = F)
save(gene1,surv.expr,file = "uni.rda")

library(circlize)
library(ggsci)

rt1 <- Coxoutput %>% arrange(HR) %>% dplyr::select(1,2,4,5,6)
rt1$HR <- round(rt1$HR,2)
rt1$lower <- round(rt1$lower,2)
rt1$upper <- round(rt1$upper,2)

col = c(pal_d3("category20")(15),pal_d3("category20b")(7))
sectors = rt1$gene
names(sectors) <- sectors
gene <- data.frame(gene = sectors)
rownames(gene) <- sectors
names(col) <- sectors

### 为HR值提供两个颜色
col_P=ifelse(rt1$pvalue< 0.05,'#E31A1C','grey70')

#-----------------------开始做图------------------#
#关闭之前的circos图形
dev.off()
circos.clear()
#绘图参数
circos.par(gap.degree = 2, 
           cell.padding = c(0, 0, 0, 0),
           track.margin = c(0.01, 0.01))
#绘制圆形热图
circos.heatmap(gene, split = gene$gene, 
               col = col, 
               track.height = 0.1,
               rownames.side = 'outside',
               rownames.cex	= 0.6)

#在单个轨道中为单元格创建绘图区域
circos.track(ylim = c(0, 1), 
             sectors = sectors,
             bg.col = col_P, 
             bg.border = "#CCCCCC" , 
             track.height = 0.4)

#在整个轨道之间的单元格中绘制文本
circos.trackText(x = rep(0.6, nrow(rt1)), 
                 y = rep(0.6, nrow(rt1)),
                 labels = paste0(rt1$HR,' (',rt1$lower,'-',rt1$upper,')'),
                 cex = 0.7, 
                 sectors = sectors, 
                 col = "white", 
                 font = 2, 
                 facing = "reverse.clockwise",
                 niceFacing=T)
#在圆圈中绘制扇区或环
draw.sector(center = c(0, 0), 
            start.degree = 0, 
            end.degree = 360,
            rou1 = 0.2, 
            col = "gray88")
#添加中间文字
text(0,0,"HR(95%CI)",
     col = 'white',
     cex = 0.8,font = 0.3)

# b站/公众号：吉克学长



