rm(list=ls())
setwd("D:/R_do2/SingleB/2_score/")   #设置工作路径
library(tidyverse)
library(Seurat)
load("sc_anno.rda")
#BiocManager::install("clusterProfiler")
#https://www.gsea-msigdb.org/gsea/msigdb/human/genesets.jsp
pheno_gene <- clusterProfiler::read.gmt("GOBP_RESPONSE_TO_OXIDATIVE_STRESS.v2024.1.Hs.gmt")

geneset=list(pheno_gene$gene)
names(geneset)='OS'

## AUCell 
#BiocManager::install("AUCell")
library(AUCell)
cells_rankings <- AUCell_buildRankings(scRNA@assays$RNA@data,  nCores=1, plotStats=TRUE) 

cells_AUC <- AUCell_calcAUC(geneset, cells_rankings,nCores =1, aucMaxRank=nrow(cells_rankings)*0.1)
aucs <- as.numeric(getAUC(cells_AUC)['OS', ])
scRNA$AUCell <- aucs

library(viridis)
pal <-  viridis(n = 10, option = "C")

FeaturePlot(scRNA,features = 'AUCell',
            cols =pal,
            label = T,reduction = 'umap')

FeaturePlot(scRNA,features = 'AUCell',
            cols =pal,
            label = T,reduction = 'umap',split.by = "group")


rt=scRNA@meta.data
colnames(rt)
library(ggsci)
library(ggplot2)
library(ggpubr)
library(tidyverse)

data <- rt[,c(4,9,10)]
colnames(data)
library(ggpubr)
library(cowplot)

p <- ggplot(data,
            aes(cell_type, AUCell, 
                color = group,
                fill = group)) + 
  geom_boxplot(alpha =0.8,
               notch=TRUE,width=0.7,
               outlier.shape = 21,
               outlier.colour = "white", 
               outlier.size = 0.5) +  theme_classic()+
  scale_fill_manual(values= c("#1F78B4","#E31A1C")) +
  scale_color_manual(values= c("#1F78B4","#E31A1C")) +
  theme(axis.text.x = element_text(angle = 45, hjust = 1), 
        axis.title.y = element_text(angle = 90)) 

# 标注差异分析结果
p1 <- p +stat_compare_means(aes(group=group),
                            method="wilcox.test",
                            symnum.args=list(cutpoints = c(0, 0.001, 0.01, 0.05, 1), 
                                             symbols = c("***", "**", "*", " ")),
                            label = "p.signif")
p1


save(scRNA,file ="sc_score.rda")
#拟时序
rm(list = ls())
setwd("D:/R_do2/SingleB/2_score/")   #设置工作路径
load("sc_score.rda")
library(monocle)
library(tidyverse)
library(ggplot2)
subscRNA <- subset(scRNA,cell_type == "Epithelial cells")
data <- as(as.matrix(subscRNA@assays$RNA@counts), 'sparseMatrix')

pd <- new('AnnotatedDataFrame', data = subscRNA@meta.data)
fData <- data.frame(gene_short_name = row.names(data), row.names = row.names(data))
fd <- new('AnnotatedDataFrame', data = fData)
mycds <- newCellDataSet(data,
                        phenoData = pd,
                        featureData = fd,
                        expressionFamily = negbinomial.size())#稀疏矩阵用negbinomial.size(),FPKM值用tobit(),logFPKM值用gaussianff()
mycds <- estimateSizeFactors(mycds)
mycds <- estimateDispersions(mycds, cores=8, relative_expr = TRUE)

##2使用monocle选择的高变基因
disp_table <- dispersionTable(mycds)
disp.genes <- subset(disp_table, mean_expression >= 0.1 & dispersion_empirical >= 1 * dispersion_fit)$gene_id
mycds <- setOrderingFilter(mycds, disp.genes)
p3 <- plot_ordering_genes(mycds)

##结果对比
#降维及细胞排序
#降维
mycds <- reduceDimension(mycds, max_components = 2, method = 'DDRTree')#monocle2为DDRTree
#排序
mycds <- orderCells(mycds)
save(mycds,file = "mono.rda")
library(Seurat)
plot_cell_trajectory(mycds, color_by = "Pseudotime")

plot_cell_trajectory(mycds, color_by = "Pseudotime")+
  scale_color_gradientn(values = seq(0,1,0.2),
                        colours = c('blue','cyan','green','yellow','orange','red'))

plot_cell_trajectory(mycds, color_by = "group")

subscRNA@meta.data$Pseudotime <- mycds@phenoData@data$Pseudotime 


mydata<- FetchData(subscRNA,vars = c("UMAP_1","UMAP_2","Pseudotime"))
ggplot(mydata,aes(x = UMAP_1,y =UMAP_2,colour = Pseudotime))+
  geom_point(size = 1)+
  scale_color_gradientn(values = seq(0,1,0.2),
                        colours = c('blue','cyan','green','yellow','orange','red'))+theme_classic()

mydata<- FetchData(subscRNA,vars = c("UMAP_1","UMAP_2","AUCell"))
ggplot(mydata,aes(x = UMAP_1,y =UMAP_2,colour = AUCell))+
  geom_point(size = 1)+
  scale_color_gradientn(values = seq(0,1,0.2),
                        colours = c('blue',"grey90","#E31A1C"))+theme_classic()

data1 <- FetchData(subscRNA,vars = c("group","AUCell","Pseudotime"))

ggplot(data1, aes(x=Pseudotime, y=AUCell, color=group))+
  geom_smooth(aes(fill=group))+ #平滑的填充
  xlab('pseudotime') + 
  theme(axis.text = element_text(color = 'black',size = 12),
        axis.title = element_text(color = 'black',size = 14),
        strip.text = element_text(color = 'black',size = 14))+ #分面标题
  scale_color_manual( values = c("#3D5387","#E31A1C"))+#修改颜色
  scale_fill_manual(  values = c("#3D5387" ,"#E31A1C"))#修改颜色


rm(list = ls())
setwd("D:/R_do2/SingleB/2_score/")   #设置工作路径
library(tidyverse)
library(Seurat)
library(ggplot2)
load("sc_score.rda")
subscRNA <- subset(scRNA,cell_type == "Epithelial cells")

Idents(subscRNA) <- "group"
deg <- FindMarkers(subscRNA,
                       ident.1 = 'Tumor',
                       ident.2 = 'Control', 
                       only.pos = F)

deg <- deg %>%
  dplyr::mutate(delta_pct = (deg$pct.1-deg$pct.2)*100,
                gene = rownames(deg),
                regulation = case_when(avg_log2FC>0.25&p_val<0.05 ~ 'up',
                                       avg_log2FC< -0.25&p_val<0.05 ~ 'down',
                                       TRUE~'non'))

bullcol <- c( "#2838a3" ,"grey80","#E31A1C"  )

ggplot(deg, aes(avg_log2FC, delta_pct)) +
  coord_flip()+
  geom_hline(yintercept = 0, linetype = "dashed", color = "black",size = 1) +
  geom_vline(xintercept = 0, linetype = "dashed", color = "black",size = 1) +
  geom_point(aes(size = abs(delta_pct), color = regulation)) + # 使用 Dif 填充颜色
  scale_color_manual(values = bullcol) + # 使用 bullcol 映射颜色
  scale_size_continuous(range = c(1, 3.5)) +
  theme_bw(base_size = 12) +
  theme(
    panel.grid = element_blank(),
    legend.position = 'right',
    axis.text = element_text(size = 12) ) +
  guides(color = guide_legend(title = "Regulation"), size = "none") + # 修改图例标题
  xlab("Log2FC") + ylab("Δpct") 

table(deg$regulation)
up_gene <- deg$gene[which(deg$regulation == "up")]

pheno_gene <- clusterProfiler::read.gmt("GOBP_RESPONSE_TO_OXIDATIVE_STRESS.v2024.1.Hs.gmt")
pheno_gene <- pheno_gene$gene

JJ2 <- intersect(pheno_gene,up_gene)

a1 <- list(UP_genes = up_gene,
           OXIDATIVE_STRESS = pheno_gene)


library(ggvenn)
ggvenn(a1,fill_color = c("red", "blue"))      

save(JJ2,file = "hubgene.rda")

rm(list=ls())
setwd("D:/R_do2/SingleB/2_score/")   #设置工作路径
library(tidyverse)
library(Seurat)
load("hubgene.rda")
#BiocManager::install("clusterProfiler")
library(clusterProfiler)
library(org.Hs.eg.db)

genelist <- bitr(JJ2, fromType="SYMBOL",
                 toType="ENTREZID", OrgDb='org.Hs.eg.db')


diffgene =genelist$ENTREZID

kk <- enrichKEGG(gene         =  diffgene,
                 organism     = 'hsa',
                 pvalueCutoff = 0.5,
                 qvalueCutoff =0.5)

write.table(kk,file="KEGG_table.txt",sep="\t",quote=F,row.names = F)
#绘图

rt1 <- read.table("KEGG_table.txt",sep = "\t",header = T)

rt1$Description <- factor(rt1$Description, levels = rev(rt1$Description))
rt1 <- rt1 %>% top_n(-10,pvalue)


#基础富集条形图绘制：
p <- ggplot() +
  geom_bar(data = rt1,
           aes(x = -log10(pvalue),
               y = Description,fill = Description),
           width = 0.6, #柱子宽度调整
           stat = 'identity') +
  theme_classic()
p

p1 <- p + scale_x_continuous(expand = c(0,0))
p1

p2 <- p1 +
  theme(axis.text.y = element_blank(),#去掉y轴标签
        axis.ticks.y = element_blank(),#去掉y轴小柱
        axis.title.y = element_blank(),#去掉y轴标题
        legend.position = "none") + 
  geom_text(data = rt1,
            aes(x = 0.1, #用数值向量控制文本标签起始位置
                y = Description,
                label = Description),
            size = 3.5,
            hjust = 0) #左对齐
p2

##细胞组分 CC
GO_CC <- enrichGO(gene = diffgene,
                  OrgDb= org.Hs.eg.db,
                  ont = "CC",
                  pAdjustMethod = "BH",
                  minGSSize = 1,
                  pvalueCutoff = 0.5,
                  qvalueCutoff = 0.5,
                  readable = TRUE)
write.table(GO_CC,file="GO_CC.txt",sep="\t",quote=F,row.names = F)
##生物过程 BP
GO_BP <- enrichGO(gene = diffgene,
                  OrgDb= org.Hs.eg.db,
                  ont = "BP",
                  pAdjustMethod = "BH",
                  minGSSize = 1,
                  pvalueCutoff = 0.5,
                  qvalueCutoff = 0.5,
                  readable = TRUE)
write.table(GO_BP,file="GO_BP.txt",sep="\t",quote=F,row.names = F)
## 分子功能 MF
GO_MF <- enrichGO(gene = diffgene,
                  OrgDb= org.Hs.eg.db,
                  ont = "MF",
                  pAdjustMethod = "BH",
                  minGSSize = 1,
                  pvalueCutoff = 0.5,
                  qvalueCutoff = 0.5,
                  readable = TRUE)
write.table(GO_MF,file="GO_MF.txt",sep="\t",quote=F,row.names = F)

## 点图
dotplot(GO_MF, showCategory = 10,color = "pvalue")
dotplot(GO_BP, showCategory = 10,color = "pvalue")
dotplot(GO_CC, showCategory = 10,color = "pvalue")



