#!/bin/bash
# 02_octopus_pipeline.sh
# Somatic mutation calling using Octopus in tumor-normal mode

REFERENCE="reference.fa"
TUMOR_BAM="tumor.bam"
NORMAL_BAM="normal.bam"
OUTPUT_VCF="octopus_somatic.vcf.gz"

octopus \
  -R $REFERENCE \
  -I $TUMOR_BAM -I $NORMAL_BAM \
  -T TUMOR --normal-sample NORMAL \
  -o $OUTPUT_VCF \
  --threads 8
