#!/bin/bash
# 01_mutect2_pipeline.sh
# Tumor-normal somatic mutation detection using GATK Mutect2 (no germline resource)

TUMOR_BAM="tumor.bam"
NORMAL_BAM="normal.bam"
REFERENCE="reference.fa"

RAW_VCF="mutect2_raw.vcf.gz"
FILTERED_VCF="mutect2_filtered.vcf.gz"
CUSTOM_FILTERED_VCF="mutect2_final.vcf"

gatk Mutect2 \
  -R $REFERENCE \
  -I $TUMOR_BAM -tumor TUMOR \
  -I $NORMAL_BAM -normal NORMAL \
  -O $RAW_VCF

gatk FilterMutectCalls \
  -V $RAW_VCF \
  -O $FILTERED_VCF

bcftools view -i 'FORMAT/DP[0]>=10 & FORMAT/DP[1]>=10 & FORMAT/AD[0:1]>=3 & FORMAT/AD[1:1]==0' \
  $FILTERED_VCF -Ov -o $CUSTOM_FILTERED_VCF
