import os
import subprocess
import platform
import shutil
import pandas as pd

class ExecutionWorker():
    def __init__(self):
        pass
    
    def compile(self, source_cpp_path, executable_file_path):
        
        if platform.system() == 'Windows':
            exec_code = os.system(
                "g++ -O3 -Wall -std=c++17 {} -o {}".format( source_cpp_path, executable_file_path ) )
            if exec_code != 0:
                return False

            return True

        elif platform.system() == 'Linux':
            # current_dir = os.getcwd()
            # print("current_dir: ", current_dir)
            exec_code = os.system(
                "g++ -O3 -Wall -std=c++17 {} -o {}".format( source_cpp_path, executable_file_path ) )
            if exec_code != 0:
                return False
            return True

        else:
            raise ValueError("Unsupported this kind of system!")

    def execute(self, executable_file_path, instance_file, output_file):
        if platform.system() == 'Windows':
            exec_code = os.system("start {}.exe {} > {}".format(executable_file_path, instance_file, output_file))
            if exec_code != 0:
                return False
            return True

        elif platform.system() == 'Linux':
            exec_code = os.system(
                "{} {} > {}".format(executable_file_path, instance_file, output_file))
            if exec_code != 0:
                return False
            return True

        else:
            raise ValueError("Unsupported this kind of system!")
    
    def eval_info(self,output_file):
        f = pd.read_csv(output_file)
        # if f:
        return f
        # else:
            # exit('The output file {} does not exist'.format(output_file))



class ExecutionWorkerModSAT():
    def __init__(self):
        pass
    
    def compile(self, output_dir):
        workdir = os.path.join(output_dir, 'minisat')
        exec_code = os.system(
            "cd {} && pwd && make config prefix=./ && make install >/dev/null 2>&1".format(workdir))
        if exec_code != 0:
            return False
        return True

    def execute(self, output_dir, executable_file_path, instance_file, output_file, timeout):
        libdir = os.path.join(output_dir, 'minisat', 'lib/')
        exec_code = os.system(
            "export LD_LIBRARY_PATH=$LD_LIBRARY_PATH:{} && {} {} -cpu-lim={} > {}".format(libdir, executable_file_path, instance_file, timeout, output_file))
        
        # exec_code = os.system(
        #     "export LD_LIBRARY_PATH=$LD_LIBRARY_PATH:{} && {} {} -var-decay=0.99 -cla-decay=0.999 -min-learnts=1000.0 -cpu-lim={} > {}".format(libdir, executable_file_path, instance_file, timeout, output_file))
        if exec_code != 0:
            return False
        return True

    
    def eval_info(self,output_file):
        f = pd.read_csv(output_file)
        # if f:
        return f
        # else:
            # exit('The output file {} does not exist'.format(output_file))
