from problem import MotifFinding
from mymutation import MyMutation
from mycrossover import MyCrossover
from pymoo.algorithms.nsga2 import NSGA2
from pymoo.optimize import minimize
from pymoo.visualization.scatter import Scatter
from pymoo.operators.crossover.simulated_binary_crossover import SimulatedBinaryCrossover
from pymoo.operators.mutation.polynomial_mutation import PolynomialMutation
from pymoo.factory import get_performance_indicator
import numpy as np
import matplotlib.pyplot as plt



input_file = "hm03.txt"
l_mer = 21
seqs = open(input_file,'r')
seqs = seqs.readlines()

sequences = []

for line in seqs:
    sequences.append(line[:-1])

motif_finding = MotifFinding(n_var = len(sequences),n_obj = 2,xl=0,xu = len(sequences[0])-l_mer,seqs = sequences,l_mer = l_mer, parallelization = ("threads", 8))

algorithm = NSGA2(pop_size=200,
                  elimate_duplicates=True,
                  mutation=MyMutation(prob=0.4)
                  ,crossover=SimulatedBinaryCrossover(prob = 0.5,eta = 15)
                  )

hv = get_performance_indicator("hv", ref_point=np.array([1.2,
                                                         1.2]))

hvs = []

res = minimize(motif_finding,
               algorithm,
               ('n_gen', 1000),
               seed=1,
               verbose=False
               ,save_history = True)

#plt.figure(1)
#plt.clf()
gens = []
for g, a in enumerate(res.history):
    if g % 20 == 0 and g>50:
        a.opt = a.pop.copy()
        #a.opt = a.opt[a.opt.collect(lambda ind: ind.feasible)[:, 0]]
        #I = NonDominatedSorting().do(a.opt.get("F"),
        #                             only_non_dominated_front=True)
        #a.opt = a.opt[I]
        X, F, CV, G = a.opt.get("X", "F", "CV", "G")
        hvs.append(hv.calc(F))
        gens.append(g)
        #print("hv", hv.calc(A))

plt.plot(gens,hvs)
plt.show()
print("Best solution found: \nX = %s\nF = %s" % (res.X, res.F))
