#include<bits/stdc++.h>

using namespace std;

int limit = 50;
int MCN = 3000;
int SN = 200;
int l_mers[] = {16,18,20,22};
int l_mer;
string dataset;
string datasets[] = {"dm01g.txt","dm03g.txt","hm03.txt","hm09g.txt","yst04r.txt","yst08r.txt"};
string mode = "sim";

double rand_float()
{
    return (double)rand()/RAND_MAX;
}

int rand_range(int min,int max,int not_allowed = -1) //max hishebe 1 beshi pathaite hobe
{
    while(true)
    {
        int r = min + rand()%(max - min);
        if(r != not_allowed) return r;
    }
}

void print_vector(vector<int>v)
{
    for(int i=0;i<v.size();i++)printf("%d ",v[i]);
    puts("");
}

vector<int> generate_random_food_source(int no_of_solutions,int length)
{
    vector<int>v;
    for(int i=0;i<no_of_solutions;i++)
    {
        v.push_back(rand_range(0,length - l_mer + 1));
    }

    return v;
}

double fitness(vector<string>seqs)
{
    double fit = 0.0;
    for(int i=0;i<l_mer;i++)
    {
        int a = 0 , c = 0, g = 0, t = 0;
        for(int j=0;j<seqs.size();j++)
        {
            if(seqs[j][i] == 'A')a++;
            else if(seqs[j][i] == 'C')c++;
            else if(seqs[j][i] == 'G')g++;
            else t++;
        }

        fit += max(max(a,c),max(g,t));
    }

    return fit/(seqs.size() * l_mer);
}

double entropy(vector<string>seqs)
{
    double fit = 0.0;
    for(int i=0;i<l_mer;i++)
    {
        int a = 0 , c = 0, g = 0, t = 0;
        for(int j=0;j<seqs.size();j++)
        {
            if(seqs[j][i] == 'A')a++;
            else if(seqs[j][i] == 'C')c++;
            else if(seqs[j][i] == 'G')g++;
            else t++;
        }

        fit += (double)a/(a+c+g+t)*log2((double)a/(a+c+g+t));
        fit += (double)c/(a+c+g+t)*log2((double)c/(a+c+g+t));
        fit += (double)g/(a+c+g+t)*log2((double)g/(a+c+g+t));
        fit += (double)t/(a+c+g+t)*log2((double)t/(a+c+g+t));

    }

    return fit/(l_mer * 4);
}

double calculate_fitness(vector<int> solution,vector<string>seqs)
{
    vector<string>subseqs;
    for(int i=0;i<solution.size();i++)
    {
        subseqs.push_back(seqs[i].substr(solution[i],l_mer));
    }

    if(mode == "sim")return fitness(subseqs);
    else return entropy(subseqs);
}

int main()
{
    for(int ll = 0; ll<4;ll++)
    {
        for(int dd = 0;dd < 6;dd++)
        {
            l_mer = l_mers[ll];
            dataset = datasets[dd];
            for(int lol=0;lol<20;lol++)
            {
                srand(time(NULL));

                FILE *fp = fopen(dataset.c_str(),"r");
                vector<string>seqs;

                while(!feof(fp))
                {
                    char line[2000];
                    fscanf(fp,"%s",line);
                    string s(line);
                    seqs.push_back(s);
                }
                fclose(fp);

                vector<vector<int> > solutions;
                vector<int> best;
                double maximum_fitness = -1.0;
                vector<int>limits;

                for(int i=0;i<SN;i++)
                {
                    vector<int>solution = generate_random_food_source(seqs.size(),strlen(seqs[0].c_str()));
                    solutions.push_back(solution);
                    limits.push_back(0);
                    double f = calculate_fitness(solution,seqs);
                    if(f > maximum_fitness)
                    {
                        maximum_fitness = f;
                        best = solution;
                    }
                }

                for(int l=0;l<MCN;l++)
                {
                    double probability_sum = 0.0;
                    for(int i=0;i<SN;i++)
                    {
                        vector<int> solution = solutions[i];
                        int k = rand_range(0,solutions.size(),i);
                        int j = rand_range(0,solution.size());

                        double prev_fitness = calculate_fitness(solution,seqs);
                        int temp = solution[j];
                        solution[j] = solutions[k][j];

                        double next_fitness = calculate_fitness(solution,seqs);

                        if(prev_fitness > next_fitness)
                        {
                            solution[j] = temp;
                            solutions[i][j] = temp;
                            probability_sum += prev_fitness;
                            limits[i]++;
                        }
                        else if(prev_fitness < next_fitness)
                        {
                            solutions[i][j] = solutions[k][j];

                            probability_sum += next_fitness;

                            limits[i] = 0;
                        }


                        if(maximum_fitness < calculate_fitness(solution,seqs))
                        {
                            maximum_fitness = next_fitness;
                            best = solution;
                        }
                    }


                    int sentbees = 0, currentSource = 0;

                    vector<double>probabilities;

                    for(int i=0;i<SN;i++)probabilities.push_back(calculate_fitness(solutions[i],seqs) / probability_sum);

                    while(sentbees != SN)
                    {
                        if(probabilities[currentSource] > rand_float())
                        {
                            sentbees++;

                            vector<int> solution = solutions[currentSource];
                            int k = rand_range(0,solutions.size(),currentSource);
                            int j = rand_range(0,solution.size());

                            double prev_fitness = calculate_fitness(solution,seqs);
                            int temp = solution[j];
                            solution[j] = solutions[k][j];

                            double next_fitness = calculate_fitness(solution,seqs);

                            if(prev_fitness > next_fitness)
                            {
                                solution[j] = temp;
                                solutions[currentSource][j] = temp;
                                limits[currentSource]++;
                            }
                            else if(prev_fitness < next_fitness)
                            {
                                solutions[currentSource][j] = solutions[k][j];
                                limits[currentSource] = 0;
                            }

                            if(maximum_fitness < calculate_fitness(solution,seqs))
                            {
                                maximum_fitness = next_fitness;
                                best = solution;
                            }
                        }

                        currentSource = (currentSource + 1)%SN;
                    }


                    for(int i=0;i<SN;i++)
                    {
                        if(limits[i] > limit)
                        {
                            solutions[i] = generate_random_food_source(seqs.size(),strlen(seqs[0].c_str()));
                            double f = calculate_fitness(solutions[i],seqs);
                            if(f > maximum_fitness)
                            {
                                maximum_fitness = f;
                                best = solutions[i];
                            }
                            limits[i] = 0;
                            break;
                        }
                    }
                }
                string path = "ABC algo Output//"+mode+"//" + dataset + ".txt";
                FILE *fp1 = fopen(path.c_str(),"a");
                fprintf(fp1,"%d %lf\n",l_mer, maximum_fitness);
                fclose(fp1);
                printf("%s %d %d %lf\n",dataset.c_str(),l_mer,lol,maximum_fitness);
                //print_vector(best);
            }
        }
    }
    return 0;
}
