function [F0,Ft0,Fx0,Fy0,Fz0,Fxx0,Fyy0,Fzz0,Fxy0,Fxz0,Fyz0]...
    = NPSE_disturb(m,n,sz,st,omega,beta,...
                   F1,Ft1,Fx1,Fy1,Fz1,Fxx1,Fyy1,Fzz1,Fxy1,Fxz1,Fyz1,JF)

zz   = sqrt(-1);
exp1 = exp(zz*JF+zz*n*beta*sz-zz*m*omega*st);


if m==0
    F0=F1.*exp1;
    Ft0=Ft1.*exp1;
    Fx0=Fx1.*exp1;
    Fy0=Fy1.*exp1;
    Fz0=Fz1.*exp1;
    Fxx0=Fxx1.*exp1;
    Fyy0=Fyy1.*exp1;
    Fzz0=Fzz1.*exp1;
    Fxy0=Fxy1.*exp1;
    Fxz0=Fxz1.*exp1;
    Fyz0=Fyz1.*exp1;
else
    F0=2*real(F1.*exp1);
    Ft0=2*real(Ft1.*exp1);
    Fx0=2*real(Fx1.*exp1);
    Fy0=2*real(Fy1.*exp1);
    Fz0=2*real(Fz1.*exp1);
    Fxx0=2*real(Fxx1.*exp1);
    Fyy0=2*real(Fyy1.*exp1);
    Fzz0=2*real(Fzz1.*exp1);
    Fxy0=2*real(Fxy1.*exp1);
    Fxz0=2*real(Fxz1.*exp1);
    Fyz0=2*real(Fyz1.*exp1);    
end

end
