function [AAA,BBB] = LST_build(Case,Mesh,Baseflow,Re,alpha,beta,omega)

% Constant
zi = sqrt(-1);

% Build the Matrix
D=kron(Mesh.Dy,eye(5,5));
DD=kron(Mesh.DDy,eye(5,5));

Lt =spalloc(Mesh.N*5, Mesh.N*5, 5*5*Mesh.N);
Lx =spalloc(Mesh.N*5, Mesh.N*5, 5*5*Mesh.N);
Ly =spalloc(Mesh.N*5, Mesh.N*5, 5*5*Mesh.N);
Lz =spalloc(Mesh.N*5, Mesh.N*5, 5*5*Mesh.N);
Lq =spalloc(Mesh.N*5, Mesh.N*5, 5*5*Mesh.N);
Vxx=spalloc(Mesh.N*5, Mesh.N*5, 5*5*Mesh.N);
Vxy=spalloc(Mesh.N*5, Mesh.N*5, 5*5*Mesh.N);
Vxz=spalloc(Mesh.N*5, Mesh.N*5, 5*5*Mesh.N);
Vyy=spalloc(Mesh.N*5, Mesh.N*5, 5*5*Mesh.N);
Vyz=spalloc(Mesh.N*5, Mesh.N*5, 5*5*Mesh.N);
Vzz=spalloc(Mesh.N*5, Mesh.N*5, 5*5*Mesh.N);


switch Case.Matrix
    case 'Ideal_curvature'
        for i=1:Mesh.N
            [Lt((i-1)*5+1:(i-1)*5+5,(i-1)*5+1:(i-1)*5+5),...
             Lx((i-1)*5+1:(i-1)*5+5,(i-1)*5+1:(i-1)*5+5),...
             Ly((i-1)*5+1:(i-1)*5+5,(i-1)*5+1:(i-1)*5+5),...
             Lz((i-1)*5+1:(i-1)*5+5,(i-1)*5+1:(i-1)*5+5),...
             Lq((i-1)*5+1:(i-1)*5+5,(i-1)*5+1:(i-1)*5+5),...
             Vxx((i-1)*5+1:(i-1)*5+5,(i-1)*5+1:(i-1)*5+5),...
             Vxy((i-1)*5+1:(i-1)*5+5,(i-1)*5+1:(i-1)*5+5),...
             Vxz((i-1)*5+1:(i-1)*5+5,(i-1)*5+1:(i-1)*5+5),...
             Vyy((i-1)*5+1:(i-1)*5+5,(i-1)*5+1:(i-1)*5+5),...
             Vyz((i-1)*5+1:(i-1)*5+5,(i-1)*5+1:(i-1)*5+5),...
             Vzz((i-1)*5+1:(i-1)*5+5,(i-1)*5+1:(i-1)*5+5)]...
             =LST_Calc_matrix(i,Re,Mesh,Baseflow,Case); %#ok<*SPRIX> 
        end
    case 'Non_ideal_no_curvature'
        for i=1:Mesh.N
            [Lt((i-1)*5+1:(i-1)*5+5,(i-1)*5+1:(i-1)*5+5),...
             Lx((i-1)*5+1:(i-1)*5+5,(i-1)*5+1:(i-1)*5+5),...
             Ly((i-1)*5+1:(i-1)*5+5,(i-1)*5+1:(i-1)*5+5),...
             Lz((i-1)*5+1:(i-1)*5+5,(i-1)*5+1:(i-1)*5+5),...
             Lq((i-1)*5+1:(i-1)*5+5,(i-1)*5+1:(i-1)*5+5),...
             Vxx((i-1)*5+1:(i-1)*5+5,(i-1)*5+1:(i-1)*5+5),...
             Vxy((i-1)*5+1:(i-1)*5+5,(i-1)*5+1:(i-1)*5+5),...
             Vxz((i-1)*5+1:(i-1)*5+5,(i-1)*5+1:(i-1)*5+5),...
             Vyy((i-1)*5+1:(i-1)*5+5,(i-1)*5+1:(i-1)*5+5),...
             Vyz((i-1)*5+1:(i-1)*5+5,(i-1)*5+1:(i-1)*5+5),...
             Vzz((i-1)*5+1:(i-1)*5+5,(i-1)*5+1:(i-1)*5+5)]...
             =LST_Calc_matrix_new(i,Re,Mesh,Baseflow,Case); %#ok<*SPRIX> 
        end
end
        

    
% Spatial / temporal Problem
if Case.Spatial
    if Case.Spatialf
    L0  = -zi*omega*Lt+Ly*D+zi*beta*Lz+Lq+Vyy*DD+zi*beta*Vyz*D-beta^2*Vzz;
    L1  = beta*Vxz-zi*Vxy*D-zi*Lx;
    L2  = Vxx;
    AAA = [sparse(Mesh.N*5,Mesh.N*5), speye(Mesh.N*5,Mesh.N*5);...
           L0, -L1; ];
    BBB = [speye(Mesh.N*5,Mesh.N*5), sparse(Mesh.N*5,Mesh.N*5);...
            sparse(Mesh.N*5,Mesh.N*5), L2];
    else
    AAA = -zi*omega*Lt+Ly*D+zi*beta*Lz+Lq+Vyy*DD+zi*beta*Vyz*D-beta^2*Vzz;
    BBB = beta*Vxz-zi*Vxy*D-zi*Lx;
    end
else
    AAA = alpha*Lx-zi*Ly*D+beta*Lz-zi*Lq+zi*alpha^2*Vxx+alpha*Vxy*D...
          +zi*alpha*beta*Vxz-zi*Vyy*DD+beta*Vyz*D+zi*beta^2*Vzz;
    BBB = Lt;
end

% B.C.
if Case.Spatialf
    AAA(Mesh.N*5+5,:)=AAA(Mesh.N*5+1,:);  %Continuity equation
    AAA(Mesh.N*5+1:Mesh.N*5+4,:)=0;
    AAA(Mesh.N*5+1,2)=1;         % u(1)
    AAA(Mesh.N*5+2,3)=1;         % v(1)
    AAA(Mesh.N*5+3,4)=1;         % w(1)
    AAA(Mesh.N*5+4,5)=1;         % T(1)
    % AAA(Mesh.N*5+4,5+5)=-1;         

    AAA(Mesh.N*5-3:Mesh.N*5,:)=0;
    AAA(Mesh.N*5-3,Mesh.N*5-3)=1;   % u(N)
    AAA(Mesh.N*5-2,Mesh.N*5-2)=1;   % v(N)
    AAA(Mesh.N*5-1,Mesh.N*5-1)=1;   % w(N)
    AAA(Mesh.N*5-0,Mesh.N*5-0)=1;   % T(N)


    BBB(Mesh.N*5+1:Mesh.N*5+4,:)=0;
    BBB(Mesh.N*5-3:Mesh.N*5,:)=0; %#ok<*NASGU>
else
    AAA(5,:)=AAA(1,:);  %Continuity equation
    AAA(1:4,:)=0;
    AAA(1,2)=1;         % u(1)
    AAA(2,3)=1;         % v(1)
    AAA(3,4)=1;         % w(1)
    AAA(4,5)=1;         % T(1)
    % AAA(4,5+5)=-1;         

    AAA(Mesh.N*5-3:Mesh.N*5,:)=0;
    AAA(Mesh.N*5-3,Mesh.N*5-3)=1;   % u(N)
    AAA(Mesh.N*5-2,Mesh.N*5-2)=1;   % v(N)
    AAA(Mesh.N*5-1,Mesh.N*5-1)=1;   % w(N)
    AAA(Mesh.N*5-0,Mesh.N*5-0)=1;   % T(N)


    BBB(1:4,:)=0;
    BBB(Mesh.N*5-3:Mesh.N*5,:)=0; %#ok<*NASGU>
end
end

