function [output1, output2] = mn2mn(varargin)


% if input is Case, m, n,  output is mn
% if input is Case, mn,    output is m, n


% 获取输入参数个数
numInputs = nargin;

% 获取输出参数个数
numOutputs = nargout;


if numInputs == 3
    % 如果传入了3个参数，执行操作1
    Case = varargin{1};
    m    = varargin{2};
    n    = varargin{3};

    mn    = m*(2*Case.nmax+1)+(Case.nmax+1+n);
    output1 = mn;

    if numOutputs~=1
        error('Invalid number of output arguments, should be one!')
    end

elseif numInputs == 2
    % 如果传入了两个参数，执行操作2
    Case = varargin{1};
    mn   = varargin{2};
    if Case.nmax==0
        n = 0;
        m = mn-1;
        
    else
        m    = floor(mn/(2*Case.nmax+1));
        n    = mn - m*(2*Case.nmax+1)-Case.nmax-1;
    end

    output1 = m;
    output2 = n;
else
    % 如果传入了其他数量的参数，执行默认操作或抛出错误
    error('Invalid number of input arguments. for mn2mn');
end



    
 

end

