function [ Mesh ] = Set_Grid(Mesh,Case)


    % Input
    N=Mesh.N;
    
    % Output
    y=zeros(length(N),1);  
    z=zeros(length(N),1);
    dzdy=zeros(length(N),1);        
    ddzdyy=zeros(length(N),1); 
    
    switch Case.flow % 2DBL / 3DBL / Channel 
        case '2DBL'  
            ymax=Mesh.ymax;
            yi=Mesh.yi;
            a=ymax*yi/(ymax-2*yi); 
            b=1+2*a/ymax;
            
            if Mesh.cheby
                z = cos((0:N-1)*pi/(N-1))';
                dz=1;
                for i = 1:1:N
                    y(i)        = a*(1-z(i))/(b+z(i));
                    dzdy(i)     = -(a+a*b)/(y(i)+a)^2;
                    ddzdyy(i)   = 2*(a+a*b)/(y(i)+a)^3;
                end
            else
                dz = 2.0/(N-1); 
                for i = 1:1:N
                    z(i)        = -1+(i-1)*dz;           %[-1.0,1.0]
                    y(i)        = a*(1+z(i))/(b-z(i));
                    dzdy(i)     = (a+a*b)/(y(i)+a)^2;
                    ddzdyy(i)   = -2*(a+a*b)/(y(i)+a)^3;
                end
            end
            y=y';
            dzdy=dzdy';
            ddzdyy=ddzdyy';
            
        case 'Channel'
            if Mesh.cheby
                % Chebshev
                z = cos((0:N-1)*pi/(N-1))';
                y = 1-z;
                dzdy = -ones(N,1);
                ddzdyy = zeros(N,1);
                dz=1;
            else
                fact=Mesh.fact;
                dz = 1.0/(N-1);
                z = ((0:N-1))/(N-1) - 0.5;               %[-0.5,0.5]
                y = 1 + tanh(fact*z)/tanh(fact*0.5);
                y = y';

                dzdy =   tanh(fact/2.0)/fact*cosh(fact*z).^2.0;
                ddzdyy = (tanh(fact/2.0))^2/fact*cosh(fact*z).^2.0.*sinh(2*fact*z); % check this term

                dzdy=dzdy';
                ddzdyy=ddzdyy';
            end
    end
    
    Mesh.z=z;
    Mesh.y=y;
    Mesh.dz=dz;
    Mesh.dzdy=dzdy;
    Mesh.ddzdyy=ddzdyy;

end

