% Output: Fai(mn), alpha(mn)

function [Residual_mn,alfmn,Faixi] = NPSE_solve_Chang(Baseflow, xi, Case, Mesh,...
        m, n,alfmn,Faixi1,Fmn,JF,...
    gamma,A,A2,B,C,D,Vxx,Vyy,Vzz,Vxy,Vxz,Vyz,modes)


omega = Case.omega;
beta  = Case.beta;
dx    = Mesh.dx;

zz    = 1i;
alfx  = 0;
Ny    = Mesh.N;
DD1   = kron(Mesh.Dy,eye(5,5));
DD2   = kron(Mesh.DDy,eye(5,5));
     
A1    = A2-2*zz*Vxx*alfmn-zz*n*beta*Vxz;
B1    = B-zz*alfmn*Vxy-zz*n*beta*Vyz;
D1    = D+zz*n*beta*C-zz*m*omega*gamma+zz*alfmn*A...
        +n^2*beta^2*Vzz-zz*alfx*Vxx+alfmn^2*Vxx+alfmn*n*beta*Vxz;
C1    = Vyy;

AAA=A1/dx+B1*DD1+D1-C1*DD2;
BBB=A1/dx;
     
% Boundary condition
AAA(5,:)=AAA(1,:);
AAA(1:4,:)=0; AAA(5*Ny-3:5*Ny,:)=0;
BBB(5,:)=BBB(1,:);
BBB(1:4,:)=0; BBB(5*Ny-3:5*Ny,:)=0;
     
    
AAA(1,2)=1;% u=0
AAA(2,3)=1;% v=0
AAA(3,4)=1;% w=0
AAA(4,5)=1;% T=0
     
AAA(5*Ny-3,5*Ny-3)=1;% u=0
AAA(5*Ny-1,5*Ny-1)=1;% w=0
AAA(5*Ny,5*Ny)=1;    % T=0

if m==0 && n==0 % v_y=0
     AAA(5*Ny-2,5*Ny-2)=1.5;
     AAA(5*Ny-2,5*Ny-7)=-2;
     AAA(5*Ny-2,5*Ny-12)=0.5; 
else % v=0
     AAA(5*Ny-2,5*Ny-2)=1; 
end


BBB2=(BBB*Faixi1+Fmn/exp(zz*JF));
Faixi=AAA\BBB2;


Residual_mn = 0; 
switch Case.method
    case {'Standard','IterFmn'} % Iteratie only the main mode
        if m == Case.m0 && n == Case.n0
            Residual_mn = NPSE_renew_alf_Chang(Baseflow,xi,Mesh,Faixi,Faixi1);
                  alfmn = alfmn-Residual_mn*zz;
        end
    case {'twin'} % Iteratie only the (1,1) and (1,-1)
        if m == Case.m0 && (n == Case.n0 ||n == -Case.n0)
            Residual_mn = NPSE_renew_alf_Chang(Baseflow,xi,Mesh,Faixi,Faixi1);
                  alfmn = alfmn-Residual_mn*zz;
        end
    case 'allmodes'
        if m == Case.m0 && (n == Case.n0 ||n == -Case.n0)
            Residual_mn = NPSE_renew_alf_Chang(Baseflow,xi,Mesh,Faixi,Faixi1);
                  alfmn = alfmn-Residual_mn*zz;
        elseif m ~= 0 && n ~= 0 && modes > 10
            Residual_mn = NPSE_renew_alf_Chang(Baseflow,xi,Mesh,Faixi,Faixi1);
                  alfmn = alfmn-Residual_mn*zz;
        end

end





end

