function [gamma,A,A2,B,C,D,Hxx,Hyy,Hzz,Hxy,Hyz,Hxz] =...
    NPSE_matrix(Baseflow,xi,Case,Mesh)

% note: the matrix Hxx and so on can not be named as Vyy ... since it
% confilicts with the base flow name Vyy ...

%K=parameter.K;
%h1=1+K*y(i);
%h11=K
h1 =1;
h11=0;
Ny = Mesh.N;

r  = Case.gama;
Rg = Case.Rg;
RE = Case.Re0;
PR = Case.Pr;
EC = Case.Ec;



U    = Baseflow.U(:,xi);   
Ux   = Baseflow.Ux(:,xi); 
Uy   = Baseflow.Uy(:,xi); 
Uxy  = Baseflow.Uxy(:,xi); 
Uyy  = Baseflow.Uyy(:,xi); 
Uxx  = zeros(Ny,1);

V    = Baseflow.V(:,xi);   
Vx   = Baseflow.Vx(:,xi); 
Vy   = Baseflow.Vy(:,xi); 
Vxy  = Baseflow.Vxy(:,xi); 
Vyy  = Baseflow.Vyy(:,xi); 
Vxx  = zeros(Ny,1);

T    = Baseflow.T(:,xi);   
Tx   = Baseflow.Tx(:,xi); 
Ty   = Baseflow.Ty(:,xi); 
Tyy  = Baseflow.Tyy(:,xi); 
Txx  = zeros(Ny,1);

Den  = Baseflow.Den(:,xi);   
Denx = Baseflow.Denx(:,xi); 
Deny = Baseflow.Deny(:,xi); 


%ideal gas
e= Rg*T/(r-1);
et=Rg/(r-1)*ones(Ny,1);
ett=zeros(Ny,1);
er=zeros(Ny,1);
err=zeros(Ny,1);
ert=zeros(Ny,1);
        
p=Den*Rg.*T;
pt=Den*Rg;
ptt=zeros(Ny,1);
pr=Rg*T;
prr=zeros(Ny,1);
prt=Rg*ones(Ny,1);

%sutherland law        
a1=110.4/Case.Te;
miu=(1.0+a1)*T.^1.5./(T+a1);
miut=(1.0+a1)*sqrt(T).*(0.5*T+1.5*a1)./((T+a1).^2.0);
miutt=(0.75*(T.^0.5+a1*T.^(-0.5)).*(T+a1).^2.0-(T.^1.5+3.0*a1*T.^0.5).*(T+a1)).*(1.0+a1)./(T+a1).^4.0;
miur=zeros(Ny,1);
miurr=zeros(Ny,1);
miurt=zeros(Ny,1);

a2=194/Case.Te;
ka=(1.0+a2)*T.^1.5./(T+a2);
kat=(1.0+a2)*sqrt(T).*(0.5*T+1.5*a2)./((T+a2).^2.0);
katt=(0.75*(T.^0.5+a2*T.^(-0.5)).*(T+a2).^2.0-(T.^1.5+3.0*a2*T.^0.5).*(T+a2)).*(1.0+a2)./(T+a2).^4.0;
kar=zeros(Ny,1);
karr=zeros(Ny,1);
kart=zeros(Ny,1);

gamma = zeros(Ny*5,Ny*5);
A     = zeros(Ny*5,Ny*5);
A2    = zeros(Ny*5,Ny*5);
B     = zeros(Ny*5,Ny*5);
C     = zeros(Ny*5,Ny*5);
D     = zeros(Ny*5,Ny*5);
Hxx   = zeros(Ny*5,Ny*5);
Hyy   = zeros(Ny*5,Ny*5);
Hzz   = zeros(Ny*5,Ny*5);
Hxy   = zeros(Ny*5,Ny*5);
Hxz   = zeros(Ny*5,Ny*5);
Hyz   = zeros(Ny*5,Ny*5);


for i=1:Ny
    agamma=[1,0,0,0,0;U(i),Den(i),0,0,0;V(i),0,Den(i),0,0;0,0,0,Den(i),0;e(i)+Den(i).*er(i),0,0,0,Den(i).*et(i)];
    
    
    aA=[h1.^(-1).*U(i),h1.^(-1).*Den(i),0,0,0;h1.^(-1).*pr(i)+h1.^(-1).*U(i).^2+(-4/3).*h1.^(-2).*RE.^(-1).*miur(i).*Ux(i)+(-4/3).*h1.^(-2).*h11.*RE.^(-1).* ...
      miur(i).*V(i)+(2/3).*h1.^(-1).*RE.^(-1).*miur(i).*Vy(i),(-4/3).*h1.^(-2).*RE.^(-1).*Denx(i).*miur(i)+(-4/3).*h1.^(-2).*RE.^(-1).*miut(i).*Tx(i)+2.* ...
      h1.^(-1).*Den(i).*U(i),(-7/3).*h1.^(-2).*h11.*RE.^(-1).*miu(i)+(-1).*h1.^(-1).*RE.^(-1).*Deny(i).*miur(i)+(-1).*h1.^(-1).*RE.^(-1).*miut(i).*Ty(i),0, ...
      h1.^(-1).*pt(i)+(-4/3).*h1.^(-2).*RE.^(-1).*miut(i).*Ux(i)+(-4/3).*h1.^(-2).*h11.*RE.^(-1).*miut(i).*V(i)+(2/3).*h1.^(-1).*RE.^(-1).*miut(i).*Vy(i); ...
      h1.^(-2).*h11.*RE.^(-1).*miur(i).*U(i)+(-1).*h1.^(-1).*RE.^(-1).*miur(i).*Uy(i)+h1.^(-1).*U(i).*V(i)+(-1).*h1.^(-2).*RE.^(-1).*miur(i).*Vx(i),(7/3).* ...
      h1.^(-2).*h11.*RE.^(-1).*miu(i)+(2/3).*h1.^(-1).*RE.^(-1).*Deny(i).*miur(i)+(2/3).*h1.^(-1).*RE.^(-1).*miut(i).*Ty(i)+h1.^(-1).*Den(i).*V(i),(-1).* ...
      h1.^(-2).*RE.^(-1).*Denx(i).*miur(i)+(-1).*h1.^(-2).*RE.^(-1).*miut(i).*Tx(i)+h1.^(-1).*Den(i).*U(i),0,h1.^(-2).*h11.*RE.^(-1).*miut(i).*U(i)+(-1).* ...
      h1.^(-1).*RE.^(-1).*miut(i).*Uy(i)+(-1).*h1.^(-2).*RE.^(-1).*miut(i).*Vx(i);0,0,0,(-1).*h1.^(-2).*RE.^(-1).*Denx(i).*miur(i)+(-1).*h1.^(-2).*RE.^(-1) ...
      .*miut(i).*Tx(i)+h1.^(-1).*Den(i).*U(i),0;(-1).*EC.^(-1).*h1.^(-2).*PR.^(-1).*RE.^(-1).*kar(i).*Tx(i)+h1.^(-1).*e(i).*U(i)+h1.^(-1).*Den(i).*er(i).*U( ...
      i),h1.^(-1).*Den(i).*e(i)+h1.^(-1).*p(i)+(-8/3).*h1.^(-2).*RE.^(-1).*miu(i).*Ux(i)+(-8/3).*h1.^(-2).*h11.*RE.^(-1).*miu(i).*V(i)+(4/3).*h1.^(-1).* ...
      RE.^(-1).*miu(i).*Vy(i),2.*h1.^(-2).*h11.*RE.^(-1).*miu(i).*U(i)+(-2).*h1.^(-1).*RE.^(-1).*miu(i).*Uy(i)+(-2).*h1.^(-2).*RE.^(-1).*miu(i).*Vx(i),0,( ...
      -1).*EC.^(-1).*h1.^(-2).*PR.^(-1).*RE.^(-1).*Denx(i).*kar(i)+(-2).*EC.^(-1).*h1.^(-2).*PR.^(-1).*RE.^(-1).*kat(i).*Tx(i)+h1.^(-1).*Den(i).*et(i).*U(i) ...
      ];
    
    %Pressure-corrected matrix A
    aA2=[h1.^(-1).*U(i),h1.^(-1).*Den(i),0,0,0;h1.^(-1).*pr(i)+h1.^(-1).*U(i).^2+(-4/3).*h1.^(-2).*RE.^(-1).*miur(i).*Ux(i)+(-4/3).*h1.^(-2).*h11.*RE.^(-1).* ...
      miur(i).*V(i)+(2/3).*h1.^(-1).*RE.^(-1).*miur(i).*Vy(i),(-4/3).*h1.^(-2).*RE.^(-1).*Denx(i).*miur(i)+(-4/3).*h1.^(-2).*RE.^(-1).*miut(i).*Tx(i)+2.* ...
      h1.^(-1).*Den(i).*U(i),(-7/3).*h1.^(-2).*h11.*RE.^(-1).*miu(i)+(-1).*h1.^(-1).*RE.^(-1).*Deny(i).*miur(i)+(-1).*h1.^(-1).*RE.^(-1).*miut(i).*Ty(i),0, ...
      h1.^(-1).*pt(i)+(-4/3).*h1.^(-2).*RE.^(-1).*miut(i).*Ux(i)+(-4/3).*h1.^(-2).*h11.*RE.^(-1).*miut(i).*V(i)+(2/3).*h1.^(-1).*RE.^(-1).*miut(i).*Vy(i); ...
      h1.^(-2).*h11.*RE.^(-1).*miur(i).*U(i)+(-1).*h1.^(-1).*RE.^(-1).*miur(i).*Uy(i)+h1.^(-1).*U(i).*V(i)+(-1).*h1.^(-2).*RE.^(-1).*miur(i).*Vx(i),(7/3).* ...
      h1.^(-2).*h11.*RE.^(-1).*miu(i)+(2/3).*h1.^(-1).*RE.^(-1).*Deny(i).*miur(i)+(2/3).*h1.^(-1).*RE.^(-1).*miut(i).*Ty(i)+h1.^(-1).*Den(i).*V(i),(-1).* ...
      h1.^(-2).*RE.^(-1).*Denx(i).*miur(i)+(-1).*h1.^(-2).*RE.^(-1).*miut(i).*Tx(i)+h1.^(-1).*Den(i).*U(i),0,h1.^(-2).*h11.*RE.^(-1).*miut(i).*U(i)+(-1).* ...
      h1.^(-1).*RE.^(-1).*miut(i).*Uy(i)+(-1).*h1.^(-2).*RE.^(-1).*miut(i).*Vx(i);0,0,0,(-1).*h1.^(-2).*RE.^(-1).*Denx(i).*miur(i)+(-1).*h1.^(-2).*RE.^(-1) ...
      .*miut(i).*Tx(i)+h1.^(-1).*Den(i).*U(i),0;(-1).*EC.^(-1).*h1.^(-2).*PR.^(-1).*RE.^(-1).*kar(i).*Tx(i)+h1.^(-1).*e(i).*U(i)+h1.^(-1).*Den(i).*er(i).*U( ...
      i),h1.^(-1).*Den(i).*e(i)+h1.^(-1).*p(i)+(-8/3).*h1.^(-2).*RE.^(-1).*miu(i).*Ux(i)+(-8/3).*h1.^(-2).*h11.*RE.^(-1).*miu(i).*V(i)+(4/3).*h1.^(-1).* ...
      RE.^(-1).*miu(i).*Vy(i),2.*h1.^(-2).*h11.*RE.^(-1).*miu(i).*U(i)+(-2).*h1.^(-1).*RE.^(-1).*miu(i).*Uy(i)+(-2).*h1.^(-2).*RE.^(-1).*miu(i).*Vx(i),0,( ...
      -1).*EC.^(-1).*h1.^(-2).*PR.^(-1).*RE.^(-1).*Denx(i).*kar(i)+(-2).*EC.^(-1).*h1.^(-2).*PR.^(-1).*RE.^(-1).*kat(i).*Tx(i)+h1.^(-1).*Den(i).*et(i).*U(i) ...
      ];
    % aA2(2,1)=aA2(2,1)-h1.^(-1).*pr(i);
    % aA2(2,5)=aA2(2,5)-h1.^(-1).*pt(i);

    Mx=sqrt(U(i)^2+V(i)^2)/sqrt(r*Rg*T(i));
    if Mx<1
        omega=r*Mx^2/(1+(r-1)*Mx^2);
    else
        omega=1;
    end
    % omega=0;
    aA2(2,1)=aA2(2,1)-h1.^(-1).*pr(i)*(1-omega);
    aA2(2,5)=aA2(2,5)-h1.^(-1).*pt(i)*(1-omega);
    aA2(5,1)=aA2(5,1)+U(i)/h1*pr(i)*(1-omega);
    aA2(5,5)=aA2(5,5)+U(i)/h1*pt(i)*(1-omega);
    
    aB=[V(i),0,Den(i),0,0;h1.^(-1).*h11.*RE.^(-1).*miur(i).*U(i)+(-1).*RE.^(-1).*miur(i).*Uy(i)+U(i).*V(i)+(-1).*h1.^(-1).*RE.^(-1).*miur(i).*Vx(i),(-1).* ...
      h1.^(-1).*h11.*RE.^(-1).*miu(i)+(-1).*RE.^(-1).*Deny(i).*miur(i)+(-1).*RE.^(-1).*miut(i).*Ty(i)+Den(i).*V(i),(2/3).*h1.^(-1).*RE.^(-1).*Denx(i).*miur( ...
      i)+(2/3).*h1.^(-1).*RE.^(-1).*miut(i).*Tx(i)+Den(i).*U(i),0,h1.^(-1).*h11.*RE.^(-1).*miut(i).*U(i)+(-1).*RE.^(-1).*miut(i).*Uy(i)+(-1).*h1.^(-1).* ...
      RE.^(-1).*miut(i).*Vx(i);pr(i)+(2/3).*h1.^(-1).*RE.^(-1).*miur(i).*Ux(i)+(2/3).*h1.^(-1).*h11.*RE.^(-1).*miur(i).*V(i)+V(i).^2+(-4/3).*RE.^(-1).*miur( ...
      i).*Vy(i),(-1).*h1.^(-1).*RE.^(-1).*Denx(i).*miur(i)+(-1).*h1.^(-1).*RE.^(-1).*miut(i).*Tx(i),(-4/3).*h1.^(-1).*h11.*RE.^(-1).*miu(i)+(-4/3).*RE.^(-1) ...
      .*Deny(i).*miur(i)+(-4/3).*RE.^(-1).*miut(i).*Ty(i)+2.*Den(i).*V(i),0,pt(i)+(2/3).*h1.^(-1).*RE.^(-1).*miut(i).*Ux(i)+(2/3).*h1.^(-1).*h11.*RE.^(-1).* ...
      miut(i).*V(i)+(-4/3).*RE.^(-1).*miut(i).*Vy(i);0,0,0,(-1).*h1.^(-1).*h11.*RE.^(-1).*miu(i)+(-1).*RE.^(-1).*Deny(i).*miur(i)+(-1).*RE.^(-1).*miut(i).* ...
      Ty(i)+Den(i).*V(i),0;(-1).*EC.^(-1).*PR.^(-1).*RE.^(-1).*kar(i).*Ty(i)+e(i).*V(i)+Den(i).*er(i).*V(i),2.*h1.^(-1).*h11.*RE.^(-1).*miu(i).*U(i)+(-2).* ...
      RE.^(-1).*miu(i).*Uy(i)+(-2).*h1.^(-1).*RE.^(-1).*miu(i).*Vx(i),Den(i).*e(i)+p(i)+(4/3).*h1.^(-1).*RE.^(-1).*miu(i).*Ux(i)+(4/3).*h1.^(-1).*h11.*RE.^( ...
      -1).*miu(i).*V(i)+(-8/3).*RE.^(-1).*miu(i).*Vy(i),0,(-1).*EC.^(-1).*h1.^(-1).*h11.*PR.^(-1).*RE.^(-1).*ka(i)+(-1).*EC.^(-1).*PR.^(-1).*RE.^(-1).*Deny( ...
      i).*kar(i)+(-2).*EC.^(-1).*PR.^(-1).*RE.^(-1).*kat(i).*Ty(i)+Den(i).*et(i).*V(i)];
    
    aC=[0,0,0,Den(i),0;0,0,0,(2/3).*h1.^(-1).*RE.^(-1).*Denx(i).*miur(i)+(2/3).*h1.^(-1).*RE.^(-1).*miut(i).*Tx(i)+Den(i).*U(i),0;0,0,0,(2/3).*RE.^(-1).* ...
      Deny(i).*miur(i)+(2/3).*RE.^(-1).*miut(i).*Ty(i)+Den(i).*V(i),0;pr(i)+(2/3).*h1.^(-1).*RE.^(-1).*miur(i).*Ux(i)+(2/3).*h1.^(-1).*h11.*RE.^(-1).*miur( ...
      i).*V(i)+(2/3).*RE.^(-1).*miur(i).*Vy(i),(-1).*h1.^(-1).*RE.^(-1).*Denx(i).*miur(i)+(-1).*h1.^(-1).*RE.^(-1).*miut(i).*Tx(i),(-1/3).*h1.^(-1).*h11.* ...
      RE.^(-1).*miu(i)+(-1).*RE.^(-1).*Deny(i).*miur(i)+(-1).*RE.^(-1).*miut(i).*Ty(i),0,pt(i)+(2/3).*h1.^(-1).*RE.^(-1).*miut(i).*Ux(i)+(2/3).*h1.^(-1).* ...
      h11.*RE.^(-1).*miut(i).*V(i)+(2/3).*RE.^(-1).*miut(i).*Vy(i);0,0,0,Den(i).*e(i)+p(i)+(4/3).*h1.^(-1).*RE.^(-1).*miu(i).*Ux(i)+(4/3).*h1.^(-1).*h11.* ...
      RE.^(-1).*miu(i).*V(i)+(4/3).*RE.^(-1).*miu(i).*Vy(i),0];%
    
    aD=[h1.^(-1).*Ux(i)+h1.^(-1).*h11.*V(i)+Vy(i),  h1.^(-1).*Denx(i),   h1.^(-1).*h11.*Den(i)+Deny(i),0,0;...
        h1.^(-1).*Denx(i).*prr(i)+h1.^(-1).*prt(i).*Tx(i)+h1.^( ...
      -2).*h11.^2.*RE.^(-1).*miur(i).*U(i)+h1.^(-1).*h11.*RE.^(-1).*Deny(i).*miurr(i).*U(i)+h1.^(-1).*h11.*RE.^(-1).*miurt(i).*Ty(i).*U(i)+(-4/3).*h1.^(-2) ...
      .*RE.^(-1).*Denx(i).*miurr(i).*Ux(i)+(-4/3).*h1.^(-2).*RE.^(-1).*miurt(i).*Tx(i).*Ux(i)+2.*h1.^(-1).*U(i).*Ux(i)+(-4/3).*h1.^(-2).*RE.^(-1).*miur(i).* ...
      Uxx(i)+(-1).*h1.^(-1).*h11.*RE.^(-1).*miur(i).*Uy(i)+(-1).*RE.^(-1).*Deny(i).*miurr(i).*Uy(i)+(-1).*RE.^(-1).*miurt(i).*Ty(i).*Uy(i)+(-1).*RE.^(-1).* ...
      miur(i).*Uyy(i)+(-4/3).*h1.^(-2).*h11.*RE.^(-1).*Denx(i).*miurr(i).*V(i)+(-4/3).*h1.^(-2).*h11.*RE.^(-1).*miurt(i).*Tx(i).*V(i)+2.*h1.^(-1).*h11.*U(i) ...
      .*V(i)+Uy(i).*V(i)+(-7/3).*h1.^(-2).*h11.*RE.^(-1).*miur(i).*Vx(i)+(-1).*h1.^(-1).*RE.^(-1).*Deny(i).*miurr(i).*Vx(i)+(-1).*h1.^(-1).*RE.^(-1).*miurt( ...
      i).*Ty(i).*Vx(i)+(-1/3).*h1.^(-1).*RE.^(-1).*miur(i).*Vxy(i)+(2/3).*h1.^(-1).*RE.^(-1).*Denx(i).*miurr(i).*Vy(i)+(2/3).*h1.^(-1).*RE.^(-1).*miurt(i).* ...
      Tx(i).*Vy(i)+U(i).*Vy(i),h1.^(-2).*h11.^2.*RE.^(-1).*miu(i)+h1.^(-1).*h11.*RE.^(-1).*Deny(i).*miur(i)+h1.^(-1).*h11.*RE.^(-1).*miut(i).*Ty(i)+2.*h1.^( ...
      -1).*Denx(i).*U(i)+2.*h1.^(-1).*Den(i).*Ux(i)+2.*h1.^(-1).*h11.*Den(i).*V(i)+Deny(i).*V(i)+Den(i).*Vy(i),(-4/3).*h1.^(-2).*h11.*RE.^(-1).*Denx(i).* ...
      miur(i)+(-4/3).*h1.^(-2).*h11.*RE.^(-1).*miut(i).*Tx(i)+2.*h1.^(-1).*h11.*Den(i).*U(i)+Deny(i).*U(i)+Den(i).*Uy(i),0,h1.^(-1).*Denx(i).*prt(i)+h1.^( ...
      -1).*ptt(i).*Tx(i)+h1.^(-1).*h11.*RE.^(-1).*Deny(i).*miurt(i).*U(i)+h1.^(-2).*h11.^2.*RE.^(-1).*miut(i).*U(i)+h1.^(-1).*h11.*RE.^(-1).*miutt(i).*Ty(i) ...
      .*U(i)+(-4/3).*h1.^(-2).*RE.^(-1).*Denx(i).*miurt(i).*Ux(i)+(-4/3).*h1.^(-2).*RE.^(-1).*miutt(i).*Tx(i).*Ux(i)+(-4/3).*h1.^(-2).*RE.^(-1).*miut(i).* ...
      Uxx(i)+(-1).*RE.^(-1).*Deny(i).*miurt(i).*Uy(i)+(-1).*h1.^(-1).*h11.*RE.^(-1).*miut(i).*Uy(i)+(-1).*RE.^(-1).*miutt(i).*Ty(i).*Uy(i)+(-1).*RE.^(-1).* ...
      miut(i).*Uyy(i)+(-4/3).*h1.^(-2).*h11.*RE.^(-1).*Denx(i).*miurt(i).*V(i)+(-4/3).*h1.^(-2).*h11.*RE.^(-1).*miutt(i).*Tx(i).*V(i)+(-1).*h1.^(-1).*RE.^( ...
      -1).*Deny(i).*miurt(i).*Vx(i)+(-7/3).*h1.^(-2).*h11.*RE.^(-1).*miut(i).*Vx(i)+(-1).*h1.^(-1).*RE.^(-1).*miutt(i).*Ty(i).*Vx(i)+(-1/3).*h1.^(-1).*RE.^( ...
      -1).*miut(i).*Vxy(i)+(2/3).*h1.^(-1).*RE.^(-1).*Denx(i).*miurt(i).*Vy(i)+(2/3).*h1.^(-1).*RE.^(-1).*miutt(i).*Tx(i).*Vy(i);...
      Deny(i).*prr(i)+prt(i).*Ty( ...
      i)+h1.^(-2).*h11.*RE.^(-1).*Denx(i).*miurr(i).*U(i)+h1.^(-2).*h11.*RE.^(-1).*miurt(i).*Tx(i).*U(i)+(-1).*h1.^(-1).*h11.*U(i).^2+(7/3).*h1.^(-2).*h11.* ...
      RE.^(-1).*miur(i).*Ux(i)+(2/3).*h1.^(-1).*RE.^(-1).*Deny(i).*miurr(i).*Ux(i)+(2/3).*h1.^(-1).*RE.^(-1).*miurt(i).*Ty(i).*Ux(i)+(-1/3).*h1.^(-1).*RE.^( ...
      -1).*miur(i).*Uxy(i)+(-1).*h1.^(-1).*RE.^(-1).*Denx(i).*miurr(i).*Uy(i)+(-1).*h1.^(-1).*RE.^(-1).*miurt(i).*Tx(i).*Uy(i)+(4/3).*h1.^(-2).*h11.^2.* ...
      RE.^(-1).*miur(i).*V(i)+(2/3).*h1.^(-1).*h11.*RE.^(-1).*Deny(i).*miurr(i).*V(i)+(2/3).*h1.^(-1).*h11.*RE.^(-1).*miurt(i).*Ty(i).*V(i)+h1.^(-1).*Ux(i) ...
      .*V(i)+h1.^(-1).*h11.*V(i).^2+(-1).*h1.^(-2).*RE.^(-1).*Denx(i).*miurr(i).*Vx(i)+(-1).*h1.^(-2).*RE.^(-1).*miurt(i).*Tx(i).*Vx(i)+h1.^(-1).*U(i).*Vx( ...
      i)+(-1).*h1.^(-2).*RE.^(-1).*miur(i).*Vxx(i)+(-4/3).*h1.^(-1).*h11.*RE.^(-1).*miur(i).*Vy(i)+(-4/3).*RE.^(-1).*Deny(i).*miurr(i).*Vy(i)+(-4/3).*RE.^( ...
      -1).*miurt(i).*Ty(i).*Vy(i)+2.*V(i).*Vy(i)+(-4/3).*RE.^(-1).*miur(i).*Vyy(i),h1.^(-2).*h11.*RE.^(-1).*Denx(i).*miur(i)+h1.^(-2).*h11.*RE.^(-1).*miut( ...
      i).*Tx(i)+(-2).*h1.^(-1).*h11.*Den(i).*U(i)+h1.^(-1).*Denx(i).*V(i)+h1.^(-1).*Den(i).*Vx(i),(4/3).*h1.^(-2).*h11.^2.*RE.^(-1).*miu(i)+(2/3).*h1.^(-1) ...
      .*h11.*RE.^(-1).*Deny(i).*miur(i)+(2/3).*h1.^(-1).*h11.*RE.^(-1).*miut(i).*Ty(i)+h1.^(-1).*Denx(i).*U(i)+h1.^(-1).*Den(i).*Ux(i)+2.*h1.^(-1).*h11.* ...
      Den(i).*V(i)+2.*Deny(i).*V(i)+2.*Den(i).*Vy(i),0,...
      Deny(i).*prt(i)+ptt(i).*Ty(i)+h1.^(-2).*h11.*RE.^(-1).*Denx(i).*miurt(i).*U(i)+h1.^(-2).*h11.*RE.^( ...
      -1).*miutt(i).*Tx(i).*U(i)+(2/3).*h1.^(-1).*RE.^(-1).*Deny(i).*miurt(i).*Ux(i)+(7/3).*h1.^(-2).*h11.*RE.^(-1).*miut(i).*Ux(i)+(2/3).*h1.^(-1).*RE.^( ...
      -1).*miutt(i).*Ty(i).*Ux(i)+(-1/3).*h1.^(-1).*RE.^(-1).*miut(i).*Uxy(i)+(-1).*h1.^(-1).*RE.^(-1).*Denx(i).*miurt(i).*Uy(i)+(-1).*h1.^(-1).*RE.^(-1).* ...
      miutt(i).*Tx(i).*Uy(i)+(2/3).*h1.^(-1).*h11.*RE.^(-1).*Deny(i).*miurt(i).*V(i)+(4/3).*h1.^(-2).*h11.^2.*RE.^(-1).*miut(i).*V(i)+(2/3).*h1.^(-1).*h11.* ...
      RE.^(-1).*miutt(i).*Ty(i).*V(i)+(-1).*h1.^(-2).*RE.^(-1).*Denx(i).*miurt(i).*Vx(i)+(-1).*h1.^(-2).*RE.^(-1).*miutt(i).*Tx(i).*Vx(i)+(-1).*h1.^(-2).* ...
      RE.^(-1).*miut(i).*Vxx(i)+(-4/3).*RE.^(-1).*Deny(i).*miurt(i).*Vy(i)+(-4/3).*h1.^(-1).*h11.*RE.^(-1).*miut(i).*Vy(i)+(-4/3).*RE.^(-1).*miutt(i).*Ty(i) ...
      .*Vy(i)+(-4/3).*RE.^(-1).*miut(i).*Vyy(i);...
      0,0,0,h1.^(-1).*Denx(i).*U(i)+h1.^(-1).*Den(i).*Ux(i)+h1.^(-1).*h11.*Den(i).*V(i)+Deny(i).*V(i)+Den(i).*Vy( ...
      i),0;(-1).*EC.^(-1).*h1.^(-2).*PR.^(-1).*RE.^(-1).*Denx(i).*karr(i).*Tx(i)+(-1).*EC.^(-1).*h1.^(-2).*PR.^(-1).*RE.^(-1).*kart(i).*Tx(i).^2+(-1).*EC.^( ...
      -1).*h1.^(-2).*PR.^(-1).*RE.^(-1).*kar(i).*Txx(i)+(-1).*EC.^(-1).*h1.^(-1).*h11.*PR.^(-1).*RE.^(-1).*kar(i).*Ty(i)+(-1).*EC.^(-1).*PR.^(-1).*RE.^(-1) ...
      .*Deny(i).*karr(i).*Ty(i)+(-1).*EC.^(-1).*PR.^(-1).*RE.^(-1).*kart(i).*Ty(i).^2+(-1).*EC.^(-1).*PR.^(-1).*RE.^(-1).*kar(i).*Tyy(i)+2.*h1.^(-1).*Denx( ...
      i).*er(i).*U(i)+h1.^(-1).*Den(i).*Denx(i).*err(i).*U(i)+h1.^(-1).*Den(i).*ert(i).*Tx(i).*U(i)+h1.^(-1).*et(i).*Tx(i).*U(i)+(-1).*h1.^(-2).*h11.^2.* ...
      RE.^(-1).*miur(i).*U(i).^2+h1.^(-1).*e(i).*Ux(i)+h1.^(-1).*Den(i).*er(i).*Ux(i)+h1.^(-1).*pr(i).*Ux(i)+(-4/3).*h1.^(-2).*RE.^(-1).*miur(i).*Ux(i).^2+ ...
      2.*h1.^(-1).*h11.*RE.^(-1).*miur(i).*U(i).*Uy(i)+(-1).*RE.^(-1).*miur(i).*Uy(i).^2+h1.^(-1).*h11.*e(i).*V(i)+h1.^(-1).*h11.*Den(i).*er(i).*V(i)+2.* ...
      Deny(i).*er(i).*V(i)+Den(i).*Deny(i).*err(i).*V(i)+h1.^(-1).*h11.*pr(i).*V(i)+Den(i).*ert(i).*Ty(i).*V(i)+et(i).*Ty(i).*V(i)+(-8/3).*h1.^(-2).*h11.* ...
      RE.^(-1).*miur(i).*Ux(i).*V(i)+(-4/3).*h1.^(-2).*h11.^2.*RE.^(-1).*miur(i).*V(i).^2+2.*h1.^(-2).*h11.*RE.^(-1).*miur(i).*U(i).*Vx(i)+(-2).*h1.^(-1).* ...
      RE.^(-1).*miur(i).*Uy(i).*Vx(i)+(-1).*h1.^(-2).*RE.^(-1).*miur(i).*Vx(i).^2+e(i).*Vy(i)+Den(i).*er(i).*Vy(i)+pr(i).*Vy(i)+(4/3).*h1.^(-1).*RE.^(-1).* ...
      miur(i).*Ux(i).*Vy(i)+(4/3).*h1.^(-1).*h11.*RE.^(-1).*miur(i).*V(i).*Vy(i)+(-4/3).*RE.^(-1).*miur(i).*Vy(i).^2,h1.^(-1).*Denx(i).*e(i)+h1.^(-1).*Den( ...
      i).*Denx(i).*er(i)+h1.^(-1).*Den(i).*et(i).*Tx(i)+(-2).*h1.^(-2).*h11.^2.*RE.^(-1).*miu(i).*U(i)+2.*h1.^(-1).*h11.*RE.^(-1).*miu(i).*Uy(i)+2.*h1.^(-2) ...
      .*h11.*RE.^(-1).*miu(i).*Vx(i),h1.^(-1).*h11.*Den(i).*e(i)+Deny(i).*e(i)+Den(i).*Deny(i).*er(i)+h1.^(-1).*h11.*p(i)+Den(i).*et(i).*Ty(i)+(-8/3).*h1.^( ...
      -2).*h11.*RE.^(-1).*miu(i).*Ux(i)+(-8/3).*h1.^(-2).*h11.^2.*RE.^(-1).*miu(i).*V(i)+(4/3).*h1.^(-1).*h11.*RE.^(-1).*miu(i).*Vy(i),0,(-1).*EC.^(-1).* ...
      h1.^(-2).*PR.^(-1).*RE.^(-1).*Denx(i).*kart(i).*Tx(i)+(-1).*EC.^(-1).*h1.^(-2).*PR.^(-1).*RE.^(-1).*katt(i).*Tx(i).^2+(-1).*EC.^(-1).*h1.^(-2).*PR.^( ...
      -1).*RE.^(-1).*kat(i).*Txx(i)+(-1).*EC.^(-1).*PR.^(-1).*RE.^(-1).*Deny(i).*kart(i).*Ty(i)+(-1).*EC.^(-1).*h1.^(-1).*h11.*PR.^(-1).*RE.^(-1).*kat(i).* ...
      Ty(i)+(-1).*EC.^(-1).*PR.^(-1).*RE.^(-1).*katt(i).*Ty(i).^2+(-1).*EC.^(-1).*PR.^(-1).*RE.^(-1).*kat(i).*Tyy(i)+h1.^(-1).*Den(i).*Denx(i).*ert(i).*U(i)+ ...
      h1.^(-1).*Denx(i).*et(i).*U(i)+h1.^(-1).*Den(i).*ett(i).*Tx(i).*U(i)+(-1).*h1.^(-2).*h11.^2.*RE.^(-1).*miut(i).*U(i).^2+h1.^(-1).*Den(i).*et(i).*Ux( ...
      i)+h1.^(-1).*pt(i).*Ux(i)+(-4/3).*h1.^(-2).*RE.^(-1).*miut(i).*Ux(i).^2+2.*h1.^(-1).*h11.*RE.^(-1).*miut(i).*U(i).*Uy(i)+(-1).*RE.^(-1).*miut(i).*Uy( ...
      i).^2+Den(i).*Deny(i).*ert(i).*V(i)+h1.^(-1).*h11.*Den(i).*et(i).*V(i)+Deny(i).*et(i).*V(i)+h1.^(-1).*h11.*pt(i).*V(i)+Den(i).*ett(i).*Ty(i).*V(i)+( ...
      -8/3).*h1.^(-2).*h11.*RE.^(-1).*miut(i).*Ux(i).*V(i)+(-4/3).*h1.^(-2).*h11.^2.*RE.^(-1).*miut(i).*V(i).^2+2.*h1.^(-2).*h11.*RE.^(-1).*miut(i).*U(i).* ...
      Vx(i)+(-2).*h1.^(-1).*RE.^(-1).*miut(i).*Uy(i).*Vx(i)+(-1).*h1.^(-2).*RE.^(-1).*miut(i).*Vx(i).^2+Den(i).*et(i).*Vy(i)+pt(i).*Vy(i)+(4/3).*h1.^(-1).* ...
      RE.^(-1).*miut(i).*Ux(i).*Vy(i)+(4/3).*h1.^(-1).*h11.*RE.^(-1).*miut(i).*V(i).*Vy(i)+(-4/3).*RE.^(-1).*miut(i).*Vy(i).^2];
    
    aHxx=-[0,0,0,0,0;0,(-4/3).*h1.^(-2).*RE.^(-1).*miu(i),0,0,0;0,0,(-1).*h1.^(-2).*RE.^(-1).*miu(i),0,0;0,0,0,(-1).*h1.^(-2).*RE.^(-1).*miu(i),0;0,0,0,0,(-1).* ...
      EC.^(-1).*h1.^(-2).*PR.^(-1).*RE.^(-1).*ka(i)];
    
    aHyy=-[0,0,0,0,0;0,(-1).*RE.^(-1).*miu(i),0,0,0;0,0,(-4/3).*RE.^(-1).*miu(i),0,0;0,0,0,(-1).*RE.^(-1).*miu(i),0;0,0,0,0,(-1).*EC.^(-1).*PR.^(-1).*RE.^(-1).* ...
      ka(i)];
    
    aHzz=-[0,0,0,0,0;0,(-1).*RE.^(-1).*miu(i),0,0,0;0,0,(-1).*RE.^(-1).*miu(i),0,0;0,0,0,(-4/3).*RE.^(-1).*miu(i),0;0,0,0,0,(-1).*EC.^(-1).*PR.^(-1).*RE.^(-1).* ...
      ka(i)];%
    
    aHxy=-[0,0,0,0,0;0,0,(-1/3).*h1.^(-1).*RE.^(-1).*miu(i),0,0;0,(-1/3).*h1.^(-1).*RE.^(-1).*miu(i),0,0,0;0,0,0,0,0;0,0,0,0,0];
    
    aHxz=-[0,0,0,0,0;0,0,0,(-1/3).*h1.^(-1).*RE.^(-1).*miu(i),0;0,0,0,0,0;0,(-1/3).*h1.^(-1).*RE.^(-1).*miu(i),0,0,0;0,0,0,0,0];%
    
    aHyz=-[0,0,0,0,0;0,0,0,0,0;0,0,0,(-1/3).*RE.^(-1).*miu(i),0;0,0,(-1/3).*RE.^(-1).*miu(i),0,0;0,0,0,0,0];%
    
        
    gamma(i*5-4:i*5,i*5-4:i*5)=agamma;
    A(i*5-4:i*5,i*5-4:i*5)=aA;
    A2(i*5-4:i*5,i*5-4:i*5)=aA2;
    B(i*5-4:i*5,i*5-4:i*5)=aB;
    C(i*5-4:i*5,i*5-4:i*5)=aC;
    D(i*5-4:i*5,i*5-4:i*5)=aD;
    Hxx(i*5-4:i*5,i*5-4:i*5)=aHxx;
    Hyy(i*5-4:i*5,i*5-4:i*5)=aHyy;
    Hzz(i*5-4:i*5,i*5-4:i*5)=aHzz;
    Hxy(i*5-4:i*5,i*5-4:i*5)=aHxy;
    Hxz(i*5-4:i*5,i*5-4:i*5)=aHxz;
    Hyz(i*5-4:i*5,i*5-4:i*5)=aHyz;

     gamma = sparse(gamma);
     A = sparse(A);
     A2 = sparse(A2);
     B = sparse(B);
     C = sparse(C);
     D = sparse(D);
     Hxx = sparse(Hxx);
     Hyy = sparse(Hyy);
     Hzz = sparse(Hzz);
     Hxy = sparse(Hxy);
     Hxz = sparse(Hxz);
     Hyz = sparse(Hyz);

end
end

