function [Fmn] = NPSE_Fmn(xi,Case,Mesh,Baseflow,alf,Fai,modes)

% Obtain Fmn (Nonlinear term in Fourier space)

Nz  = Case.Nz;
Nt  = Case.Nt;
Ny  = Mesh.N;

m_max = Case.mmax;
n_max = Case.nmax;
omega = Case.omega;
beta  = Case.beta;
MN    = Case.MN;

nonlin=zeros(Ny*Nz*Nt,5);

F1   = zeros(5*Ny,MN);
Ft1  = zeros(5*Ny,MN);
Fx1  = zeros(5*Ny,MN);
Fy1  = zeros(5*Ny,MN);
Fz1  = zeros(5*Ny,MN);
Fxx1 = zeros(5*Ny,MN);
Fyy1 = zeros(5*Ny,MN);
Fzz1 = zeros(5*Ny,MN);
Fxy1 = zeros(5*Ny,MN);
Fxz1 = zeros(5*Ny,MN);
Fyz1 = zeros(5*Ny,MN);

JF   = zeros(MN,1);

% Perturbation and derivatives without exp(i*JF+i*n*beta*z-i*m*omega*t)
for m=0:m_max
for n=-n_max:n_max
    mn = mn2mn(Case,m,n);
    if modes(mn) 
        [F1(:,mn), Ft1(:,mn), Fx1(:,mn), Fy1(:,mn), Fz1(:,mn), Fxx1(:,mn),...
        Fyy1(:,mn), Fzz1(:,mn), Fxy1(:,mn), Fxz1(:,mn), Fyz1(:,mn)] = ...
        NPSE_Dvector(xi,m,n,Mesh,Case,alf,Fai);

        JF(mn)=trapz(Mesh.x(1:xi),alf(1:xi,mn));
    end
end
end


if omega==0
    Tt=0;
else 
    Tt=2*pi/omega;
end

if beta==0
    Tz=0;
else
    Tz=2*pi/beta;
end

dz=Tz/Nz;
dt=Tt/Nt;


% Perturbation and derivatives in physical space
for zi=0:Nz-1
for ti=0:Nt-1

    sz=dz*zi;
    st=dt*ti;
    
    F=zeros(5*Ny,1);
    Ft=zeros(5*Ny,1);
    Fx=zeros(5*Ny,1);
    Fy=zeros(5*Ny,1);
    Fz=zeros(5*Ny,1);
    Fxx=zeros(5*Ny,1);
    Fyy=zeros(5*Ny,1);
    Fzz=zeros(5*Ny,1);
    Fxy=zeros(5*Ny,1);
    Fxz=zeros(5*Ny,1);
    Fyz=zeros(5*Ny,1);
    for m=0:m_max
    for n=-n_max:n_max
        mn = mn2mn(Case,m,n);
        if modes(mn) % Physical perturbations: F0, Ft0, ...
            [F0,Ft0,Fx0,Fy0,Fz0,Fxx0,Fyy0,Fzz0,Fxy0,Fxz0,Fyz0] = ...
             NPSE_disturb(m,n,sz,st,omega,beta,...
             F1(:,mn),Ft1(:,mn),Fx1(:,mn),Fy1(:,mn),Fz1(:,mn),...
             Fxx1(:,mn),Fyy1(:,mn),Fzz1(:,mn),Fxy1(:,mn),...
             Fxz1(:,mn),Fyz1(:,mn),JF(mn));
            
            F   = F+F0;                 
            Ft  = Ft+Ft0;
            Fx  = Fx+Fx0;
            Fy  = Fy+Fy0;
            Fz  = Fz+Fz0;
            Fxx = Fxx+Fxx0;
            Fyy = Fyy+Fyy0;
            Fzz = Fzz+Fzz0;
            Fxy = Fxy+Fxy0;
            Fxz = Fxz+Fxz0;
            Fyz = Fyz+Fyz0;
        end
    end
    end
    
    % Obtain nonlinear terms: nonlin(Ny,5);
    [nonlin(zi*Nt+ti+1:Nt*Nz:Ny*Nt*Nz,:)]=...
        NPSE_physical(Case,Baseflow,...
        F,Ft,Fx,Fy,Fz,Fxx,Fyy,Fzz,Fxy,Fxz,Fyz,Ny,xi);
end  
end

% FFT: From Physical space -> Fourier-transformed Fmn
FFT=zeros(5*Ny,Nt*Nz);
for i=1:Ny
for j=1:5
    Fft = fft2(reshape(nonlin(Nz*Nt*(i-1)+1:Nz*Nt*i,j),[Nt,Nz]))/Nz/Nt;
    FFT(5*(i-1)+j,:)=reshape(Fft,[Nt*Nz 1]);
end
end



Fmn=zeros(5*Ny,MN);
for n=-n_max:n_max
for m=0:m_max
    if(n>0) % positive mode(n)
        N1=n+1;
    elseif(n==0)     % mode(0)
        N1=1;
    else    % negative mode(n)
        N1=Nz+n+1;
    end
    
    if(m>0) % positive mode(m)
        M1=Nt-(m-1);
    else
        M1=1;        % mode(0)
    end
    Fmn(:,m*(2*n_max+1)+(n+n_max+1)) = FFT(:,(N1-1)*Nt+M1);
end
end

% implement boundary condition for Fmn
Fmn(1:5,:)=0;
Fmn(5*Ny-4:5*Ny,:)=0;


end