function   [F1,Ft1,Fx1,Fy1,Fz1,Fxx1,Fyy1,Fzz1,Fxy1,Fxz1,Fyz1]...
             = NPSE_Dvector(xi,m,n,Mesh,Case,alf,Fai)


omega = Case.omega;
beta  = Case.beta;
dx    = Mesh.dx;

D     = kron(Mesh.Dy,eye(5,5));
DD    = kron(Mesh.DDy,eye(5,5));

mn    = mn2mn(Case,m,n);
alfmn = alf(xi,mn);
zz    = sqrt(-1);

f    = Fai(:,xi,mn);
fx   = (Fai(:,xi,mn)-Fai(:,xi-1,mn))/dx;
fxx  = 0;
fy   = D*Fai(:,xi,mn);
fyy  = DD*Fai(:,xi,mn);
fxy  = (D*Fai(:,xi,mn)-D*Fai(:,xi-1,mn))/dx;

alfx = 0;


F1   = f;
Ft1  = -zz*m*omega*f;
Fx1  = fx+f*zz*alfmn;
Fy1  = fy;
Fz1  = zz*n*beta*f;
Fxx1 = fxx+2*zz*fx*alfmn+f*zz*alfx-f*alfmn^2;
Fyy1 = fyy;
Fzz1 = -n^2*beta^2*f;
Fxy1 = fxy+fy*zz*alfmn;
Fxz1 = fx*zz*n*beta-f*alfmn*n*beta;
Fyz1 = fy*zz*n*beta;

end
