function [Lt,Lx,Ly,Lz,Lq,Vxx,Vxy,Vxz,Vyy,Vyz,Vzz]=LST_Calc_matrix_new(j,Re,Mesh,Baseflow,Case)



switch Case.EOS
    case 'FP'
        PrEc        = Case.Pr*Case.Ec;
        
        U           = Baseflow(:,6);
        Uy          = Mesh.Dy*U;
        Uyy         = Mesh.DDy*U;
        T           = Baseflow(:,4);
        Ty          = Mesh.Dy*T;
        Tyy         = Mesh.DDy*T;
        rho         = Baseflow(:,5);
        rhoy        = Mesh.Dy*rho;
        
        e           = Case.ep(:,1);        
        e_T         = Case.ep(:,2);        
        e_rho       = Case.ep(:,3);        
        e_y         = e_T.*Ty + e_rho.*rhoy;   
        
        p           = Case.ep(:,4);        
        p_T         = Case.ep(:,5);
        p_T_T       = Case.ep(:,6);
        p_rho       = Case.ep(:,7);       % make the difference
        p_rho_rho   = Case.ep(:,8);
        p_T_rho     = Case.ep(:,9);       
                
        
    case 'IG'
        PrEc        = Case.Pr*Case.Ec;
        
        U           = Baseflow(:,1);
        Uy          = Mesh.Dy*U;
        Uyy         = Mesh.DDy*U;
        T           = Baseflow(:,4);
        Ty          = Mesh.Dy*T;
        Tyy         = Mesh.DDy*T;
        rho         = Baseflow(:,7);
        rhoy        = Mesh.Dy*rho;
        
 

        gama  = Case.gama;
        Rg    = Case.Rg;
        
        p           = rho*Rg.*T;
        p_T         = rho*Rg;
        p_T_T       = zeros(length(p),1);
        p_rho       = Rg*T;
        p_rho_rho   = zeros(length(p),1);
        p_T_rho     = ones(length(p),1)*Rg;

        e           = Rg*T/(gama-1);
        e_T         = ones(length(p),1)*Rg/(gama-1);
        e_rho       = zeros(length(p),1);

        e_y         = e_T.*Ty + e_rho.*rhoy; 
end


switch Case.Trans
    case 'Power'
    n1=0.7;
    n2=0.7;

    mu = T.^n1;
    ka = T.^n2;

    mu_T  = n1*T.^(n1-1);
    mu_TT = n1*(n1-1)*T.^(n1-2);
    ka_T  = n2*T.^(n2-1);
    ka_TT = n2*(n2-1)*T.^(n2-2);
    
    
    mu_d  = zeros(length(T),1);
    mu_dd = zeros(length(T),1);
    mu_Td = zeros(length(T),1);
    ka_d  = zeros(length(T),1);
    ka_dd = zeros(length(T),1);
    ka_Td = zeros(length(T),1);
    
    case 'Sutherland'
    S=110.4;
    aa=S/Case.Te;
    mu = (1.0+aa)*T.^1.5./(T+aa);
    mu_T = (1.0+aa)*sqrt(T).*(0.5*T+1.5*aa)./((T+aa).^2.0);
    mu_TT= (0.75*(T.^0.5+aa*T.^(-0.5)).*(T+aa).^2.0-...
        (T.^1.5+3.0*aa*T.^0.5).*(T+aa)).*(1.0+aa)./(T+aa).^4.0;
    
    ka = mu;
    ka_T=mu_T;
    ka_TT=mu_TT;
    
    mu_d  = zeros(length(T),1);
    mu_dd = zeros(length(T),1);
    mu_Td = zeros(length(T),1);
    ka_d  = zeros(length(T),1);
    ka_dd = zeros(length(T),1);
    ka_Td = zeros(length(T),1);
    
    
    
    case 'FP'
    
    mu = Case.muk(:,1);
    ka = Case.muk(:,2);
    
    mu_T  = Case.muk(:,3);
    mu_TT = Case.muk(:,4);
    ka_T  = Case.muk(:,5);
    ka_TT = Case.muk(:,6);
    
    mu_d  = Case.muk(:,7);
    mu_dd = Case.muk(:,8);
    ka_d  = Case.muk(:,9);
    ka_dd = Case.muk(:,10);
    mu_Td = Case.muk(:,11);
    ka_Td = Case.muk(:,13);

    
end

mu_y  = mu_T.*Ty + mu_d.*rhoy; % real
ka_y  = ka_T.*Ty + ka_d.*rhoy; % real

la    = -2/3*mu;
la_y  = -2/3*mu_y;

Lt      = zeros(5,5);
Lt(1,1) = 1;
Lt(2,1) = U(j);
Lt(2,2) = rho(j);
Lt(3,3) = rho(j);
Lt(4,4) = rho(j);
Lt(5,1) = e(j)+rho(j)*e_rho(j);
Lt(5,5) = rho(j)*e_T(j);

Lx      = zeros(5,5);
Lx(1,1) = U(j);
Lx(1,2) = rho(j);
Lx(2,1) = U(j)^2 + p_rho(j);
Lx(2,2) = 2*rho(j)*U(j);
Lx(2,3) = -1/Re*mu_y(j);
Lx(2,5) = p_T(j);
Lx(3,1) = -1/Re*mu_d(j)*Uy(j); % real
Lx(3,2) = -1/Re*la_y(j);
Lx(3,3) = rho(j)*U(j);
Lx(3,5) = -1/Re*mu_T(j)*Uy(j);
Lx(4,4) = rho(j)*U(j);
Lx(5,1) = e(j)*U(j)+rho(j)*U(j)*e_rho(j);
Lx(5,2) = rho(j)*e(j)+p(j);
Lx(5,3) = -2/Re*mu(j)*Uy(j);
Lx(5,5) = rho(j)*U(j)*e_T(j);

Ly      = zeros(5,5);
Ly(1,3) = rho(j);
Ly(2,1) = -1/Re*mu_d(j)*Uy(j); %real
Ly(2,2) = -1/Re*mu_y(j);
Ly(2,3) = rho(j)*U(j);
Ly(2,5) = -1/Re*mu_T(j)*Uy(j);
Ly(3,1) = p_rho(j);
Ly(3,3) = -2/Re*mu_y(j)-1/Re*la_y(j);
Ly(3,5) = p_T(j);
Ly(4,4) = -1/Re*mu_y(j);
Ly(5,1) = -1/Re/PrEc*ka_d(j)*Ty(j); %real
Ly(5,2) = -2/Re*mu(j)*Uy(j);
Ly(5,3) = rho(j)*e(j)+p(j);
Ly(5,5) = -1/Re/PrEc*(ka_y(j)+ka_T(j)*Ty(j)); % real
% Ly(5,5) = -1/Re/PrM2*(2*ka_y(j));

Lz      = zeros(5,5);
Lz(1,4) = rho(j);
Lz(2,4) = rho(j)*U(j);
Lz(3,4) = -1/Re*la_y(j);
Lz(4,1) = p_rho(j);
Lz(4,3) = -1/Re*mu_y(j);
Lz(4,5) = p_T(j);
Lz(5,4) = rho(j)*e(j)+p(j);

Lq      = zeros(5,5);
Lq(1,3) = rhoy(j);
Lq(2,1) = -1/Re*mu_d(j)*Uyy(j)-1/Re*(mu_dd(j)*rhoy(j)+mu_Td(j)*Ty(j))*Uy(j); %real
Lq(2,3) = rho(j)*Uy(j)+U(j)*rhoy(j);
Lq(2,5) = -1/Re*mu_T(j)*Uyy(j)-1/Re*(mu_TT(j)*Ty(j)+mu_Td(j)*rhoy(j))*Uy(j);
Lq(3,1) = p_rho_rho(j)*rhoy(j)+p_T_rho(j)*Ty(j);
Lq(3,5) = p_T_T(j)*Ty(j)+p_T_rho(j)*rhoy(j);
Lq(5,1) = -1/Re/PrEc*(Tyy(j)*ka_d(j)+(ka_dd(j)*rhoy(j)+ka_Td(j)*Ty(j))*Ty(j))...
           -1/Re*mu_d(j)*(Uy(j))^2; %real
Lq(5,3) = e(j)*rhoy(j)+rho(j)*e_y(j);
Lq(5,5) = -1/Re/PrEc*(Tyy(j)*ka_T(j)+(ka_TT(j)*Ty(j)+ka_Td(j)*rhoy(j))*Ty(j))...
           -1/Re*mu_T(j)*(Uy(j))^2;


Vxx      = zeros(5,5);
Vxx(2,2) = -1/Re*(2*mu(j)+la(j));
Vxx(3,3) = -1/Re*(mu(j));
Vxx(4,4) = -1/Re*(mu(j));
Vxx(5,5) = -1/Re/PrEc*ka(j);

Vyy      = zeros(5,5);
Vyy(2,2) = -1/Re*(mu(j));
Vyy(3,3) = -1/Re*(2*mu(j)+la(j));
Vyy(4,4) = -1/Re*(mu(j));
Vyy(5,5) = -1/Re/PrEc*ka(j);

Vzz      = zeros(5,5);
Vzz(2,2) = -1/Re*(mu(j));
Vzz(3,3) = -1/Re*(mu(j));
Vzz(4,4) = -1/Re*(2*mu(j)+la(j));
Vzz(5,5) = -1/Re/PrEc*ka(j);

Vxy      = zeros(5,5);
Vxy(2,3) = -1/Re*(mu(j)+la(j));
Vxy(3,2) = -1/Re*(mu(j)+la(j));


Vxz      = zeros(5,5);
Vxz(2,4) = -1/Re*(mu(j)+la(j));
Vxz(4,2) = -1/Re*(mu(j)+la(j));

Vyz      = zeros(5,5);
Vyz(3,4) = -1/Re*(mu(j)+la(j));
Vyz(4,3) = -1/Re*(mu(j)+la(j));

end



