function [alf,JF] = update_alpha_harmonics(Case,alf,Mesh,xi)

JF=zeros(Case.MN,1);
switch Case.method
    case {'Standard','IterFmn'}

        for m=0:Case.mmax
        for n=-Case.nmax:Case.nmax
            mn = mn2mn(Case,m,n);
            if  m == Case.m0 && n == Case.n0
            else 
                alf(xi,mn) = m/Case.m0*real(alf(xi,Case.mn0));
            end
            JF(mn)=trapz(Mesh.x(1:xi),alf(1:xi,mn));
        end
        end

    case 'allmodes'
        
        for m=0:Case.mmax
        for n=-Case.nmax:Case.nmax
            mn = mn2mn(Case,m,n);
            JF(mn)=trapz(Mesh.x(1:xi),alf(1:xi,mn));
        end
        end
    case {'twin'}
        mn0B = mn2mn(Case,Case.m0,-Case.n0);
        for m=0:Case.mmax
        for n=-Case.nmax:Case.nmax
            mn = mn2mn(Case,m,n);
            if  m == Case.m0 && (n == Case.n0 || n == -Case.n0)
            else
                alf(xi,mn) = m/Case.m0*real(alf(xi,Case.mn0))*0.5+...
                             m/Case.m0*real(alf(xi,    mn0B))*0.5;
            end
            JF(mn)=trapz(Mesh.x(1:xi),alf(1:xi,mn));
        end
        end
end


end

